/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.utility;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;

public class IOUtils {
    private static final int BUFFER_SIZE = 2048;

    public static void copyFile(File fileIn, File fileOut) throws IOException {
        FileInputStream is = new FileInputStream(fileIn);
        FileOutputStream os = new FileOutputStream(fileOut);
        IOUtils.copyStream(is, os);
        ((InputStream)is).close();
        ((OutputStream)os).close();
    }

    public static void copyFile(String fileIn, String fileOut) throws IOException {
        IOUtils.copyFile(new File(fileIn), new File(fileOut));
    }

    public static void copyStream(InputStream is, OutputStream os) throws IOException {
        byte[] buf = new byte[2048];
        int len;
        while ((len = is.read(buf)) != -1) {
            os.write(buf, 0, len);
        }
        return;
    }

    public static byte[] readAll(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copyStream(is, baos);
        is.close();
        return baos.toByteArray();
    }

    public static String readAll(Reader reader) throws IOException {
        int c;
        StringBuilder b = new StringBuilder();
        while ((c = reader.read()) != -1) {
            b.append((char)c);
        }
        return b.toString();
    }

    public static String readAllToString(InputStream is) throws IOException {
        byte[] b = IOUtils.readAll(is);
        return new String(b);
    }

    public static String readAllToString(InputStream is, String encoding) throws IOException {
        byte[] b = IOUtils.readAll(is);
        return new String(b, encoding);
    }

    public static void readAllToStringBuffer(InputStream is, String encoding, StringBuffer b) throws IOException {
        b.append(IOUtils.readAllToString(is, encoding));
    }

    public static void readAllToStringBuffer(InputStream is, StringBuffer b) throws IOException {
        b.append(IOUtils.readAllToString(is));
    }

    public static void readAllToStringBuilder(InputStream is, String encoding, StringBuilder b) throws IOException {
        b.append(IOUtils.readAllToString(is, encoding));
    }

    public static void readAllToStringBuilder(InputStream is, StringBuilder b) throws IOException {
        b.append(IOUtils.readAllToString(is));
    }

    public static void writeStringToFile(String value, String path) throws IOException {
        FileOutputStream fos = new FileOutputStream(path);
        fos.write(value.getBytes());
        fos.close();
    }

    private IOUtils() {
    }
}

