/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.util;

import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.MediaLocator;
import javax.media.NoPlayerException;
import javax.swing.JApplet;
import javax.swing.JFrame;
import net.sf.fmj.ejmf.toolkit.util.PlayerPanel;
import net.sf.fmj.ejmf.toolkit.util.Utility;
import net.sf.fmj.utility.FmjStartup;
import net.sf.fmj.utility.LoggerSingleton;

public abstract class PlayerDriver
extends JApplet {
    private static final Logger logger = LoggerSingleton.logger;
    private JFrame frame;
    private PlayerPanel playerpanel;

    public static void main(PlayerDriver driver, String[] args) {
        if (args.length == 0) {
            logger.severe("Media parameter not specified");
            return;
        }
        MediaLocator locator = Utility.appArgToMediaLocator(args[0]);
        try {
            driver.initialize(locator);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not connect to media: " + e, e);
            System.exit(1);
        }
        catch (NoPlayerException e) {
            logger.log(Level.WARNING, "Player not found for media: " + e, e);
            System.exit(1);
        }
    }

    public PlayerDriver() {
        this.getRootPane().putClientProperty("defeatSystemEventQueueCheck", Boolean.TRUE);
    }

    public abstract void begin();

    public void destroy() {
        super.destroy();
        if (this.getPlayerPanel() != null && this.getPlayerPanel().getPlayer() != null) {
            this.getPlayerPanel().getPlayer().stop();
            this.getPlayerPanel().getPlayer().close();
        }
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public PlayerPanel getPlayerPanel() {
        return this.playerpanel;
    }

    public void init() {
        FmjStartup.initApplet();
        String media = this.getParameter("MEDIA");
        if (media == null) {
            logger.warning("Error: MEDIA parameter not specified");
            return;
        }
        MediaLocator locator = Utility.appletArgToMediaLocator(this, media);
        try {
            this.playerpanel = new PlayerPanel(locator);
            this.playerpanel.getMediaPanel().addContainerListener(new ContainerListener(){

                public void componentAdded(ContainerEvent e) {
                    PlayerDriver.this.pack();
                }

                public void componentRemoved(ContainerEvent e) {
                    PlayerDriver.this.pack();
                }
            });
            this.getContentPane().add(this.playerpanel);
            this.pack();
            this.begin();
        }
        catch (IOException e) {
            logger.warning("Could not connect to media");
            this.destroy();
        }
        catch (NoPlayerException e) {
            logger.warning("Player not found for media");
            this.destroy();
        }
    }

    public void initialize(MediaLocator locator) throws IOException, NoPlayerException {
        this.playerpanel = new PlayerPanel(locator);
        this.frame = new JFrame(locator.toString());
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.playerpanel.getMediaPanel().addContainerListener(new ContainerListener(){

            public void componentAdded(ContainerEvent e) {
                PlayerDriver.this.frame.pack();
            }

            public void componentRemoved(ContainerEvent e) {
                PlayerDriver.this.frame.pack();
            }
        });
        Container c = this.frame.getContentPane();
        c.add(this.playerpanel);
        this.frame.pack();
        this.frame.setVisible(true);
        this.begin();
    }

    public void pack() {
        this.setSize(this.getPreferredSize());
        this.validate();
    }

    public void redraw() {
        this.frame.pack();
    }
}

