/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.csrc;

import java.util.Map;
import org.jitsi.impl.neomedia.AudioMediaStreamImpl;
import org.jitsi.impl.neomedia.MediaStreamImpl;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformer;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.impl.neomedia.transform.csrc.CsrcAudioLevelDispatcher;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.RTPExtension;

public class SsrcTransformEngine
extends SinglePacketTransformer
implements TransformEngine {
    public static final String DROP_MUTED_AUDIO_SOURCE_IN_REVERSE_TRANSFORM = SsrcTransformEngine.class.getName() + ".dropMutedAudioSourceInReverseTransform";
    private static boolean dropMutedAudioSourceInReverseTransform = false;
    private static final int MAX_DROPPED_MUTED_AUDIO_SOURCE_IN_REVERSE_TRANSFORM = 1023;
    private static boolean readConfigurationServicePropertiesOnce = true;
    private final CsrcAudioLevelDispatcher csrcAudioLevelDispatcher;
    private int droppedMutedAudioSourceInReverseTransform;
    private MediaDirection ssrcAudioLevelDirection = MediaDirection.INACTIVE;
    private byte ssrcAudioLevelExtID = (byte)-1;

    public SsrcTransformEngine(MediaStreamImpl mediaStream) {
        Map<Byte, RTPExtension> activeRTPExtensions = mediaStream.getActiveRTPExtensions();
        if (activeRTPExtensions != null && !activeRTPExtensions.isEmpty()) {
            for (Map.Entry<Byte, RTPExtension> e : activeRTPExtensions.entrySet()) {
                RTPExtension rtpExtension = e.getValue();
                String uri = rtpExtension.getURI().toString();
                if (!"urn:ietf:params:rtp-hdrext:ssrc-audio-level".equals(uri)) continue;
                Byte extID = e.getKey();
                this.setSsrcAudioLevelExtensionID(extID == null ? (byte)-1 : (byte)extID, rtpExtension.getDirection());
            }
        }
        SsrcTransformEngine.readConfigurationServicePropertiesOnce();
        this.csrcAudioLevelDispatcher = mediaStream instanceof AudioMediaStreamImpl ? new CsrcAudioLevelDispatcher((AudioMediaStreamImpl)mediaStream) : null;
    }

    @Override
    public void close() {
        if (this.csrcAudioLevelDispatcher != null) {
            this.csrcAudioLevelDispatcher.setMediaStream(null);
        }
    }

    @Override
    public PacketTransformer getRTCPTransformer() {
        return null;
    }

    @Override
    public PacketTransformer getRTPTransformer() {
        return this;
    }

    private static synchronized void readConfigurationServicePropertiesOnce() {
        if (!readConfigurationServicePropertiesOnce) {
            return;
        }
        readConfigurationServicePropertiesOnce = false;
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        if (cfg != null) {
            dropMutedAudioSourceInReverseTransform = cfg.getBoolean(DROP_MUTED_AUDIO_SOURCE_IN_REVERSE_TRANSFORM, dropMutedAudioSourceInReverseTransform);
        }
    }

    @Override
    public RawPacket reverseTransform(RawPacket pkt) {
        boolean dropPkt = false;
        if (this.ssrcAudioLevelExtID > 0 && this.ssrcAudioLevelDirection.allowsReceiving() && !pkt.isInvalid() && 2 == pkt.getVersion()) {
            byte level = pkt.extractSsrcAudioLevel(this.ssrcAudioLevelExtID);
            if (level == 127) {
                if (dropMutedAudioSourceInReverseTransform) {
                    dropPkt = this.droppedMutedAudioSourceInReverseTransform < 1023;
                } else {
                    pkt.setFlags(4 | pkt.getFlags());
                }
            }
            if (!dropPkt && this.csrcAudioLevelDispatcher != null && level >= 0) {
                long[] levels = new long[]{0xFFFFFFFFL & (long)pkt.getSSRC(), 127 - level};
                this.csrcAudioLevelDispatcher.addLevels(levels, pkt.getTimestamp());
            }
        }
        if (dropPkt) {
            ++this.droppedMutedAudioSourceInReverseTransform;
            return null;
        }
        this.droppedMutedAudioSourceInReverseTransform = 0;
        return pkt;
    }

    public void setSsrcAudioLevelExtensionID(byte extID, MediaDirection dir) {
        this.ssrcAudioLevelExtID = extID;
        this.ssrcAudioLevelDirection = dir;
    }

    @Override
    public RawPacket transform(RawPacket pkt) {
        return pkt;
    }
}

