/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform;

import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformer;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.util.Logger;

public class REDFilterTransformEngine
extends SinglePacketTransformer
implements TransformEngine {
    private static final Logger logger = Logger.getLogger(REDFilterTransformEngine.class);
    private boolean enabled = false;
    private byte redPayloadType = (byte)-1;

    public REDFilterTransformEngine(byte redPayloadType) {
        this.redPayloadType = redPayloadType;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public PacketTransformer getRTPTransformer() {
        return this;
    }

    @Override
    public PacketTransformer getRTCPTransformer() {
        return null;
    }

    @Override
    public void close() {
    }

    @Override
    public RawPacket transform(RawPacket pkt) {
        if (!this.enabled || this.redPayloadType == -1) {
            return pkt;
        }
        if (pkt == null || pkt.getBuffer() == null || pkt.getLength() == 0 || pkt.getPayloadType() != this.redPayloadType) {
            logger.debug("Ignoring non-RED packet.");
            return pkt;
        }
        byte[] buf = pkt.getBuffer();
        int off = pkt.getOffset();
        int len = pkt.getLength();
        if (buf == null || off + len > buf.length) {
            logger.debug("Ignoring invalid packet.");
            return pkt;
        }
        int hdrLen = pkt.getHeaderLength();
        if (off + hdrLen > len) {
            logger.debug("Ignoring invalid packet.");
            return pkt;
        }
        int idx = off + hdrLen;
        int pktCount = 1;
        while ((buf[idx] & 0x80) != 0) {
            ++pktCount;
            idx += 4;
        }
        idx = off + hdrLen;
        int payloadOffset = idx + (pktCount - 1) * 4 + 1;
        for (int i = 1; i < pktCount; ++i) {
            int blockLen = (buf[idx + 2] & 3) << 8 | buf[idx + 3];
            idx += 4;
            payloadOffset += blockLen;
        }
        int payloadLen = len - payloadOffset;
        if (payloadOffset + payloadLen > len) {
            logger.debug("Ignoring invalid primary packet carried in RED.");
            return pkt;
        }
        byte payloadType = (byte)(buf[idx] & 0x7F);
        pkt.setPayloadType(payloadType);
        System.arraycopy(buf, off, buf, payloadOffset - hdrLen, hdrLen);
        pkt.setOffset(payloadOffset - hdrLen);
        pkt.setLength(len - (payloadOffset - hdrLen - off));
        return pkt;
    }

    @Override
    public RawPacket reverseTransform(RawPacket pkt) {
        return pkt;
    }
}

