/*
 * Decompiled with CFR 0.152.
 */
package org.rubycoder.gsm;

import java.io.IOException;
import java.io.InputStream;
import org.rubycoder.gsm.GSMDecoder;
import org.rubycoder.gsm.InvalidGSMFrameException;

class GSMDecoderStream
extends InputStream {
    private static int[] lookup_table;
    private InputStream GSMStream;
    private int gsm_index = 0;
    private final byte[] gsm_frame;
    private final int[] buffer;
    private int buffer_index = 0;
    private int buffer_size = 0;
    private final GSMDecoder theDecoder;

    private static int[] create_lookup_table() {
        int[] nArray = new int[8192];
        for (int i = 0; i < 8192; ++i) {
            int n = i - 4096;
            nArray[i] = GSMDecoderStream.lin2mu(n <<= 3) & 0xFF;
        }
        return nArray;
    }

    private static byte lin2mu(int n) {
        int n2;
        if ((n >>= 2) < 0) {
            n = -n;
            n2 = 1;
        } else {
            n2 = 0;
        }
        for (int i = 0; i < 8; ++i) {
            int n3 = (32 << i + 1) - 32;
            if (n >= n3) continue;
            int n4 = i;
            int n5 = n - (32 << n4) + 32 >>> n4 + 1;
            return (byte)((n2 << 7 | n4 << 4 | n5 & 0xF) ^ 0xFF);
        }
        return (byte)(n2 << 8);
    }

    public GSMDecoderStream(InputStream inputStream) {
        if (lookup_table == null) {
            lookup_table = GSMDecoderStream.create_lookup_table();
        }
        this.gsm_index = 0;
        this.GSMStream = inputStream;
        this.buffer = new int[160];
        this.buffer_index = 0;
        this.buffer_size = 0;
        this.gsm_frame = new byte[33];
        this.theDecoder = new GSMDecoder();
    }

    public int available() throws IOException {
        try {
            int n = this.GSMStream.available() / 33;
        }
        catch (IOException iOException) {
            throw new IOException("Recieved IO Exception from source stream.");
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException("Source stream not open.");
        }
        n *= 160;
        return n += this.buffer_size - this.buffer_index;
    }

    public void close() {
        this.GSMStream = null;
    }

    public synchronized void mark(int n) {
    }

    public boolean markSupported() {
        return false;
    }

    public final int read() {
        int n = 0;
        if (this.buffer_index >= this.buffer_size) {
            try {
                n = this.GSMStream.read(this.gsm_frame);
            }
            catch (IOException iOException) {
                System.out.println("got io exception");
                this.close();
                return -1;
            }
            catch (NullPointerException nullPointerException) {
                return -1;
            }
            if (n < 33) {
                this.close();
                return -1;
            }
            try {
                this.theDecoder.decode(this.gsm_frame, this.buffer);
            }
            catch (InvalidGSMFrameException invalidGSMFrameException) {
                System.out.println("invalid frame");
                this.close();
                return -1;
            }
            this.buffer_index = 0;
            this.buffer_size = 160;
        }
        int n2 = lookup_table[(this.buffer[this.buffer_index++] >> 3) + 4096];
        return n2;
    }

    public final int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    public final int read(byte[] byArray, int n, int n2) {
        int n3;
        if (this.GSMStream == null) {
            return -1;
        }
        for (n3 = n; n3 < n2; ++n3) {
            int n4;
            block10: {
                int n5 = 0;
                if (this.buffer_index >= this.buffer_size) {
                    this.gsm_index = 0;
                    while (this.gsm_index < 33) {
                        try {
                            n5 = this.GSMStream.read(this.gsm_frame, this.gsm_index, 33 - this.gsm_index);
                        }
                        catch (IOException iOException) {
                            System.out.println("got io exception");
                            this.close();
                            n4 = -1;
                            break block10;
                        }
                        catch (NullPointerException nullPointerException) {
                            n4 = -1;
                            break block10;
                        }
                        if (n5 < 0) {
                            System.out.println("got eof");
                            this.close();
                            n4 = -1;
                            break block10;
                        }
                        this.gsm_index += n5;
                    }
                    try {
                        this.theDecoder.decode(this.gsm_frame, this.buffer);
                    }
                    catch (InvalidGSMFrameException invalidGSMFrameException) {
                        System.out.println("invalid frame");
                        this.close();
                        n4 = -1;
                        break block10;
                    }
                    this.buffer_index = 0;
                    this.buffer_size = 160;
                }
                n4 = lookup_table[(this.buffer[this.buffer_index++] >> 3) + 4096];
            }
            if (n4 < 0) break;
            byArray[n3] = (byte)n4;
        }
        return n3;
    }

    public void reset() {
    }

    public void skip(int n) {
    }
}

