/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import com.sun.media.util.Registry;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.VideoFormat;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.rtp.BasicJitterBufferBehaviour;
import net.sf.fmj.media.rtp.RTPSourceStream;

class VideoJitterBufferBehaviour
extends BasicJitterBufferBehaviour {
    private static final int BUF_CHECK_INTERVAL = 7000;
    private static final int DEFAULT_PKTS_TO_BUFFER = 90;
    private static final int DEFAULT_VIDEO_RATE = 15;
    private static final int FUDGE = 5;
    private static final VideoFormat H264 = new VideoFormat("h264/rtp");
    private static final int MIN_BUF_CHECK = 10000;
    private static final VideoFormat MPEG = new VideoFormat("mpeg/rtp");
    private int fps = 15;
    private int framesEst = 0;
    private long lastCheckTime = 0L;
    private long lastPktSeq = 0L;
    private int maxPktsToBuffer = 0;
    private int pktsEst;
    private int pktsPerFrame = 15;
    private int tooMuchBufferingCount = 0;
    private final int MIN_SIZE = Registry.getInt("video_jitter_buffer_MIN_SIZE", 4);

    public VideoJitterBufferBehaviour(RTPSourceStream rTPSourceStream) {
        super(rTPSourceStream);
        if (this.q.getCapacity() < this.MIN_SIZE) {
            this.grow(this.MIN_SIZE);
        }
    }

    private void cutByHalf() {
        int n = this.q.getCapacity() / 2;
        if (n > 0) {
            this.q.setCapacity(n);
        }
    }

    protected void dropFirstPkt() {
        if (MPEG.matches(this.stream.getFormat())) {
            this.dropMpegPkt();
        } else {
            super.dropFirstPkt();
        }
    }

    private void dropMpegPkt() {
        int n;
        int n2 = -1;
        int n3 = -1;
        int n4 = this.q.getFillCount();
        for (n = 0; n < n4; ++n) {
            int n5;
            Buffer buffer = this.q.getFill(n);
            byte[] byArray = (byte[])buffer.getData();
            int n6 = byArray[(n5 = buffer.getOffset()) + 2] & 7;
            if (n6 > 2) {
                n3 = n;
                break;
            }
            if (n6 != 2 || n2 != -1) continue;
            n2 = n;
        }
        if (n3 == -1) {
            n = n2 != -1 ? n2 : 0;
        }
        this.q.dropFill(n);
    }

    public boolean isAdaptive() {
        return true;
    }

    protected int monitorQSize(Buffer buffer) {
        int n;
        int n2;
        Object object;
        super.monitorQSize(buffer);
        this.pktsEst = this.lastPktSeq + 1L == buffer.getSequenceNumber() ? ++this.pktsEst : 1;
        this.lastPktSeq = buffer.getSequenceNumber();
        Format format = this.stream.getFormat();
        if (MPEG.matches(format)) {
            object = (byte[])buffer.getData();
            n = object[(n2 = buffer.getOffset()) + 2] & 7;
            if (n < 3 && (buffer.getFlags() & 0x800) != 0) {
                this.pktsPerFrame = (this.pktsPerFrame + this.pktsEst) / 2;
                this.pktsEst = 0;
            }
            this.fps = 30;
        } else if (H264.matches(format)) {
            this.pktsPerFrame = 300;
            this.fps = 15;
        }
        if ((buffer.getFlags() & 0x800) != 0) {
            this.pktsPerFrame = (this.pktsPerFrame + this.pktsEst) / 2;
            this.pktsEst = 0;
            ++this.framesEst;
            long l = System.currentTimeMillis();
            if (l - this.lastCheckTime >= 1000L) {
                this.lastCheckTime = l;
                this.fps = (this.fps + this.framesEst) / 2;
                this.framesEst = 0;
                if (this.fps > 30) {
                    this.fps = 30;
                }
            }
        }
        if ((object = (Object)this.getBufferControl()) != null) {
            n2 = (int)(object.getBufferLength() * (long)this.fps / 1000L);
            if (n2 <= 0) {
                n2 = 1;
            }
            n2 = this.pktsPerFrame * n2;
        } else {
            n2 = 90;
        }
        this.maxPktsToBuffer = H264.matches(format) ? 200 : (this.maxPktsToBuffer > 0 ? (this.maxPktsToBuffer + n2) / 2 : n2);
        n = this.q.getCapacity();
        int n3 = this.q.getFillCount();
        if (n > 10000 && n3 < n / 4) {
            if (this.tooMuchBufferingCount++ > this.pktsPerFrame * this.fps * 7000) {
                this.cutByHalf();
                this.tooMuchBufferingCount = 0;
            }
        } else if (n3 >= n / 2 && n < this.maxPktsToBuffer) {
            n2 = n + n / 2;
            if (n2 > this.maxPktsToBuffer) {
                n2 = this.maxPktsToBuffer;
            }
            this.q.setCapacity(n2 + 5);
            n = this.q.getCapacity();
            Log.comment("RTP video buffer size: " + n + " pkts, " + n2 * this.stats.getSizePerPacket() + " bytes.\n");
            this.tooMuchBufferingCount = 0;
        } else {
            this.tooMuchBufferingCount = 0;
        }
        return n2;
    }

    public void reset() {
        super.reset();
        this.tooMuchBufferingCount = 0;
    }
}

