/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.util.HashMap;
import java.util.Vector;
import javax.media.rtp.Participant;
import javax.media.rtp.RTPStream;
import javax.media.rtp.rtcp.Report;
import javax.media.rtp.rtcp.SourceDescription;
import net.sf.fmj.media.rtp.RTCPReport;

public class RTPParticipant
implements Participant {
    private Vector streams = new Vector();
    private HashMap rtcpReports = new HashMap();
    private String cName = "";
    protected HashMap sourceDescriptions = new HashMap();
    private boolean active = false;
    private int sdesSize = 0;
    protected long lastReportTime = System.currentTimeMillis();

    public RTPParticipant(String string) {
        this.cName = string;
        this.addSourceDescription(new SourceDescription(1, string, 1, false));
        this.addSourceDescription(new SourceDescription(2, string, 1, false));
    }

    public void addReport(Report report) {
        this.lastReportTime = System.currentTimeMillis();
        this.rtcpReports.put(new Long(report.getSSRC()), report);
        Vector vector = report.getSourceDescription();
        for (int i = 0; i < vector.size(); ++i) {
            this.addSourceDescription((SourceDescription)vector.get(i));
        }
        if (this.streams.size() == 0 && report instanceof RTCPReport) {
            ((RTCPReport)report).sourceDescriptions = new Vector(this.sourceDescriptions.values());
        }
    }

    protected void addSourceDescription(SourceDescription sourceDescription) {
        SourceDescription sourceDescription2 = (SourceDescription)this.sourceDescriptions.get(new Integer(sourceDescription.getType()));
        if (sourceDescription2 != null) {
            this.sdesSize -= sourceDescription2.getDescription().length();
            this.sdesSize -= 2;
        }
        this.sourceDescriptions.put(new Integer(sourceDescription.getType()), sourceDescription);
        this.sdesSize += 2;
        this.sdesSize += sourceDescription.getDescription().length();
    }

    protected void addStream(RTPStream rTPStream) {
        this.streams.add(rTPStream);
    }

    public String getCNAME() {
        return this.cName;
    }

    public long getLastReportTime() {
        return this.lastReportTime;
    }

    public Vector getReports() {
        return new Vector(this.rtcpReports.values());
    }

    public int getSdesSize() {
        return this.sdesSize;
    }

    public Vector getSourceDescription() {
        return new Vector(this.sourceDescriptions.values());
    }

    public Vector getStreams() {
        return this.streams;
    }

    public boolean isActive() {
        return this.active;
    }

    protected void removeStream(RTPStream rTPStream) {
        this.streams.remove(rTPStream);
    }

    protected void setActive(boolean bl) {
        this.active = bl;
    }
}

