/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import java.lang.reflect.Method;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.PlugIn;
import javax.media.PlugInManager;
import javax.media.format.VideoFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicPlugIn
implements PlugIn {
    private static final boolean DEBUG = false;
    protected Object[] controls = new Control[0];
    private static boolean jdkInit = false;
    private static Method forName3ArgsM;
    private static ClassLoader systemClassLoader;
    private static Method getContextClassLoaderM;

    private static boolean checkIfJDK12() {
        if (jdkInit) {
            return forName3ArgsM != null;
        }
        jdkInit = true;
        try {
            forName3ArgsM = Class.class.getMethod("forName", String.class, Boolean.TYPE, ClassLoader.class);
            Method method = ClassLoader.class.getMethod("getSystemClassLoader", new Class[0]);
            systemClassLoader = (ClassLoader)method.invoke(ClassLoader.class, new Object[0]);
            getContextClassLoaderM = Thread.class.getMethod("getContextClassLoader", new Class[0]);
            return true;
        }
        catch (Throwable throwable) {
            forName3ArgsM = null;
            return false;
        }
    }

    public static Class<?> getClassForName(String string) throws ClassNotFoundException {
        block9: {
            try {
                return Class.forName(string);
            }
            catch (Exception exception) {
                if (!BasicPlugIn.checkIfJDK12()) {
                    throw new ClassNotFoundException(exception.getMessage());
                }
            }
            catch (Error error) {
                if (BasicPlugIn.checkIfJDK12()) break block9;
                throw error;
            }
        }
        try {
            return (Class)forName3ArgsM.invoke(Class.class, string, new Boolean(true), systemClassLoader);
        }
        catch (Throwable throwable) {
            try {
                ClassLoader classLoader = (ClassLoader)getContextClassLoaderM.invoke((Object)Thread.currentThread(), new Object[0]);
                return (Class)forName3ArgsM.invoke(Class.class, string, new Boolean(true), classLoader);
            }
            catch (Exception exception) {
                throw new ClassNotFoundException(exception.getMessage());
            }
            catch (Error error) {
                throw error;
            }
        }
    }

    public static Format matches(Format format, Format[] formatArray) {
        for (int i = 0; i < formatArray.length; ++i) {
            if (!format.matches(formatArray[i])) continue;
            return formatArray[i];
        }
        return null;
    }

    public static boolean plugInExists(String string, int n) {
        Vector vector = PlugInManager.getPlugInList(null, null, n);
        for (int i = 0; i < vector.size(); ++i) {
            if (!string.equals(vector.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    protected void error() {
        throw new RuntimeException(this.getClass().getName() + " PlugIn error");
    }

    @Override
    public Object getControl(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            Object[] objectArray = this.getControls();
            for (int i = 0; i < objectArray.length; ++i) {
                if (!clazz.isInstance(objectArray[i])) continue;
                return objectArray[i];
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Object[] getControls() {
        return this.controls;
    }

    protected Object getInputData(Buffer buffer) {
        return buffer.getData();
    }

    protected final long getNativeData(Object object) {
        return 0L;
    }

    protected Object getOutputData(Buffer buffer) {
        return buffer.getData();
    }

    protected byte[] validateByteArraySize(Buffer buffer, int n) {
        byte[] byArray;
        Object object = buffer.getData();
        if (object instanceof byte[]) {
            byArray = (byte[])object;
            if (byArray.length >= n) {
                return byArray;
            }
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            byArray = byArray2;
        } else {
            byArray = new byte[n];
        }
        buffer.setData(byArray);
        return byArray;
    }

    protected Object validateData(Buffer buffer, int n, boolean bl) {
        Format format = buffer.getFormat();
        Class<?> clazz = format.getDataType();
        if (n < 1 && format != null && format instanceof VideoFormat) {
            n = ((VideoFormat)format).getMaxDataLength();
        }
        if (clazz == Format.byteArray) {
            return this.validateByteArraySize(buffer, n);
        }
        if (clazz == Format.shortArray) {
            return this.validateShortArraySize(buffer, n);
        }
        if (clazz == Format.intArray) {
            return this.validateIntArraySize(buffer, n);
        }
        System.err.println("Error in validateData");
        return null;
    }

    protected int[] validateIntArraySize(Buffer buffer, int n) {
        int[] nArray;
        Object object = buffer.getData();
        if (object instanceof int[]) {
            nArray = (int[])object;
            if (nArray.length >= n) {
                return nArray;
            }
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            nArray = nArray2;
        } else {
            nArray = new int[n];
        }
        buffer.setData(nArray);
        return nArray;
    }

    protected short[] validateShortArraySize(Buffer buffer, int n) {
        short[] sArray;
        Object object = buffer.getData();
        if (object instanceof short[]) {
            sArray = (short[])object;
            if (sArray.length >= n) {
                return sArray;
            }
            short[] sArray2 = new short[n];
            System.arraycopy(sArray, 0, sArray2, 0, sArray.length);
            sArray = sArray2;
        } else {
            sArray = new short[n];
        }
        buffer.setData(sArray);
        return sArray;
    }
}

