/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import com.voxeo.utils.ByteFormat;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.List;

public class MemoryMonitor {
    public static void main(String[] args) {
        System.out.println("Memory Usage " + MemoryMonitor.getAsText());
    }

    public static String getAsText() {
        long usedHeap = 0L;
        long maxHeap = 0L;
        StringBuilder builder = new StringBuilder();
        ByteFormat byteFormatter = new ByteFormat(false);
        List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean pool : memoryPoolMXBeans) {
            MemoryUsage usage = pool.getUsage();
            if (pool.getType() == MemoryType.HEAP) {
                usedHeap += usage.getUsed();
                maxHeap += usage.getMax();
            }
            builder.append("[" + pool.getName() + " " + byteFormatter.format(usage.getUsed()) + "/" + byteFormatter.format(usage.getMax()) + "] ");
        }
        builder.insert(0, "[Total Heap " + byteFormatter.format(usedHeap) + "/" + byteFormatter.format(maxHeap) + "] ");
        return builder.toString();
    }
}

