/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.sftp;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import com.voxeo.logging.Loggerf;
import com.voxeo.sftp.JCraftSftpClient;
import com.voxeo.sftp.SshUserInfo;
import org.apache.commons.pool.BasePoolableObjectFactory;

public class JCraftSftpClientObjectFactory
extends BasePoolableObjectFactory {
    private final Loggerf log = Loggerf.getLogger(JCraftSftpClientObjectFactory.class);
    private String host;
    private int port;
    private String username;
    private String keyFilePath;
    private int socketTimeout = 30000;

    public void destroyObject(Object object) throws Exception {
        JCraftSftpClient client = (JCraftSftpClient)object;
        if (client != null) {
            this.log.trace("Destroying SFTP Client %s", client);
            try {
                client.close();
            }
            catch (Exception e) {
                this.log.error("Error closing SFTP client", e);
            }
            try {
                Session session = client.getSession();
                session.disconnect();
            }
            catch (Exception e) {
                this.log.error("Error closing SSH session", e);
            }
        }
    }

    public Object makeObject() throws Exception {
        this.log.trace("Making new SFTP client for %s@%s:%d with so timeout %d", this.username, this.host, this.port, this.socketTimeout);
        JSch jsch = new JSch();
        jsch.addIdentity(this.keyFilePath);
        Session ssh = jsch.getSession(this.username, this.host, this.port);
        ssh.setTimeout(this.socketTimeout);
        SshUserInfo userInfo = new SshUserInfo();
        userInfo.setKeyfile(this.keyFilePath);
        userInfo.setName(this.username);
        userInfo.setPassphrase("");
        userInfo.setTrust(true);
        ssh.setUserInfo((UserInfo)userInfo);
        ssh.connect();
        JCraftSftpClient result = new JCraftSftpClient(ssh, this.socketTimeout);
        return result;
    }

    public boolean validateObject(Object object) {
        JCraftSftpClient client = (JCraftSftpClient)object;
        this.log.trace("validating sftp client %s", client);
        boolean result = client.isConnected();
        if (result) {
            try {
                client.stat("/");
            }
            catch (Exception e) {
                this.log.debug("SFTP client failed validation", e);
                result = false;
            }
        }
        return result;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getKeyFilePath() {
        return this.keyFilePath;
    }

    public void setKeyFilePath(String keyFilePath) {
        this.keyFilePath = keyFilePath;
    }

    public void setSocketTimeoutMs(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }
}

