/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.instrumentation;

import com.voxeo.instrumentation.DefaultInstrumentable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.configuration.DefaultConfigurationSerializer;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.Log4JLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.excalibur.instrument.CounterInstrument;
import org.apache.excalibur.instrument.Instrument;
import org.apache.excalibur.instrument.Instrumentable;
import org.apache.excalibur.instrument.ValueInstrument;
import org.apache.excalibur.instrument.manager.DefaultInstrumentManager;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class VInstrumentManager {
    private static VInstrumentManager _instance;
    private DefaultInstrumentManager _mgr;
    private String _name = "Default";
    private boolean _formatStateFile = true;
    private long _lastInitFail = -1L;

    public static VInstrumentManager getInstance() {
        return VInstrumentManager.getInstance(null);
    }

    public static synchronized VInstrumentManager getInstance(String name) {
        if (null == _instance) {
            VInstrumentManager vim = new VInstrumentManager();
            vim.setName(null == name ? System.getProperty("vim.name") : name);
            vim.setFormatStateFile(Boolean.getBoolean("vim.format-state-file"));
            vim.init();
        }
        return _instance;
    }

    public static synchronized boolean destroy() {
        if (null == _instance) {
            return false;
        }
        VInstrumentManager._instance._mgr.dispose();
        _instance = null;
        return true;
    }

    public void setName(String name) {
        if (null != name) {
            this._name = name;
        }
    }

    public void setFormatStateFile(boolean formatStateFile) {
        this._formatStateFile = formatStateFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (null == _instance && (-1L == this._lastInitFail || System.currentTimeMillis() > this._lastInitFail + 300000L)) {
                this._lastInitFail = -1L;
                org.apache.log4j.Logger logger = LogManager.getLogger((String)this.getClass().getName());
                logger.setLevel(Level.WARN);
                Log4JLogger log = new Log4JLogger((Category)logger);
                try {
                    FileInputStream is;
                    _instance = this;
                    this._mgr = new FormattingInstrumentManager(this._formatStateFile);
                    this._mgr.setInstrumentableName(this._name);
                    this._mgr.enableLogging((Logger)log);
                    DefaultContext context = new DefaultContext();
                    try {
                        this._mgr.contextualize((Context)context);
                    }
                    catch (ContextException e) {
                        throw new RuntimeException("Failed to contextualize instrument manager!", e);
                    }
                    File dir = new File(System.getProperty("prophecy.home.dir"), "config");
                    String instrKey = "instruments." + this._name;
                    InputStream rs = this.getClass().getResourceAsStream("../../../instruments.properties");
                    Properties instrProps = new Properties();
                    try {
                        instrProps.load(rs);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to read instrument properties!", e);
                    }
                    String filename = instrProps.getProperty(instrKey);
                    if (null == filename) {
                        throw new RuntimeException("Missing required property: " + instrKey);
                    }
                    File file = new File(dir, filename);
                    try {
                        is = new FileInputStream(file);
                    }
                    catch (FileNotFoundException e) {
                        throw new RuntimeException("Failed to read instrument config from: " + file.getAbsolutePath());
                    }
                    try {
                        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder(false);
                        Configuration config = builder.build(new InputSource(is));
                        this._mgr.configure(config);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to configure instrument manager!", e);
                    }
                    try {
                        this._mgr.initialize();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to initialize instrument manager!", e);
                    }
                }
                catch (RuntimeException e) {
                    log.warn("Instruments for manager '" + this._name + "' are unavailable!", (Throwable)e);
                    _instance = null;
                    this._lastInitFail = System.currentTimeMillis();
                }
            }
        }
    }

    public static DefaultInstrumentable createInstrumentable(String instrumentableName) {
        DefaultInstrumentable defaultInstrumentable = new DefaultInstrumentable();
        defaultInstrumentable.setInstrumentableName(instrumentableName);
        return defaultInstrumentable;
    }

    public static ValueInstrument addValueInstrument(DefaultInstrumentable ible, String instrName) {
        ValueInstrument instr = new ValueInstrument(instrName);
        ible.addInstrument((Instrument)instr);
        return instr;
    }

    public static CounterInstrument addCounterInstrument(DefaultInstrumentable ible, String instrName) {
        CounterInstrument instr = new CounterInstrument(instrName);
        ible.addInstrument((Instrument)instr);
        return instr;
    }

    public void registerInstrumentable(Instrumentable instrumentable) {
        try {
            this._mgr.registerInstrumentable(instrumentable, instrumentable.getInstrumentableName());
        }
        catch (Exception e) {
            String msg = "Failed registering instrumentable: ";
            throw new RuntimeException("Failed registering instrumentable: " + instrumentable.getInstrumentableName(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._name).append(this._formatStateFile ? "(format)" : "").append(this._mgr.toString());
        return sb.toString();
    }

    private static class FormattingInstrumentManager
    extends DefaultInstrumentManager {
        private final boolean _formatStateFile;

        private FormattingInstrumentManager(boolean formatStateFile) {
            this._formatStateFile = formatStateFile;
        }

        public void saveStateToStream(OutputStream os) throws Exception {
            Configuration stateConfig = this.saveStateToConfiguration();
            DefaultConfigurationSerializer serializer = new DefaultConfigurationSerializer();
            if (this._formatStateFile) {
                String stateXML = serializer.serialize(stateConfig);
                Document doc = FormattingInstrumentManager.parse(stateXML);
                String formattedXML = FormattingInstrumentManager.transform(doc);
                try {
                    os.write(formattedXML.getBytes());
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to write instrument data!", e);
                }
            } else {
                serializer.serialize(os, stateConfig);
            }
        }

        private static Document parse(String stateXML) {
            Document doc;
            StringReader sr = new StringReader(stateXML);
            try {
                InputSource is = new InputSource(sr);
                doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to parse: " + stateXML + "!", t);
            }
            finally {
                sr.close();
            }
            return doc;
        }

        private static String transform(Document doc) throws TransformerConfigurationException {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("omit-xml-declaration", "no");
            DocumentType docType = doc.getDoctype();
            if (null != docType) {
                String publicId = docType.getPublicId();
                String systemId = docType.getSystemId();
                if (null != publicId) {
                    transformer.setOutputProperty("doctype-public", publicId);
                }
                if (null != systemId) {
                    transformer.setOutputProperty("doctype-system", systemId);
                }
            }
            try {
                Element root = doc.getDocumentElement();
                StringWriter stringWriter = new StringWriter();
                ArrayList<Node> nodeList = new ArrayList<Node>();
                for (int i = 0; i < root.getChildNodes().getLength(); ++i) {
                    nodeList.add(root.getChildNodes().item(i));
                }
                while (!nodeList.isEmpty()) {
                    Node current = (Node)nodeList.remove(0);
                    for (int i = 0; i < current.getChildNodes().getLength(); ++i) {
                        nodeList.add(current.getChildNodes().item(i));
                    }
                    if (4 != current.getNodeType()) continue;
                    current.setNodeValue(current.getNodeValue().replaceAll("\r\n", "\n"));
                }
                transformer.transform(new DOMSource(root), new StreamResult(stringWriter));
                return stringWriter.toString();
            }
            catch (TransformerException e) {
                throw new RuntimeException("Failed to transform document!", e);
            }
        }
    }
}

