/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.portaudio;

import org.jitsi.impl.neomedia.portaudio.Pa;

public class PortAudioException
extends Exception {
    private static final long serialVersionUID = 0L;
    private final long errorCode;
    private final Pa.HostApiTypeId hostApiType;

    public PortAudioException(String message) {
        this(message, 0L, -1);
    }

    public PortAudioException(String message, long errorCode, int hostApiType) {
        super(message);
        this.errorCode = errorCode;
        this.hostApiType = hostApiType < 0 ? null : Pa.HostApiTypeId.valueOf(hostApiType);
    }

    public long getErrorCode() {
        return this.errorCode;
    }

    public Pa.HostApiTypeId getHostApiType() {
        return this.hostApiType;
    }

    @Override
    public String toString() {
        String hostApiTypeStr;
        String s = super.toString();
        long errorCode = this.getErrorCode();
        String errorCodeStr = errorCode == 0L ? null : Long.toString(errorCode);
        Pa.HostApiTypeId hostApiType = this.getHostApiType();
        String string = hostApiTypeStr = hostApiType == null ? null : hostApiType.toString();
        if (errorCodeStr != null || hostApiTypeStr != null) {
            StringBuilder sb = new StringBuilder(s);
            sb.append(": ");
            if (errorCodeStr != null) {
                sb.append("errorCode= ");
                sb.append(errorCodeStr);
                sb.append(';');
            }
            if (hostApiTypeStr != null) {
                if (errorCodeStr != null) {
                    sb.append(' ');
                }
                sb.append("hostApiType= ");
                sb.append(hostApiTypeStr);
                sb.append(';');
            }
            s = sb.toString();
        }
        return s;
    }
}

