/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.protocol;

import java.io.IOException;
import javax.media.Time;
import javax.media.protocol.PushBufferDataSource;

public abstract class BasicPushBufferDataSource
extends PushBufferDataSource {
    protected Object[] controls = new Object[0];
    protected boolean started = false;
    protected String contentType = "content/unknown";
    protected boolean connected = false;
    protected Time duration = DURATION_UNKNOWN;

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.connected = true;
    }

    public void disconnect() {
        try {
            if (this.started) {
                this.stop();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.connected = false;
    }

    public String getContentType() {
        if (!this.connected) {
            System.err.println("Error: DataSource not connected");
            return null;
        }
        return this.contentType;
    }

    public Object getControl(String controlType) {
        try {
            Class<?> cls = Class.forName(controlType);
            Object[] cs = this.getControls();
            for (int i = 0; i < cs.length; ++i) {
                if (!cls.isInstance(cs[i])) continue;
                return cs[i];
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object[] getControls() {
        return this.controls;
    }

    public Time getDuration() {
        return this.duration;
    }

    public void start() throws IOException {
        if (!this.connected) {
            throw new Error("DataSource must be connected before it can be started");
        }
        if (this.started) {
            return;
        }
        this.started = true;
    }

    public void stop() throws IOException {
        if (!this.connected || !this.started) {
            return;
        }
        this.started = false;
    }
}

