/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import javax.media.Buffer;
import javax.media.Clock;
import javax.media.Drainable;
import javax.media.Format;
import javax.media.Prefetchable;
import javax.media.Renderer;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.renderer.VideoRenderer;
import net.sf.fmj.filtergraph.SimpleGraphBuilder;
import net.sf.fmj.media.BasicInputConnector;
import net.sf.fmj.media.BasicSinkModule;
import net.sf.fmj.media.Connector;
import net.sf.fmj.media.InputConnector;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.PlaybackEngine;
import net.sf.fmj.media.RenderThread;
import net.sf.fmj.media.renderer.audio.AudioRenderer;
import net.sf.fmj.media.rtp.util.RTPTimeBase;
import net.sf.fmj.media.rtp.util.RTPTimeReporter;
import net.sf.fmj.media.util.ElapseTime;

public class BasicRendererModule
extends BasicSinkModule
implements RTPTimeReporter {
    protected PlaybackEngine engine;
    protected Renderer renderer;
    protected InputConnector ic;
    protected int framesPlayed = 0;
    protected float frameRate = 30.0f;
    protected boolean framesWereBehind = false;
    protected boolean prefetching = false;
    protected boolean started = false;
    private boolean opened = false;
    private int chunkSize = Integer.MAX_VALUE;
    private long lastDuration = 0L;
    private RTPTimeBase rtpTimeBase = null;
    private String rtpCNAME = null;
    RenderThread renderThread;
    private Object prefetchSync = new Object();
    private ElapseTime elapseTime = new ElapseTime();
    private long LEEWAY = 10L;
    private long lastRendered = 0L;
    private boolean failed = false;
    private boolean notToDropNext = false;
    private Buffer storedBuffer = null;
    private boolean checkRTP = false;
    private boolean noSync = false;
    final float MAX_RATE = 1.05f;
    final float RATE_INCR = 0.01f;
    final int FLOW_LIMIT = 20;
    boolean overMsg = false;
    int overflown = 10;
    float rate = 1.0f;
    long systemErr = 0L;
    static final long RTP_TIME_MARGIN = 2000000000L;
    boolean rtpErrMsg = false;
    long lastTimeStamp;
    static final int MAX_CHUNK_SIZE = 16;
    AudioFormat ulawFormat = new AudioFormat("ULAW");
    AudioFormat linearFormat = new AudioFormat("LINEAR");

    protected BasicRendererModule(Renderer r) {
        this.setRenderer(r);
        this.ic = new BasicInputConnector();
        if (r instanceof VideoRenderer) {
            this.ic.setSize(4);
        } else {
            this.ic.setSize(1);
        }
        this.ic.setModule(this);
        this.registerInputConnector("input", this.ic);
        this.setProtocol(1);
    }

    public void abortPrefetch() {
        this.renderThread.pause();
        this.renderer.close();
        this.prefetching = false;
        this.opened = false;
    }

    private int computeChunkSize(Format format) {
        if (format instanceof AudioFormat && (this.ulawFormat.matches(format) || this.linearFormat.matches(format))) {
            AudioFormat af = (AudioFormat)format;
            int units = af.getSampleSizeInBits() * af.getChannels() / 8;
            if (units == 0) {
                units = 1;
            }
            int chunks = (int)af.getSampleRate() * units / 16;
            return chunks / units * units;
        }
        return Integer.MAX_VALUE;
    }

    public void doClose() {
        this.renderThread.kill();
        if (this.renderer != null) {
            this.renderer.close();
        }
        if (this.rtpTimeBase != null) {
            RTPTimeBase.remove(this, this.rtpCNAME);
            this.rtpTimeBase = null;
        }
    }

    public void doDealloc() {
        this.renderer.close();
    }

    public void doFailedPrefetch() {
        this.renderThread.pause();
        this.renderer.close();
        this.opened = false;
        this.prefetching = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void donePrefetch() {
        Object object = this.prefetchSync;
        synchronized (object) {
            if (!this.started && this.prefetching) {
                this.renderThread.pause();
            }
            this.prefetching = false;
        }
        if (this.moduleListener != null) {
            this.moduleListener.bufferPrefetched(this);
        }
    }

    public void doneReset() {
        this.renderThread.pause();
    }

    public boolean doPrefetch() {
        super.doPrefetch();
        if (!this.opened) {
            try {
                this.renderer.open();
            }
            catch (ResourceUnavailableException e) {
                this.prefetchFailed = true;
                return false;
            }
            this.prefetchFailed = false;
            this.opened = true;
        }
        if (!((PlaybackEngine)this.controller).prefetchEnabled) {
            return true;
        }
        this.prefetching = true;
        this.renderThread.start();
        return true;
    }

    protected boolean doProcess() {
        if ((this.started || this.prefetching) && this.stopTime > -1L && this.elapseTime.value >= this.stopTime) {
            if (this.renderer instanceof Drainable) {
                ((Drainable)((Object)this.renderer)).drain();
            }
            this.doStop();
            if (this.moduleListener != null) {
                this.moduleListener.stopAtTime(this);
            }
        }
        Buffer buffer = this.storedBuffer != null ? this.storedBuffer : this.ic.getValidBuffer();
        if (!this.checkRTP) {
            if ((buffer.getFlags() & 0x1000) != 0) {
                String key = this.engine.getCNAME();
                if (key != null) {
                    this.rtpTimeBase = RTPTimeBase.find(this, key);
                    this.rtpCNAME = key;
                    if (this.ic.getFormat() instanceof AudioFormat) {
                        Log.comment("RTP master time set: " + this.renderer + "\n");
                        this.rtpTimeBase.setMaster(this);
                    }
                    this.checkRTP = true;
                    this.noSync = false;
                } else {
                    this.noSync = true;
                }
            } else {
                this.checkRTP = true;
            }
        }
        this.lastTimeStamp = buffer.getTimeStamp();
        if (this.failed || this.resetted) {
            if ((buffer.getFlags() & 0x200) != 0) {
                this.resetted = false;
                this.renderThread.pause();
                if (this.moduleListener != null) {
                    this.moduleListener.resetted(this);
                }
            }
            this.storedBuffer = null;
            this.ic.readReport();
            return true;
        }
        boolean rtn = this.scheduleBuffer(buffer);
        if (this.storedBuffer == null && buffer.isEOM()) {
            if (this.prefetching) {
                this.donePrefetch();
            }
            if ((buffer.getFlags() & 0x40) == 0 && buffer.getTimeStamp() > 0L && buffer.getDuration() > 0L && buffer.getFormat() != null && !(buffer.getFormat() instanceof AudioFormat) && !this.noSync) {
                this.waitForPT(buffer.getTimeStamp() + this.lastDuration);
            }
            this.storedBuffer = null;
            this.ic.readReport();
            this.doStop();
            if (this.moduleListener != null) {
                this.moduleListener.mediaEnded(this);
            }
            return true;
        }
        if (this.storedBuffer == null) {
            this.ic.readReport();
        }
        return rtn;
    }

    public boolean doRealize() {
        this.chunkSize = this.computeChunkSize(this.ic.getFormat());
        this.renderThread = new RenderThread(this);
        this.engine = (PlaybackEngine)this.getController();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() {
        super.doStart();
        if (!(this.renderer instanceof Clock)) {
            this.renderer.start();
        }
        this.prerolling = false;
        this.started = true;
        Object object = this.prefetchSync;
        synchronized (object) {
            this.prefetching = false;
            this.renderThread.start();
        }
    }

    public void doStop() {
        this.started = false;
        this.prefetching = true;
        super.doStop();
        if (this.renderer != null && !(this.renderer instanceof Clock)) {
            this.renderer.stop();
        }
    }

    public Object getControl(String s) {
        return this.renderer.getControl(s);
    }

    public Object[] getControls() {
        return this.renderer.getControls();
    }

    public int getFramesPlayed() {
        return this.framesPlayed;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public long getRTPTime() {
        if (this.ic.getFormat() instanceof AudioFormat) {
            if (this.renderer instanceof AudioRenderer) {
                return this.lastTimeStamp - ((AudioRenderer)this.renderer).getLatency();
            }
            return this.lastTimeStamp;
        }
        return this.lastTimeStamp;
    }

    private long getSyncTime(long pts) {
        if (this.rtpTimeBase != null) {
            if (this.rtpTimeBase.getMaster() == this.getController()) {
                return pts;
            }
            long ts = this.rtpTimeBase.getNanoseconds();
            if (ts > pts + 2000000000L || ts < pts - 2000000000L) {
                if (!this.rtpErrMsg) {
                    Log.comment("Cannot perform RTP sync beyond a difference of: " + (ts - pts) / 1000000L + " msecs.\n");
                    this.rtpErrMsg = true;
                }
                return pts;
            }
            return ts;
        }
        return this.getMediaNanoseconds();
    }

    private boolean handleFormatChange(Format format) {
        float fr;
        if (!this.reinitRenderer(format)) {
            this.storedBuffer = null;
            this.failed = true;
            if (this.moduleListener != null) {
                this.moduleListener.formatChangedFailure(this, this.ic.getFormat(), format);
            }
            return false;
        }
        Format oldFormat = this.ic.getFormat();
        this.ic.setFormat(format);
        if (this.moduleListener != null) {
            this.moduleListener.formatChanged(this, oldFormat, format);
        }
        if (format instanceof VideoFormat && (fr = ((VideoFormat)format).getFrameRate()) != -1.0f) {
            this.frameRate = fr;
        }
        return true;
    }

    protected boolean handlePreroll(Buffer buf) {
        if (buf.getFormat() instanceof AudioFormat ? !this.hasReachAudioPrerollTarget(buf) : (buf.getFlags() & 0x60) == 0 && buf.getTimeStamp() >= 0L && buf.getTimeStamp() < this.getSyncTime(buf.getTimeStamp())) {
            return false;
        }
        this.prerolling = false;
        return true;
    }

    private boolean hasReachAudioPrerollTarget(Buffer buf) {
        long target = this.getSyncTime(buf.getTimeStamp());
        this.elapseTime.update(buf.getLength(), buf.getTimeStamp(), buf.getFormat());
        if (this.elapseTime.value >= target) {
            long remain = ElapseTime.audioTimeToLen(this.elapseTime.value - target, (AudioFormat)buf.getFormat());
            int offset = buf.getOffset() + buf.getLength() - (int)remain;
            if (offset >= 0) {
                buf.setOffset(offset);
                buf.setLength((int)remain);
            }
            this.elapseTime.setValue(target);
            return true;
        }
        return false;
    }

    public boolean isThreaded() {
        return true;
    }

    protected void process() {
    }

    public int processBuffer(Buffer buffer) {
        int remain = buffer.getLength();
        int offset = buffer.getOffset();
        int rc = 0;
        boolean isEOM = false;
        if (this.renderer instanceof Clock) {
            this.overflown = (buffer.getFlags() & 0x2000) != 0 ? ++this.overflown : --this.overflown;
            if (this.overflown > 20) {
                if (this.rate < 1.05f) {
                    this.rate += 0.01f;
                    this.renderer.stop();
                    ((Clock)((Object)this.renderer)).setRate(this.rate);
                    this.renderer.start();
                    if (!this.overMsg) {
                        Log.comment("Data buffers overflown.  Adjust rendering speed up to 5 % to compensate");
                        this.overMsg = true;
                    }
                }
                this.overflown = 10;
            } else if (this.overflown <= 0) {
                if (this.rate > 1.0f) {
                    this.rate -= 0.01f;
                    this.renderer.stop();
                    ((Clock)((Object)this.renderer)).setRate(this.rate);
                    this.renderer.start();
                }
                this.overflown = 10;
            }
        }
        do {
            int len;
            block25: {
                if (this.stopTime > -1L && this.elapseTime.value >= this.stopTime) {
                    if (this.prefetching) {
                        this.donePrefetch();
                    }
                    return 2;
                }
                if (remain <= this.chunkSize || this.prerolling) {
                    if (isEOM) {
                        isEOM = false;
                        buffer.setEOM(true);
                    }
                    len = remain;
                } else {
                    if (buffer.isEOM()) {
                        isEOM = true;
                        buffer.setEOM(false);
                    }
                    len = this.chunkSize;
                }
                buffer.setLength(len);
                buffer.setOffset(offset);
                if (this.prerolling && !this.handlePreroll(buffer)) {
                    offset += len;
                    remain -= len;
                    continue;
                }
                try {
                    rc = this.renderer.process(buffer);
                }
                catch (Throwable e) {
                    Log.dumpStack(e);
                    if (this.moduleListener == null) break block25;
                    this.moduleListener.internalErrorOccurred(this);
                }
            }
            if ((rc & 8) != 0) {
                this.failed = true;
                if (this.moduleListener != null) {
                    this.moduleListener.pluginTerminated(this);
                }
                return rc;
            }
            if ((rc & 1) != 0) {
                buffer.setDiscard(true);
                if (this.prefetching) {
                    this.donePrefetch();
                }
                return rc;
            }
            if ((rc & 2) != 0) {
                len -= buffer.getLength();
            }
            offset += len;
            remain -= len;
            if (this.prefetching && (!(this.renderer instanceof Prefetchable) || ((Prefetchable)((Object)this.renderer)).isPrefetched())) {
                isEOM = false;
                buffer.setEOM(false);
                this.donePrefetch();
                break;
            }
            this.elapseTime.update(len, buffer.getTimeStamp(), buffer.getFormat());
        } while (remain > 0 && !this.resetted);
        if (isEOM) {
            buffer.setEOM(true);
        }
        buffer.setLength(remain);
        buffer.setOffset(offset);
        if (rc == 0) {
            ++this.framesPlayed;
        }
        return rc;
    }

    protected boolean reinitRenderer(Format input) {
        if (this.renderer != null && this.renderer.setInputFormat(input) != null) {
            return true;
        }
        if (this.started) {
            this.renderer.stop();
            this.renderer.reset();
        }
        this.renderer.close();
        this.renderer = null;
        Renderer r = SimpleGraphBuilder.findRenderer(input);
        if (r == null) {
            return false;
        }
        this.setRenderer(r);
        if (this.started) {
            this.renderer.start();
        }
        this.chunkSize = this.computeChunkSize(input);
        return true;
    }

    public void reset() {
        super.reset();
        this.prefetching = false;
    }

    public void resetFramesPlayed() {
        this.framesPlayed = 0;
    }

    protected boolean scheduleBuffer(Buffer buf) {
        int rc = 0;
        Format format = buf.getFormat();
        if (format == null) {
            format = this.ic.getFormat();
            buf.setFormat(format);
        }
        if (!(format == this.ic.getFormat() || format.equals(this.ic.getFormat()) || buf.isDiscard() || this.handleFormatChange(format))) {
            return false;
        }
        if ((buf.getFlags() & 0x400) != 0 && this.moduleListener != null) {
            this.moduleListener.markedDataArrived(this, buf);
            buf.setFlags(buf.getFlags() & 0xFFFFFBFF);
        }
        if (this.prefetching || format instanceof AudioFormat || buf.getTimeStamp() <= 0L || (buf.getFlags() & 0x60) == 96 || this.noSync) {
            if (!buf.isDiscard()) {
                rc = this.processBuffer(buf);
            }
        } else {
            long mt = this.getSyncTime(buf.getTimeStamp());
            long lateBy = mt / 1000000L - buf.getTimeStamp() / 1000000L - this.getLatency() / 1000000L;
            if (this.storedBuffer == null && lateBy > 0L) {
                if (buf.isDiscard()) {
                    this.notToDropNext = true;
                } else {
                    if (buf.isEOM()) {
                        this.notToDropNext = true;
                    } else if (this.moduleListener != null && format instanceof VideoFormat) {
                        float fb = (float)lateBy * this.frameRate / 1000.0f;
                        if (fb < 1.0f) {
                            fb = 1.0f;
                        }
                        this.moduleListener.framesBehind(this, fb, this.ic);
                        this.framesWereBehind = true;
                    }
                    if ((buf.getFlags() & 0x20) != 0) {
                        rc = this.processBuffer(buf);
                    } else if (lateBy < this.LEEWAY || this.notToDropNext || buf.getTimeStamp() - this.lastRendered > 1000000000L) {
                        rc = this.processBuffer(buf);
                        this.lastRendered = buf.getTimeStamp();
                        this.notToDropNext = false;
                    }
                }
            } else {
                if (this.moduleListener != null && this.framesWereBehind && format instanceof VideoFormat) {
                    this.moduleListener.framesBehind(this, 0.0f, this.ic);
                    this.framesWereBehind = false;
                }
                if (!buf.isDiscard()) {
                    if ((buf.getFlags() & 0x40) == 0) {
                        this.waitForPT(buf.getTimeStamp());
                    }
                    if (!this.resetted) {
                        rc = this.processBuffer(buf);
                        this.lastRendered = buf.getTimeStamp();
                    }
                }
            }
        }
        if (rc & true) {
            this.storedBuffer = null;
        } else if ((rc & 2) != 0) {
            this.storedBuffer = buf;
        } else {
            this.storedBuffer = null;
            if (buf.getDuration() >= 0L) {
                this.lastDuration = buf.getDuration();
            }
        }
        return true;
    }

    public void setFormat(Connector connector, Format format) {
        float fr;
        this.renderer.setInputFormat(format);
        if (format instanceof VideoFormat && (fr = ((VideoFormat)format).getFrameRate()) != -1.0f) {
            this.frameRate = fr;
        }
    }

    public void setPreroll(long wanted, long actual) {
        super.setPreroll(wanted, actual);
        this.elapseTime.setValue(actual);
    }

    protected void setRenderer(Renderer r) {
        this.renderer = r;
        if (this.renderer instanceof Clock) {
            this.setClock((Clock)((Object)this.renderer));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerReset() {
        if (this.renderer != null) {
            this.renderer.reset();
        }
        Object object = this.prefetchSync;
        synchronized (object) {
            this.prefetching = false;
            if (this.resetted) {
                this.renderThread.start();
            }
        }
    }

    private boolean waitForPT(long pt) {
        long mt = this.getSyncTime(pt);
        long lastAheadBy = -1L;
        int beenHere = 0;
        long aheadBy = (pt - mt) / 1000000L;
        if (this.rate != 1.0f) {
            aheadBy = (long)((float)aheadBy / this.rate);
        }
        while (aheadBy > this.systemErr && !this.resetted) {
            long interval;
            if (aheadBy == lastAheadBy) {
                interval = aheadBy + (long)(5 * beenHere);
                if (interval > 33L) {
                    interval = 33L;
                } else {
                    ++beenHere;
                }
            } else {
                interval = aheadBy;
                beenHere = 0;
            }
            interval = interval > 125L ? 125L : interval;
            long before = System.currentTimeMillis();
            interval -= this.systemErr;
            try {
                if (interval > 0L) {
                    Thread.sleep(interval);
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            long slept = System.currentTimeMillis() - before;
            this.systemErr = (slept - interval + this.systemErr) / 2L;
            if (this.systemErr < 0L) {
                this.systemErr = 0L;
            } else if (this.systemErr > interval) {
                this.systemErr = interval;
            }
            mt = this.getSyncTime(pt);
            lastAheadBy = aheadBy;
            aheadBy = (pt - mt) / 1000000L;
            if (this.rate != 1.0f) {
                aheadBy = (long)((float)aheadBy / this.rate);
            }
            if (this.getState() == 600) continue;
            break;
        }
        return true;
    }
}

