/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.rest;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.Channel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.HashMap;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.ice4j.socket.DatagramPacketFilter;
import org.ice4j.socket.HttpDemuxFilter;
import org.ice4j.socket.MuxServerSocketChannelFactory;

public class MuxServerConnector
extends ServerConnector {
    private static final Field ACCEPT_CHANNEL_FIELD;
    private static final DatagramPacketFilter HTTP_DEMUX_FILTER;
    private static final Field LOCAL_PORT_FIELD;

    public MuxServerConnector(Server server, ConnectionFactory ... factories) {
        super(server, factories);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void open() throws IOException {
        Field acceptChannelField = ACCEPT_CHANNEL_FIELD;
        Field localPortField = LOCAL_PORT_FIELD;
        if (acceptChannelField != null && localPortField != null) {
            try {
                Channel channel;
                if (acceptChannelField.get((Object)this) != null) return;
                AbstractSelectableChannel serverChannel = null;
                if (this.isInheritChannel() && (channel = System.inheritedChannel()) instanceof ServerSocketChannel) {
                    serverChannel = (ServerSocketChannel)channel;
                }
                if (serverChannel == null) {
                    HashMap<String, Boolean> properties = new HashMap<String, Boolean>();
                    properties.put("socket.reuseAddress", this.getReuseAddress());
                    String host = this.getHost();
                    int port = this.getPort();
                    InetSocketAddress endpoint = host == null ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
                    serverChannel = MuxServerSocketChannelFactory.openAndBindMuxServerSocketChannel(properties, (SocketAddress)endpoint, (int)this.getAcceptQueueSize(), (DatagramPacketFilter)HTTP_DEMUX_FILTER);
                    int localPort = ((ServerSocketChannel)serverChannel).socket().getLocalPort();
                    localPortField.set((Object)this, localPort);
                    if (localPort <= 0) {
                        throw new IOException("Server channel not bound");
                    }
                }
                serverChannel.configureBlocking(true);
                this.addBean(serverChannel);
                acceptChannelField.set((Object)this, serverChannel);
                return;
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (!(e instanceof RuntimeException)) throw new RuntimeException(e);
                throw (RuntimeException)e;
            }
        } else {
            super.open();
        }
    }

    static {
        Field acceptChannelField = null;
        Field localPortField = null;
        try {
            Class<ServerConnector> clazz = ServerConnector.class;
            acceptChannelField = clazz.getDeclaredField("_acceptChannel");
            localPortField = clazz.getDeclaredField("_localPort");
            acceptChannelField.setAccessible(true);
            localPortField.setAccessible(true);
        }
        catch (NoSuchFieldException nsfe) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (acceptChannelField != null && localPortField != null) {
            ACCEPT_CHANNEL_FIELD = acceptChannelField;
            LOCAL_PORT_FIELD = localPortField;
        } else {
            ACCEPT_CHANNEL_FIELD = null;
            LOCAL_PORT_FIELD = null;
        }
        HTTP_DEMUX_FILTER = new HttpDemuxFilter();
    }
}

