/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.media.rtp.SessionAddress;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.CandidatePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.DtlsFingerprintPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.IceUdpTransportPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RtcpmuxPacketExtension;
import net.java.sip.communicator.service.netaddr.NetworkAddressManagerService;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.media.MediaAwareCallPeer;
import net.java.sip.communicator.util.PortTracker;
import net.java.sip.communicator.util.ServiceUtils;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.ice.Agent;
import org.ice4j.ice.Candidate;
import org.ice4j.ice.CandidatePair;
import org.ice4j.ice.CandidateType;
import org.ice4j.ice.Component;
import org.ice4j.ice.IceMediaStream;
import org.ice4j.ice.IceProcessingState;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.RemoteCandidate;
import org.ice4j.ice.harvest.AwsCandidateHarvester;
import org.ice4j.ice.harvest.CandidateHarvester;
import org.ice4j.ice.harvest.MappingCandidateHarvester;
import org.ice4j.ice.harvest.MultiplexingTcpHostHarvester;
import org.ice4j.ice.harvest.SinglePortUdpHarvester;
import org.ice4j.socket.DTLSDatagramFilter;
import org.ice4j.socket.DatagramPacketFilter;
import org.ice4j.socket.IceSocketWrapper;
import org.ice4j.socket.MultiplexedDatagramSocket;
import org.ice4j.socket.MultiplexedSocket;
import org.ice4j.socket.MultiplexingDatagramSocket;
import org.ice4j.socket.MultiplexingSocket;
import org.jitsi.impl.neomedia.AbstractRTPConnector;
import org.jitsi.impl.neomedia.RTPConnectorTCPImpl;
import org.jitsi.impl.neomedia.RTPConnectorUDPImpl;
import org.jitsi.impl.neomedia.transform.dtls.DtlsControlImpl;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.neomedia.DefaultStreamConnector;
import org.jitsi.service.neomedia.DefaultTCPStreamConnector;
import org.jitsi.service.neomedia.DtlsControl;
import org.jitsi.service.neomedia.MediaStreamTarget;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.util.Logger;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.EventFactory;
import org.jitsi.videobridge.RtpChannel;
import org.jitsi.videobridge.SctpConnection;
import org.jitsi.videobridge.TransportManager;
import org.jitsi.videobridge.eventadmin.EventAdmin;
import org.jivesoftware.smack.packet.PacketExtension;
import org.osgi.framework.BundleContext;

public class IceUdpTransportManager
extends TransportManager {
    private static final String DEFAULT_ICE_STREAM_NAME = "stream";
    private static final String DISABLE_AWS_HARVESTER = "org.jitsi.videobridge.DISABLE_AWS_HARVESTER";
    private static final String DISABLE_TCP_HARVESTER = "org.jitsi.videobridge.DISABLE_TCP_HARVESTER";
    private static final String SINGLE_PORT_HARVESTER_PORT = "org.jitsi.videobridge.SINGLE_PORT_HARVESTER_PORT";
    private static final String FORCE_AWS_HARVESTER = "org.jitsi.videobridge.FORCE_AWS_HARVESTER";
    private static final Logger logger = Logger.getLogger(IceUdpTransportManager.class);
    private static final String NAT_HARVESTER_LOCAL_ADDRESS = "org.jitsi.videobridge.NAT_HARVESTER_LOCAL_ADDRESS";
    private static final String NAT_HARVESTER_PUBLIC_ADDRESS = "org.jitsi.videobridge.NAT_HARVESTER_PUBLIC_ADDRESS";
    private static final int TCP_DEFAULT_PORT = 443;
    private static final int TCP_FALLBACK_PORT = 4443;
    private static final String TCP_HARVESTER_MAPPED_PORT = "org.jitsi.videobridge.TCP_HARVESTER_MAPPED_PORT";
    private static final String TCP_HARVESTER_PORT = "org.jitsi.videobridge.TCP_HARVESTER_PORT";
    private static final String TCP_HARVESTER_SSLTCP = "org.jitsi.videobridge.TCP_HARVESTER_SSLTCP";
    private static final boolean TCP_HARVESTER_SSLTCP_DEFAULT = true;
    private static MultiplexingTcpHostHarvester tcpHostHarvester = null;
    private static List<SinglePortUdpHarvester> singlePortHarvesters = null;
    private static boolean staticHarvestersInitialized = false;
    private static int tcpHostHarvesterMappedPort = -1;
    private Channel channelForDtls = null;
    private boolean closed = false;
    private final Conference conference;
    private Thread connectThread;
    private final Object connectThreadSyncRoot = new Object();
    private final DtlsControlImpl dtlsControl;
    private Agent iceAgent;
    private final PropertyChangeListener iceAgentStateChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent ev) {
            IceUdpTransportManager.this.iceAgentStateChange(ev);
        }
    };
    private boolean iceConnected = false;
    private final IceMediaStream iceStream;
    private final PropertyChangeListener iceStreamPairChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent ev) {
            IceUdpTransportManager.this.iceStreamPairChange(ev);
        }
    };
    private final boolean isControlling;
    private int numComponents;
    private boolean rtcpmux = false;
    private SctpConnection sctpConnection = null;

    private static void logd(String s) {
        logger.info((Object)s);
    }

    public IceUdpTransportManager(Conference conference, boolean isControlling) throws IOException {
        this(conference, isControlling, 2, DEFAULT_ICE_STREAM_NAME);
    }

    public IceUdpTransportManager(Conference conference, boolean isControlling, int numComponents) throws IOException {
        this(conference, isControlling, numComponents, DEFAULT_ICE_STREAM_NAME);
    }

    public IceUdpTransportManager(Conference conference, boolean isControlling, int numComponents, String iceStreamName) throws IOException {
        this.conference = conference;
        this.numComponents = numComponents;
        this.rtcpmux = numComponents == 1;
        this.isControlling = isControlling;
        this.dtlsControl = new DtlsControlImpl(false);
        this.dtlsControl.registerUser((Object)this);
        this.iceAgent = this.createIceAgent(isControlling, iceStreamName, this.rtcpmux);
        this.iceAgent.addStateChangeListener(this.iceAgentStateChangeListener);
        this.iceStream = this.iceAgent.getStream(iceStreamName);
        this.iceStream.addPairChangeListener(this.iceStreamPairChangeListener);
        EventAdmin eventAdmin = conference.getVideobridge().getEventAdmin();
        if (eventAdmin != null) {
            eventAdmin.sendEvent(EventFactory.transportCreated(this));
        }
    }

    public IceUdpTransportManager(Conference conference, boolean isControlling, String iceStreamName) throws IOException {
        this(conference, isControlling, 2, iceStreamName);
    }

    public boolean addChannel(Channel channel) {
        EventAdmin eventAdmin;
        if (this.closed) {
            return false;
        }
        if (channel instanceof SctpConnection && this.sctpConnection != null && this.sctpConnection != channel) {
            IceUdpTransportManager.logd("Not adding a second SctpConnection to TransportManager.");
            return false;
        }
        if (!super.addChannel(channel)) {
            return false;
        }
        if (channel instanceof SctpConnection) {
            this.sctpConnection = (SctpConnection)channel;
            if (this.channelForDtls != null) {
                RtpChannel rtpChannelForDtls = (RtpChannel)this.channelForDtls;
                rtpChannelForDtls.getDatagramFilter(false).setAcceptNonRtp(false);
                rtpChannelForDtls.getDatagramFilter(true).setAcceptNonRtp(false);
            }
            this.channelForDtls = this.sctpConnection;
        } else if (this.channelForDtls == null) {
            this.channelForDtls = channel;
            RtpChannel rtpChannel = (RtpChannel)channel;
            rtpChannel.getDatagramFilter(false).setAcceptNonRtp(true);
            rtpChannel.getDatagramFilter(true).setAcceptNonRtp(!this.rtcpmux);
        }
        if (this.iceConnected) {
            channel.transportConnected();
        }
        if ((eventAdmin = this.conference.getVideobridge().getEventAdmin()) != null) {
            eventAdmin.sendEvent(EventFactory.transportChannelAdded(channel));
        }
        return true;
    }

    private void appendVideobridgeHarvesters(Agent iceAgent, boolean rtcpmux) {
        TransportAddress publicAddress;
        TransportAddress localAddress;
        ConfigurationService configurationService;
        if (rtcpmux) {
            this.initializeStaticHarvesters();
            if (tcpHostHarvester != null) {
                iceAgent.addCandidateHarvester((CandidateHarvester)tcpHostHarvester);
            }
            if (singlePortHarvesters != null) {
                for (CandidateHarvester candidateHarvester : singlePortHarvesters) {
                    iceAgent.addCandidateHarvester(candidateHarvester);
                }
            }
        }
        AwsCandidateHarvester awsHarvester = null;
        if (AwsCandidateHarvester.smellsLikeAnEC2()) {
            awsHarvester = new AwsCandidateHarvester();
        }
        if ((configurationService = (ConfigurationService)ServiceUtils.getService((BundleContext)this.getBundleContext(), ConfigurationService.class)) == null) {
            logger.info((Object)"No configuration found. Will continue without custom candidate harvesters");
            return;
        }
        if (awsHarvester == null && configurationService.getBoolean(FORCE_AWS_HARVESTER, false)) {
            logger.info((Object)"Forcing use of AWS candidate harvesting.");
            awsHarvester = new AwsCandidateHarvester();
        }
        if (awsHarvester != null && !configurationService.getBoolean(DISABLE_AWS_HARVESTER, false)) {
            logger.info((Object)"Appending an AWS harvester to the ICE agent.");
            iceAgent.addCandidateHarvester((CandidateHarvester)awsHarvester);
        }
        String localAddressStr = configurationService.getString(NAT_HARVESTER_LOCAL_ADDRESS);
        String publicAddressStr = configurationService.getString(NAT_HARVESTER_PUBLIC_ADDRESS);
        if (localAddressStr == null || publicAddressStr == null) {
            return;
        }
        try {
            localAddress = new TransportAddress(localAddressStr, 9, Transport.UDP);
            publicAddress = new TransportAddress(publicAddressStr, 9, Transport.UDP);
            logger.info((Object)("Will append a NAT harvester for " + localAddress + "=>" + publicAddress));
        }
        catch (Exception exc) {
            logger.info((Object)("Failed to create a NAT harvester for local address=" + localAddressStr + " and public address=" + publicAddressStr));
            return;
        }
        MappingCandidateHarvester natHarvester = new MappingCandidateHarvester(publicAddress, localAddress);
        iceAgent.addCandidateHarvester((CandidateHarvester)natHarvester);
    }

    private boolean canReach(Component component, RemoteCandidate remoteCandidate) {
        for (LocalCandidate localCandidate : component.getLocalCandidates()) {
            if (!localCandidate.canReach((Candidate)remoteCandidate)) continue;
            return true;
        }
        return false;
    }

    protected void channelPropertyChange(PropertyChangeEvent ev) {
        super.channelPropertyChange(ev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            for (Channel channel : this.getChannels()) {
                this.close(channel);
            }
            if (this.dtlsControl != null) {
                this.dtlsControl.start(null);
                this.dtlsControl.cleanup((Object)this);
            }
            if (this.iceStream != null) {
                this.iceStream.removePairStateChangeListener(this.iceStreamPairChangeListener);
            }
            if (this.iceAgent != null) {
                this.iceAgent.removeStateChangeListener(this.iceAgentStateChangeListener);
                this.iceAgent.free();
                this.iceAgent = null;
            }
            Object object = this.connectThreadSyncRoot;
            synchronized (object) {
                if (this.connectThread != null) {
                    this.connectThread.interrupt();
                }
            }
            super.close();
        }
    }

    public boolean close(Channel channel) {
        boolean removed = super.close(channel);
        if (removed) {
            if (channel == this.sctpConnection) {
                this.sctpConnection = null;
            }
            if (channel == this.channelForDtls) {
                if (this.sctpConnection != null) {
                    this.channelForDtls = this.sctpConnection;
                } else if (channel instanceof RtpChannel) {
                    RtpChannel newChannelForDtls = null;
                    for (Channel c : this.getChannels()) {
                        if (!(c instanceof RtpChannel)) continue;
                        newChannelForDtls = (RtpChannel)c;
                    }
                    if (newChannelForDtls != null) {
                        newChannelForDtls.getDatagramFilter(false).setAcceptNonRtp(true);
                        newChannelForDtls.getDatagramFilter(true).setAcceptNonRtp(!this.rtcpmux);
                    }
                    this.channelForDtls = newChannelForDtls;
                }
                if (channel instanceof RtpChannel) {
                    RtpChannel rtpChannel = (RtpChannel)channel;
                    rtpChannel.getDatagramFilter(false).setAcceptNonRtp(false);
                    rtpChannel.getDatagramFilter(true).setAcceptNonRtp(false);
                }
            }
            try {
                StreamConnector connector = channel.getStreamConnector();
                if (connector != null) {
                    Socket socket;
                    DatagramSocket datagramSocket = connector.getDataSocket();
                    if (datagramSocket != null) {
                        datagramSocket.close();
                    }
                    if ((datagramSocket = connector.getControlSocket()) != null) {
                        datagramSocket.close();
                    }
                    if ((socket = connector.getDataTCPSocket()) != null) {
                        socket.close();
                    }
                    if ((socket = connector.getControlTCPSocket()) != null) {
                        socket.close();
                    }
                }
            }
            catch (IOException ioe) {
                IceUdpTransportManager.logd("Failed to close sockets when closing a channel:" + ioe);
            }
            EventAdmin eventAdmin = this.conference.getVideobridge().getEventAdmin();
            if (eventAdmin != null) {
                eventAdmin.sendEvent(EventFactory.transportChannelRemoved(channel));
            }
            channel.transportClosed();
        }
        if (this.getChannels().isEmpty()) {
            this.close();
        }
        return removed;
    }

    private Agent createIceAgent(boolean isControlling, String iceStreamName, boolean rtcpmux) throws IOException {
        NetworkAddressManagerService nams = (NetworkAddressManagerService)ServiceUtils.getService((BundleContext)this.getBundleContext(), NetworkAddressManagerService.class);
        Agent iceAgent = nams.createIceAgent();
        this.appendVideobridgeHarvesters(iceAgent, rtcpmux);
        iceAgent.setControlling(isControlling);
        iceAgent.setPerformConsentFreshness(true);
        PortTracker portTracker = JitsiTransportManager.getPortTracker(null);
        int portBase = portTracker.getPort();
        IceMediaStream iceStream = nams.createIceStream(this.numComponents, portBase, iceStreamName, iceAgent);
        try {
            portTracker.setNextPort(1 + ((LocalCandidate)iceStream.getComponent(this.numComponents > 1 ? 2 : 1).getLocalCandidates().get(0)).getTransportAddress().getPort());
        }
        catch (Throwable t) {
            if (t instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            portTracker.setNextPort(this.numComponents + portBase);
        }
        return iceAgent;
    }

    protected void describe(IceUdpTransportPacketExtension pe) {
        if (!this.closed) {
            pe.setPassword(this.iceAgent.getLocalPassword());
            pe.setUfrag(this.iceAgent.getLocalUfrag());
            for (Component component : this.iceStream.getComponents()) {
                List candidates = component.getLocalCandidates();
                if (candidates == null || candidates.isEmpty()) continue;
                for (LocalCandidate candidate : candidates) {
                    if (candidate.getTransport() == Transport.TCP && tcpHostHarvesterMappedPort != -1 && candidate.getTransportAddress().getPort() != tcpHostHarvesterMappedPort) continue;
                    this.describe(candidate, pe);
                }
            }
            if (this.rtcpmux) {
                pe.addChildExtension((PacketExtension)new RtcpmuxPacketExtension());
            }
            this.describeDtlsControl(pe);
        }
    }

    private void describe(LocalCandidate candidate, IceUdpTransportPacketExtension pe) {
        CandidatePacketExtension candidatePE = new CandidatePacketExtension();
        Component component = candidate.getParentComponent();
        candidatePE.setComponent(component.getComponentID());
        candidatePE.setFoundation(candidate.getFoundation());
        candidatePE.setGeneration(component.getParentStream().getParentAgent().getGeneration());
        candidatePE.setID(this.generateCandidateID(candidate));
        candidatePE.setNetwork(0);
        candidatePE.setPriority(candidate.getPriority());
        Transport transport = candidate.getTransport();
        if (transport == Transport.TCP && candidate.isSSL()) {
            transport = Transport.SSLTCP;
        }
        candidatePE.setProtocol(transport.toString());
        if (transport == Transport.TCP || transport == Transport.SSLTCP) {
            candidatePE.setTcpType(candidate.getTcpType());
        }
        candidatePE.setType(net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.CandidateType.valueOf((String)candidate.getType().toString()));
        TransportAddress transportAddress = candidate.getTransportAddress();
        candidatePE.setIP(transportAddress.getHostAddress());
        candidatePE.setPort(transportAddress.getPort());
        TransportAddress relatedAddress = candidate.getRelatedAddress();
        if (relatedAddress != null) {
            candidatePE.setRelAddr(relatedAddress.getHostAddress());
            candidatePE.setRelPort(relatedAddress.getPort());
        }
        pe.addChildExtension((PacketExtension)candidatePE);
    }

    private void describeDtlsControl(IceUdpTransportPacketExtension transportPE) {
        String fingerprint = this.dtlsControl.getLocalFingerprint();
        String hash = this.dtlsControl.getLocalFingerprintHashFunction();
        DtlsFingerprintPacketExtension fingerprintPE = (DtlsFingerprintPacketExtension)transportPE.getFirstChildOfType(DtlsFingerprintPacketExtension.class);
        if (fingerprintPE == null) {
            fingerprintPE = new DtlsFingerprintPacketExtension();
            transportPE.addChildExtension((PacketExtension)fingerprintPE);
        }
        fingerprintPE.setFingerprint(fingerprint);
        fingerprintPE.setHash(hash);
    }

    private synchronized void doStartConnectivityEstablishment(IceUdpTransportPacketExtension transport) {
        String password;
        String ufrag;
        Component rtcpComponent;
        IceProcessingState state;
        List dfpes;
        if (this.closed) {
            return;
        }
        if (transport.isRtcpMux()) {
            this.rtcpmux = true;
            if (this.channelForDtls != null && this.channelForDtls instanceof RtpChannel) {
                ((RtpChannel)this.channelForDtls).getDatagramFilter(true).setAcceptNonRtp(false);
            }
        }
        if (!(dfpes = transport.getChildExtensionsOfType(DtlsFingerprintPacketExtension.class)).isEmpty()) {
            LinkedHashMap<String, String> remoteFingerprints = new LinkedHashMap<String, String>();
            for (DtlsFingerprintPacketExtension dfpe : dfpes) {
                remoteFingerprints.put(dfpe.getHash(), dfpe.getFingerprint());
            }
            this.dtlsControl.setRemoteFingerprints(remoteFingerprints);
        }
        if (IceProcessingState.COMPLETED.equals((Object)(state = this.iceAgent.getState())) || IceProcessingState.TERMINATED.equals((Object)state)) {
            return;
        }
        boolean iceAgentStateIsRunning = IceProcessingState.RUNNING.equals((Object)state);
        int remoteCandidateCount = 0;
        if (this.rtcpmux && (rtcpComponent = this.iceStream.getComponent(2)) != null) {
            this.iceStream.removeComponent(rtcpComponent);
        }
        if ((ufrag = transport.getUfrag()) != null) {
            this.iceStream.setRemoteUfrag(ufrag);
        }
        if ((password = transport.getPassword()) != null) {
            this.iceStream.setRemotePassword(password);
        }
        List candidates = transport.getChildExtensionsOfType(CandidatePacketExtension.class);
        if (iceAgentStateIsRunning && candidates.size() == 0) {
            return;
        }
        Collections.sort(candidates);
        int generation = this.iceAgent.getGeneration();
        for (CandidatePacketExtension candidate : candidates) {
            int relPort;
            if (candidate.getGeneration() != generation) continue;
            if (this.rtcpmux && 2 == candidate.getComponent()) {
                logger.warn((Object)"Received an RTCP candidate, but we're using rtcp-mux. Ignoring.");
                continue;
            }
            Component component = this.iceStream.getComponent(candidate.getComponent());
            TransportAddress relatedAddress = null;
            String relAddr = candidate.getRelAddr();
            if (relAddr != null && (relPort = candidate.getRelPort()) != -1) {
                relatedAddress = new TransportAddress(relAddr, relPort, Transport.parse((String)candidate.getProtocol()));
            }
            RemoteCandidate relatedCandidate = component.findRemoteCandidate(relatedAddress);
            RemoteCandidate remoteCandidate = new RemoteCandidate(new TransportAddress(candidate.getIP(), candidate.getPort(), Transport.parse((String)candidate.getProtocol())), component, CandidateType.parse((String)candidate.getType().toString()), candidate.getFoundation(), (long)candidate.getPriority(), relatedCandidate);
            if (!this.canReach(component, remoteCandidate)) continue;
            if (iceAgentStateIsRunning) {
                component.addUpdateRemoteCandidates(remoteCandidate);
            } else {
                component.addRemoteCandidate(remoteCandidate);
            }
            ++remoteCandidateCount;
        }
        if (iceAgentStateIsRunning) {
            if (remoteCandidateCount == 0) {
                return;
            }
            for (IceMediaStream stream : this.iceAgent.getStreams()) {
                for (Component component : stream.getComponents()) {
                    component.updateRemoteCandidates();
                }
            }
        } else if (remoteCandidateCount != 0) {
            for (IceMediaStream stream : this.iceAgent.getStreams()) {
                for (Component component : stream.getComponents()) {
                    if (component.getRemoteCandidateCount() >= 1) continue;
                    remoteCandidateCount = 0;
                    break;
                }
                if (remoteCandidateCount != 0) continue;
                break;
            }
            if (remoteCandidateCount != 0) {
                this.iceAgent.startConnectivityEstablishment();
            }
        } else if (this.iceStream.getRemoteUfrag() != null && this.iceStream.getRemotePassword() != null) {
            logger.info((Object)"Starting ICE agent without remote candidates.");
            this.iceAgent.startConnectivityEstablishment();
        }
    }

    private String generateCandidateID(LocalCandidate candidate) {
        StringBuilder candidateID = new StringBuilder();
        candidateID.append(this.conference.getID());
        candidateID.append(Long.toHexString(this.hashCode()));
        Agent iceAgent = candidate.getParentComponent().getParentStream().getParentAgent();
        candidateID.append(Long.toHexString(iceAgent.hashCode()));
        candidateID.append(Long.toHexString(iceAgent.getGeneration()));
        candidateID.append(Long.toHexString(candidate.hashCode()));
        return candidateID.toString();
    }

    public Conference getConference() {
        return this.conference;
    }

    public int getNumComponents() {
        return this.numComponents;
    }

    public Agent getAgent() {
        return this.iceAgent;
    }

    public IceMediaStream getIceStream() {
        return this.iceStream;
    }

    public boolean isControlling() {
        return this.isControlling;
    }

    public BundleContext getBundleContext() {
        return this.conference != null ? this.conference.getBundleContext() : null;
    }

    public DtlsControl getDtlsControl(Channel channel) {
        return this.dtlsControl;
    }

    private IceSocketWrapper getSocketForComponent(Component component) {
        CandidatePair selectedPair = component.getSelectedPair();
        if (selectedPair != null) {
            return selectedPair.getIceSocketWrapper();
        }
        return null;
    }

    public StreamConnector getStreamConnector(Channel channel) {
        IceSocketWrapper iceSocket0;
        if (!this.getChannels().contains((Object)channel)) {
            return null;
        }
        IceSocketWrapper[] iceSockets = this.getStreamConnectorSockets();
        if (iceSockets == null || (iceSocket0 = iceSockets[0]) == null) {
            return null;
        }
        if (channel instanceof SctpConnection) {
            DatagramSocket udpSocket = iceSocket0.getUDPSocket();
            if (udpSocket != null) {
                if (udpSocket instanceof MultiplexingDatagramSocket) {
                    MultiplexingDatagramSocket multiplexing = (MultiplexingDatagramSocket)udpSocket;
                    try {
                        MultiplexedDatagramSocket dtlsSocket = multiplexing.getSocket((DatagramPacketFilter)new DTLSDatagramFilter());
                        return new DefaultStreamConnector((DatagramSocket)dtlsSocket, null);
                    }
                    catch (IOException ioe) {
                        logger.warn((Object)("Failed to create DTLS socket: " + ioe));
                    }
                }
            } else {
                Socket tcpSocket = iceSocket0.getTCPSocket();
                if (tcpSocket != null && tcpSocket instanceof MultiplexingSocket) {
                    MultiplexingSocket multiplexing = (MultiplexingSocket)tcpSocket;
                    try {
                        MultiplexedSocket dtlsSocket = multiplexing.getSocket((DatagramPacketFilter)new DTLSDatagramFilter());
                        return new DefaultTCPStreamConnector((Socket)dtlsSocket, null);
                    }
                    catch (IOException ioe) {
                        logger.warn((Object)("Failed to create DTLS socket: " + ioe));
                    }
                }
            }
            return null;
        }
        if (!(channel instanceof RtpChannel)) {
            return null;
        }
        IceSocketWrapper iceSocket1 = iceSockets[1];
        RtpChannel rtpChannel = (RtpChannel)channel;
        DatagramSocket udpSocket0 = iceSocket0.getUDPSocket();
        if (udpSocket0 != null) {
            DatagramSocket udpSocket1 = iceSocket1 == null ? null : iceSocket1.getUDPSocket();
            return this.getUDPStreamConnector(rtpChannel, new DatagramSocket[]{udpSocket0, udpSocket1});
        }
        Socket tcpSocket0 = iceSocket0.getTCPSocket();
        Socket tcpSocket1 = iceSocket1 == null ? null : iceSocket1.getTCPSocket();
        return this.getTCPStreamConnector(rtpChannel, new Socket[]{tcpSocket0, tcpSocket1});
    }

    private IceSocketWrapper[] getStreamConnectorSockets() {
        Component rtcpComponent;
        IceSocketWrapper[] streamConnectorSockets = new IceSocketWrapper[2];
        Component rtpComponent = this.iceStream.getComponent(1);
        if (rtpComponent != null) {
            streamConnectorSockets[0] = this.getSocketForComponent(rtpComponent);
        }
        if (this.numComponents > 1 && !this.rtcpmux && (rtcpComponent = this.iceStream.getComponent(2)) != null) {
            streamConnectorSockets[1] = this.getSocketForComponent(rtcpComponent);
        }
        return streamConnectorSockets;
    }

    private MediaStreamTarget getStreamTarget() {
        TransportAddress streamTargetAddress;
        CandidatePair selectedPair;
        Component rtcpComponent;
        TransportAddress streamTargetAddress2;
        CandidatePair selectedPair2;
        MediaStreamTarget streamTarget = null;
        InetSocketAddress[] streamTargetAddresses = new InetSocketAddress[2];
        int streamTargetAddressCount = 0;
        Component rtpComponent = this.iceStream.getComponent(1);
        if (rtpComponent != null && (selectedPair2 = rtpComponent.getSelectedPair()) != null && (streamTargetAddress2 = selectedPair2.getRemoteCandidate().getTransportAddress()) != null) {
            streamTargetAddresses[0] = streamTargetAddress2;
            ++streamTargetAddressCount;
        }
        if (this.numComponents > 1 && !this.rtcpmux && (rtcpComponent = this.iceStream.getComponent(2)) != null && (selectedPair = rtcpComponent.getSelectedPair()) != null && (streamTargetAddress = selectedPair.getRemoteCandidate().getTransportAddress()) != null) {
            streamTargetAddresses[1] = streamTargetAddress;
            ++streamTargetAddressCount;
        }
        if (this.rtcpmux) {
            streamTargetAddresses[1] = streamTargetAddresses[0];
            ++streamTargetAddressCount;
        }
        if (streamTargetAddressCount > 0) {
            streamTarget = new MediaStreamTarget(streamTargetAddresses[0], streamTargetAddresses[1]);
        }
        return streamTarget;
    }

    public MediaStreamTarget getStreamTarget(Channel channel) {
        return this.getStreamTarget();
    }

    private StreamConnector getTCPStreamConnector(RtpChannel rtpChannel, Socket[] iceSockets) {
        DefaultTCPStreamConnector connector = null;
        if (iceSockets != null) {
            Socket iceSocket0 = iceSockets[0];
            MultiplexedSocket channelSocket0 = null;
            if (iceSocket0 != null && iceSocket0 instanceof MultiplexingSocket) {
                MultiplexingSocket multiplexing = (MultiplexingSocket)iceSocket0;
                try {
                    channelSocket0 = multiplexing.getSocket((DatagramPacketFilter)rtpChannel.getDatagramFilter(false));
                }
                catch (SocketException se) {
                    // empty catch block
                }
            }
            Socket iceSocket1 = this.rtcpmux ? iceSocket0 : iceSockets[1];
            MultiplexedSocket channelSocket1 = null;
            if (iceSocket1 != null && iceSocket1 instanceof MultiplexingSocket) {
                MultiplexingSocket multiplexing = (MultiplexingSocket)iceSocket1;
                try {
                    channelSocket1 = multiplexing.getSocket((DatagramPacketFilter)rtpChannel.getDatagramFilter(true));
                }
                catch (SocketException se) {
                    // empty catch block
                }
            }
            if (channelSocket0 != null || channelSocket1 != null) {
                connector = new DefaultTCPStreamConnector((Socket)channelSocket0, channelSocket1, this.rtcpmux);
            }
        }
        return connector;
    }

    private StreamConnector getUDPStreamConnector(RtpChannel rtpChannel, DatagramSocket[] iceSockets) {
        DefaultStreamConnector connector = null;
        if (iceSockets != null) {
            DatagramSocket iceSocket0 = iceSockets[0];
            MultiplexedDatagramSocket channelSocket0 = null;
            if (iceSocket0 != null && iceSocket0 instanceof MultiplexingDatagramSocket) {
                MultiplexingDatagramSocket multiplexing = (MultiplexingDatagramSocket)iceSocket0;
                try {
                    channelSocket0 = multiplexing.getSocket((DatagramPacketFilter)rtpChannel.getDatagramFilter(false));
                }
                catch (SocketException se) {
                    // empty catch block
                }
            }
            DatagramSocket iceSocket1 = this.rtcpmux ? iceSocket0 : iceSockets[1];
            MultiplexedDatagramSocket channelSocket1 = null;
            if (iceSocket1 != null && iceSocket1 instanceof MultiplexingDatagramSocket) {
                MultiplexingDatagramSocket multiplexing = (MultiplexingDatagramSocket)iceSocket1;
                try {
                    channelSocket1 = multiplexing.getSocket((DatagramPacketFilter)rtpChannel.getDatagramFilter(true));
                }
                catch (SocketException se) {
                    // empty catch block
                }
            }
            if (channelSocket0 != null || channelSocket1 != null) {
                connector = new DefaultStreamConnector((DatagramSocket)channelSocket0, channelSocket1, this.rtcpmux);
            }
        }
        return connector;
    }

    public String getXmlNamespace() {
        return "urn:xmpp:jingle:transports:ice-udp:1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iceAgentStateChange(PropertyChangeEvent ev) {
        boolean interrupted = false;
        try {
            block11: {
                try {
                    IceProcessingState oldState = (IceProcessingState)ev.getOldValue();
                    IceProcessingState newState = (IceProcessingState)ev.getNewValue();
                    StringBuilder s = new StringBuilder("ICE processing state of ").append(this.getClass().getSimpleName()).append(" #").append(Integer.toHexString(this.hashCode())).append(" (for channels");
                    for (Channel channel : this.getChannels()) {
                        s.append(" ").append(channel.getID());
                    }
                    s.append(")  of conference ").append(this.conference.getID()).append(" changed from ").append(oldState).append(" to ").append(newState).append(".");
                    IceUdpTransportManager.logd(s.toString());
                    EventAdmin eventAdmin = this.conference.getVideobridge().getEventAdmin();
                    if (eventAdmin == null) break block11;
                    eventAdmin.sendEvent(EventFactory.transportStateChanged(this, oldState, newState));
                }
                catch (Throwable t) {
                    if (t instanceof InterruptedException) {
                        interrupted = true;
                    } else if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    Object var9_10 = null;
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            Object var9_9 = null;
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            throw throwable;
        }
    }

    private void iceStreamPairChange(PropertyChangeEvent ev) {
        if ("PairConsentFreshnessChanged".equals(ev.getPropertyName())) {
            for (Channel channel : this.getChannels()) {
                channel.touch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeStaticHarvesters() {
        Class<IceUdpTransportManager> clazz = IceUdpTransportManager.class;
        synchronized (IceUdpTransportManager.class) {
            if (staticHarvestersInitialized) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            staticHarvestersInitialized = true;
            ConfigurationService cfg = this.conference.getVideobridge().getConfigurationService();
            int singlePort = -1;
            singlePort = cfg.getInt(SINGLE_PORT_HARVESTER_PORT, -1);
            if (singlePort != -1 && (singlePortHarvesters = SinglePortUdpHarvester.createHarvesters((int)singlePort)).isEmpty()) {
                singlePortHarvesters = null;
                logger.info((Object)"No single-port harvesters created.");
            }
            if (!cfg.getBoolean(DISABLE_TCP_HARVESTER, false)) {
                int mappedPort;
                int port = cfg.getInt(TCP_HARVESTER_PORT, -1);
                boolean fallback = false;
                boolean ssltcp = cfg.getBoolean(TCP_HARVESTER_SSLTCP, true);
                if (port == -1) {
                    port = 443;
                    fallback = true;
                }
                try {
                    tcpHostHarvester = new MultiplexingTcpHostHarvester(port, ssltcp);
                }
                catch (IOException ioe) {
                    logger.warn((Object)("Failed to initialize TCP harvester on port " + port + ": " + ioe + (fallback ? ". Retrying on port 4443" : "") + "."));
                }
                if (tcpHostHarvester == null) {
                    if (!fallback) {
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                    port = 4443;
                    try {
                        tcpHostHarvester = new MultiplexingTcpHostHarvester(port, ssltcp);
                    }
                    catch (IOException ioe) {
                        logger.warn((Object)("Failed to initialize TCP harvester on fallback port " + port + ": " + ioe));
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Initialized TCP harvester on port " + port + ", using SSLTCP:" + ssltcp));
                }
                String localAddressStr = cfg.getString(NAT_HARVESTER_LOCAL_ADDRESS);
                String publicAddressStr = cfg.getString(NAT_HARVESTER_PUBLIC_ADDRESS);
                if (localAddressStr != null && publicAddressStr != null) {
                    try {
                        tcpHostHarvester.addMappedAddress(InetAddress.getByName(publicAddressStr), InetAddress.getByName(localAddressStr));
                    }
                    catch (UnknownHostException uhe) {
                        logger.warn((Object)("Failed to add mapped address for " + publicAddressStr + " -> " + localAddressStr + ": " + uhe));
                    }
                }
                if ((mappedPort = cfg.getInt(TCP_HARVESTER_MAPPED_PORT, -1)) != -1) {
                    tcpHostHarvesterMappedPort = mappedPort;
                    tcpHostHarvester.addMappedPort(mappedPort);
                }
                if (AwsCandidateHarvester.smellsLikeAnEC2()) {
                    TransportAddress localAddress = AwsCandidateHarvester.getFace();
                    TransportAddress publicAddress = AwsCandidateHarvester.getMask();
                    if (localAddress != null && publicAddress != null) {
                        tcpHostHarvester.addMappedAddress(publicAddress.getAddress(), localAddress.getAddress());
                    }
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void onIceConnected() {
        this.iceConnected = true;
        EventAdmin eventAdmin = this.conference.getVideobridge().getEventAdmin();
        if (eventAdmin != null) {
            eventAdmin.sendEvent(EventFactory.transportConnected(this));
        }
        for (Channel channel : this.getChannels()) {
            channel.transportConnected();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startConnectivityEstablishment(IceUdpTransportPacketExtension transport) {
        this.doStartConnectivityEstablishment(transport);
        Object object = this.connectThreadSyncRoot;
        synchronized (object) {
            if (this.connectThread == null) {
                this.connectThread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            IceUdpTransportManager.this.wrapupConnectivityEstablishment();
                        }
                        catch (OperationFailedException ofe) {
                            IceUdpTransportManager.logd("Failed to connect IceUdpTransportManager: " + (Object)((Object)ofe));
                            Object object = IceUdpTransportManager.this.connectThreadSyncRoot;
                            synchronized (object) {
                                IceUdpTransportManager.this.connectThread = null;
                                return;
                            }
                        }
                        IceProcessingState state = IceUdpTransportManager.this.iceAgent.getState();
                        if (IceProcessingState.COMPLETED.equals((Object)state) || IceProcessingState.TERMINATED.equals((Object)state)) {
                            IceUdpTransportManager.this.startDtls();
                            IceUdpTransportManager.this.onIceConnected();
                        } else {
                            logger.warn((Object)("Failed to establish ICE connectivity, state: " + state));
                        }
                    }
                };
                this.connectThread.setDaemon(true);
                this.connectThread.setName("IceUdpTransportManager connect thread");
                this.connectThread.start();
            }
        }
    }

    private void startDtls() {
        RTPConnectorUDPImpl rtpConnector;
        this.dtlsControl.setSetup(this.isControlling ? DtlsControl.Setup.PASSIVE : DtlsControl.Setup.ACTIVE);
        this.dtlsControl.setRtcpmux(this.rtcpmux);
        IceSocketWrapper[] iceSockets = this.getStreamConnectorSockets();
        if (iceSockets == null || iceSockets[0] == null) {
            IceUdpTransportManager.logd("Cannot start DTLS, no sockets from ICE.");
            return;
        }
        DatagramSocket udpSocket = iceSockets[0].getUDPSocket();
        if (udpSocket != null) {
            DefaultStreamConnector streamConnector = new DefaultStreamConnector(udpSocket, iceSockets[1] == null ? null : iceSockets[1].getUDPSocket(), this.rtcpmux);
            rtpConnector = new RTPConnectorUDPImpl((StreamConnector)streamConnector);
        } else {
            DefaultTCPStreamConnector streamConnector = new DefaultTCPStreamConnector(iceSockets[0].getTCPSocket(), iceSockets[1] == null ? null : iceSockets[1].getTCPSocket(), this.rtcpmux);
            rtpConnector = new RTPConnectorTCPImpl((StreamConnector)streamConnector);
        }
        MediaStreamTarget target = this.getStreamTarget();
        if (target != null) {
            try {
                rtpConnector.addTarget(new SessionAddress(target.getDataAddress().getAddress(), target.getDataAddress().getPort()));
            }
            catch (IOException ioe) {
                logger.warn((Object)("Failed to add target to DTLS connector: " + ioe));
            }
        }
        this.dtlsControl.setConnector((AbstractRTPConnector)rtpConnector);
        this.dtlsControl.registerUser((Object)this);
        this.dtlsControl.start(MediaType.AUDIO);
    }

    /*
     * Exception decompiling
     */
    private void wrapupConnectivityEstablishment() throws OperationFailedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JitsiTransportManager
    extends net.java.sip.communicator.service.protocol.media.TransportManager<MediaAwareCallPeer<?, ?, ?>> {
        public static PortTracker getPortTracker(MediaType mediaType) {
            return net.java.sip.communicator.service.protocol.media.TransportManager.getPortTracker((MediaType)mediaType);
        }

        public static void initializePortNumbers() {
            net.java.sip.communicator.service.protocol.media.TransportManager.initializePortNumbers();
        }

        private JitsiTransportManager(MediaAwareCallPeer<?, ?, ?> callPeer) {
            super(callPeer);
        }

        public long getHarvestingTime(String arg0) {
            return 0L;
        }

        public String getICECandidateExtendedType(String arg0) {
            return null;
        }

        public InetSocketAddress getICELocalHostAddress(String arg0) {
            return null;
        }

        public InetSocketAddress getICELocalReflexiveAddress(String arg0) {
            return null;
        }

        public InetSocketAddress getICELocalRelayedAddress(String arg0) {
            return null;
        }

        public InetSocketAddress getICERemoteHostAddress(String arg0) {
            return null;
        }

        public InetSocketAddress getICERemoteReflexiveAddress(String arg0) {
            return null;
        }

        public InetSocketAddress getICERemoteRelayedAddress(String arg0) {
            return null;
        }

        public String getICEState() {
            return null;
        }

        protected InetAddress getIntendedDestination(MediaAwareCallPeer<?, ?, ?> arg0) {
            return null;
        }

        public int getNbHarvesting() {
            return 0;
        }

        public int getNbHarvesting(String arg0) {
            return 0;
        }

        public long getTotalHarvestingTime() {
            return 0L;
        }
    }
}

