/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.AbstractXmlConfigHelper;
import com.hazelcast.config.AwsConfig;
import com.hazelcast.config.CacheEvictionConfig;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.CacheSimpleEntryListenerConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigBuilder;
import com.hazelcast.config.CredentialsFactoryConfig;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.InterfacesConfig;
import com.hazelcast.config.ItemListenerConfig;
import com.hazelcast.config.JobTrackerConfig;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.ListConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.LoginModuleConfig;
import com.hazelcast.config.ManagementCenterConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapIndexConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.MaxSizeConfig;
import com.hazelcast.config.MemberGroupConfig;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.PartitionGroupConfig;
import com.hazelcast.config.PartitioningStrategyConfig;
import com.hazelcast.config.PermissionConfig;
import com.hazelcast.config.PermissionPolicyConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.QueueStoreConfig;
import com.hazelcast.config.ReplicatedMapConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SecurityConfig;
import com.hazelcast.config.SecurityInterceptorConfig;
import com.hazelcast.config.SemaphoreConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.ServiceConfig;
import com.hazelcast.config.ServicesConfig;
import com.hazelcast.config.SetConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.config.WanTargetClusterConfig;
import com.hazelcast.config.XmlConfigLocator;
import com.hazelcast.config.XmlConfigPreProcessor;
import com.hazelcast.config.XmlElements;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.mapreduce.TopologyChangedStrategy;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.spi.ServiceConfigurationParser;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlConfigBuilder
extends AbstractXmlConfigHelper
implements ConfigBuilder {
    private static final ILogger LOGGER = Logger.getLogger(XmlConfigBuilder.class);
    private static final int DEFAULT_VALUE = 5;
    private static final int THOUSAND_FACTOR = 5;
    private final XmlConfigPreProcessor xmlConfigPreProcessor = new XmlConfigPreProcessor(this);
    private Config config;
    private InputStream in;
    private File configurationFile;
    private URL configurationUrl;
    private Properties properties = System.getProperties();
    private Set<String> occurrenceSet = new HashSet<String>();
    private Element root;

    public XmlConfigBuilder(String xmlFileName) throws FileNotFoundException {
        this(new FileInputStream(xmlFileName));
    }

    public XmlConfigBuilder(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream can't be null");
        }
        this.in = inputStream;
    }

    public XmlConfigBuilder(URL url) throws IOException {
        if (url == null) {
            throw new NullPointerException("URL is null!");
        }
        this.in = url.openStream();
    }

    public XmlConfigBuilder() {
        XmlConfigLocator locator = new XmlConfigLocator();
        this.in = locator.getIn();
        this.configurationFile = locator.getConfigurationFile();
        this.configurationUrl = locator.getConfigurationUrl();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public XmlConfigBuilder setProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    @Override
    public Config build() {
        Config config = new Config();
        config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
        return this.build(config);
    }

    Config build(Config config) {
        config.setConfigurationFile(this.configurationFile);
        config.setConfigurationUrl(this.configurationUrl);
        try {
            this.parseAndBuildConfig(config);
        }
        catch (Exception e) {
            throw new HazelcastException(e.getMessage(), e);
        }
        return config;
    }

    private void parseAndBuildConfig(Config config) throws Exception {
        this.config = config;
        Document doc = this.parse(this.in);
        this.root = doc.getDocumentElement();
        try {
            this.root.getTextContent();
        }
        catch (Throwable e) {
            this.domLevel3 = false;
        }
        this.xmlConfigPreProcessor.process(this.root);
        this.handleConfig(this.root);
    }

    Document parse(InputStream is) throws Exception {
        Document doc;
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        try {
            doc = builder.parse(is);
        }
        catch (Exception e) {
            if (this.configurationFile != null) {
                String msg = "Failed to parse " + this.configurationFile + "\nException: " + e.getMessage() + "\nHazelcast startup interrupted.";
                LOGGER.severe(msg);
            } else if (this.configurationUrl != null) {
                String msg = "Failed to parse " + this.configurationUrl + "\nException: " + e.getMessage() + "\nHazelcast startup interrupted.";
                LOGGER.severe(msg);
            } else {
                String msg = "Failed to parse the inputstream\nException: " + e.getMessage() + "\nHazelcast startup interrupted.";
                LOGGER.severe(msg);
            }
            throw e;
        }
        finally {
            IOUtil.closeResource(is);
        }
        return doc;
    }

    private void handleConfig(Element docElement) throws Exception {
        for (Node node : new AbstractXmlConfigHelper.IterableNodeList(docElement.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(node.getNodeName());
            if (this.occurrenceSet.contains(nodeName)) {
                throw new IllegalStateException("Duplicate '" + nodeName + "' definition found in XML configuration. ");
            }
            if (this.handleXmlNode(node, nodeName) || XmlElements.canOccurMultipleTimes(nodeName)) continue;
            this.occurrenceSet.add(nodeName);
        }
    }

    private boolean handleXmlNode(Node node, String nodeName) throws Exception {
        if (XmlElements.NETWORK.isEqual(nodeName)) {
            this.handleNetwork(node);
        } else {
            if (XmlElements.IMPORT.isEqual(nodeName)) {
                throw new IllegalStateException("<import> element can appear only in the top level of the XML");
            }
            if (XmlElements.GROUP.isEqual(nodeName)) {
                this.handleGroup(node);
            } else if (XmlElements.PROPERTIES.isEqual(nodeName)) {
                this.fillProperties(node, this.config.getProperties());
            } else if (XmlElements.WAN_REPLICATION.isEqual(nodeName)) {
                this.handleWanReplication(node);
            } else if (XmlElements.EXECUTOR_SERVICE.isEqual(nodeName)) {
                this.handleExecutor(node);
            } else if (XmlElements.SERVICES.isEqual(nodeName)) {
                this.handleServices(node);
            } else if (XmlElements.QUEUE.isEqual(nodeName)) {
                this.handleQueue(node);
            } else if (XmlElements.MAP.isEqual(nodeName)) {
                this.handleMap(node);
            } else if (XmlElements.MULTIMAP.isEqual(nodeName)) {
                this.handleMultiMap(node);
            } else if (XmlElements.REPLICATED_MAP.isEqual(nodeName)) {
                this.handleReplicatedMap(node);
            } else if (XmlElements.LIST.isEqual(nodeName)) {
                this.handleList(node);
            } else if (XmlElements.SET.isEqual(nodeName)) {
                this.handleSet(node);
            } else if (XmlElements.TOPIC.isEqual(nodeName)) {
                this.handleTopic(node);
            } else if (XmlElements.CACHE.isEqual(nodeName)) {
                this.handleCache(node);
            } else if (XmlElements.NATIVE_MEMORY.isEqual(nodeName)) {
                this.fillNativeMemoryConfig(node, this.config.getNativeMemoryConfig());
            } else if (XmlElements.JOB_TRACKER.isEqual(nodeName)) {
                this.handleJobTracker(node);
            } else if (XmlElements.SEMAPHORE.isEqual(nodeName)) {
                this.handleSemaphore(node);
            } else if (XmlElements.LISTENERS.isEqual(nodeName)) {
                this.handleListeners(node);
            } else if (XmlElements.PARTITION_GROUP.isEqual(nodeName)) {
                this.handlePartitionGroup(node);
            } else if (XmlElements.SERIALIZATION.isEqual(nodeName)) {
                this.handleSerialization(node);
            } else if (XmlElements.SECURITY.isEqual(nodeName)) {
                this.handleSecurity(node);
            } else if (XmlElements.MEMBER_ATTRIBUTES.isEqual(nodeName)) {
                this.handleMemberAttributes(node);
            } else if (XmlElements.LICENSE_KEY.isEqual(nodeName)) {
                this.config.setLicenseKey(this.getTextContent(node));
            } else if (XmlElements.MANAGEMENT_CENTER.isEqual(nodeName)) {
                this.handleManagementCenterConfig(node);
            } else {
                return true;
            }
        }
        return false;
    }

    private void handleServices(Node node) {
        Node attDefaults = node.getAttributes().getNamedItem("enable-defaults");
        boolean enableDefaults = attDefaults == null || this.checkTrue(this.getTextContent(attDefaults));
        ServicesConfig servicesConfig = this.config.getServicesConfig();
        servicesConfig.setEnableDefaults(enableDefaults);
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(child.getNodeName());
            if (!"service".equals(nodeName)) continue;
            ServiceConfig serviceConfig = new ServiceConfig();
            String enabledValue = this.getAttribute(child, "enabled");
            boolean enabled = this.checkTrue(enabledValue);
            serviceConfig.setEnabled(enabled);
            for (Node n : new AbstractXmlConfigHelper.IterableNodeList(child.getChildNodes())) {
                String value = XmlConfigBuilder.cleanNodeName(n.getNodeName());
                if ("name".equals(value)) {
                    String name = this.getTextContent(n);
                    serviceConfig.setName(name);
                    continue;
                }
                if ("class-name".equals(value)) {
                    String className = this.getTextContent(n);
                    serviceConfig.setClassName(className);
                    continue;
                }
                if ("properties".equals(value)) {
                    this.fillProperties(n, serviceConfig.getProperties());
                    continue;
                }
                if (!"configuration".equals(value)) continue;
                Node parserNode = n.getAttributes().getNamedItem("parser");
                String parserClass = this.getTextContent(parserNode);
                if (parserNode == null || parserClass == null) {
                    throw new IllegalArgumentException("Parser is required!");
                }
                try {
                    ServiceConfigurationParser parser = (ServiceConfigurationParser)ClassLoaderUtil.newInstance(this.config.getClassLoader(), parserClass);
                    Object obj = parser.parse((Element)n);
                    serviceConfig.setConfigObject(obj);
                }
                catch (Exception e) {
                    ExceptionUtil.sneakyThrow(e);
                }
            }
            servicesConfig.addServiceConfig(serviceConfig);
        }
    }

    private void handleWanReplication(Node node) throws Exception {
        Node attName = node.getAttributes().getNamedItem("name");
        String name = this.getTextContent(attName);
        WanReplicationConfig wanReplicationConfig = new WanReplicationConfig();
        wanReplicationConfig.setName(name);
        for (Node nodeTarget : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(nodeTarget.getNodeName());
            if (!"target-cluster".equals(nodeName)) continue;
            WanTargetClusterConfig wanTarget = new WanTargetClusterConfig();
            String groupName = this.getAttribute(nodeTarget, "group-name");
            String groupPassword = this.getAttribute(nodeTarget, "group-password");
            if (groupName != null) {
                wanTarget.setGroupName(groupName);
            }
            if (groupPassword != null) {
                wanTarget.setGroupPassword(groupPassword);
            }
            for (Node targetChild : new AbstractXmlConfigHelper.IterableNodeList(nodeTarget.getChildNodes())) {
                String targetChildName = XmlConfigBuilder.cleanNodeName(targetChild.getNodeName());
                if ("replication-impl".equals(targetChildName)) {
                    wanTarget.setReplicationImpl(this.getTextContent(targetChild));
                    continue;
                }
                if (!"end-points".equals(targetChildName)) continue;
                for (Node address : new AbstractXmlConfigHelper.IterableNodeList(targetChild.getChildNodes())) {
                    String addressNodeName = XmlConfigBuilder.cleanNodeName(address.getNodeName());
                    if (!"address".equals(addressNodeName)) continue;
                    String addressStr = this.getTextContent(address);
                    wanTarget.addEndpoint(addressStr);
                }
            }
            wanReplicationConfig.addTargetClusterConfig(wanTarget);
        }
        this.config.addWanReplicationConfig(wanReplicationConfig);
    }

    private void handleNetwork(Node node) throws Exception {
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(child.getNodeName());
            if ("reuse-address".equals(nodeName)) {
                String value = this.getTextContent(child).trim();
                this.config.getNetworkConfig().setReuseAddress(this.checkTrue(value));
                continue;
            }
            if ("port".equals(nodeName)) {
                this.handlePort(child);
                continue;
            }
            if ("outbound-ports".equals(nodeName)) {
                this.handleOutboundPorts(child);
                continue;
            }
            if ("public-address".equals(nodeName)) {
                String address = this.getTextContent(child);
                this.config.getNetworkConfig().setPublicAddress(address);
                continue;
            }
            if ("join".equals(nodeName)) {
                this.handleJoin(child);
                continue;
            }
            if ("interfaces".equals(nodeName)) {
                this.handleInterfaces(child);
                continue;
            }
            if ("symmetric-encryption".equals(nodeName)) {
                this.handleViaReflection(child, this.config.getNetworkConfig(), new SymmetricEncryptionConfig());
                continue;
            }
            if ("ssl".equals(nodeName)) {
                this.handleSSLConfig(child);
                continue;
            }
            if (!"socket-interceptor".equals(nodeName)) continue;
            this.handleSocketInterceptorConfig(child);
        }
    }

    private void handleExecutor(Node node) throws Exception {
        ExecutorConfig executorConfig = new ExecutorConfig();
        this.handleViaReflection(node, this.config, executorConfig);
    }

    private void handleGroup(Node node) {
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String value = this.getTextContent(n).trim();
            String nodeName = XmlConfigBuilder.cleanNodeName(n.getNodeName());
            if ("name".equals(nodeName)) {
                this.config.getGroupConfig().setName(value);
                continue;
            }
            if (!"password".equals(nodeName)) continue;
            this.config.getGroupConfig().setPassword(value);
        }
    }

    private void handleInterfaces(Node node) {
        String value;
        NamedNodeMap atts = node.getAttributes();
        InterfacesConfig interfaces = this.config.getNetworkConfig().getInterfaces();
        for (int a = 0; a < atts.getLength(); ++a) {
            Node att = atts.item(a);
            if (!"enabled".equals(att.getNodeName())) continue;
            value = att.getNodeValue();
            interfaces.setEnabled(this.checkTrue(value));
        }
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            if (!"interface".equalsIgnoreCase(XmlConfigBuilder.cleanNodeName(n.getNodeName()))) continue;
            value = this.getTextContent(n).trim();
            interfaces.addInterface(value);
        }
    }

    private void handleViaReflection(Node node, Object parent, Object target) throws Exception {
        NamedNodeMap atts = node.getAttributes();
        if (atts != null) {
            for (int a = 0; a < atts.getLength(); ++a) {
                Node att = atts.item(a);
                String methodName = "set" + this.getMethodName(att.getNodeName());
                Method method = this.getMethod(target, methodName, true);
                String value = att.getNodeValue();
                this.invoke(target, method, value);
            }
        }
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String value = this.getTextContent(n).trim();
            String methodName = "set" + this.getMethodName(XmlConfigBuilder.cleanNodeName(n.getNodeName()));
            Method method = this.getMethod(target, methodName, true);
            this.invoke(target, method, value);
        }
        String mName = "set" + target.getClass().getSimpleName();
        Method method = this.getMethod(parent, mName, false);
        if (method == null) {
            mName = "add" + target.getClass().getSimpleName();
            method = this.getMethod(parent, mName, false);
        }
        method.invoke(parent, target);
    }

    private void invoke(Object target, Method method, String value) {
        if (method == null) {
            return;
        }
        Class<?>[] args = method.getParameterTypes();
        if (args == null || args.length == 0) {
            return;
        }
        Class<?> arg = method.getParameterTypes()[0];
        try {
            if (arg == String.class) {
                method.invoke(target, value);
            } else if (arg == Integer.TYPE) {
                method.invoke(target, Integer.parseInt(value));
            } else if (arg == Long.TYPE) {
                method.invoke(target, Long.parseLong(value));
            } else if (arg == Boolean.TYPE) {
                method.invoke(target, Boolean.parseBoolean(value));
            }
        }
        catch (Exception e) {
            LOGGER.warning(e);
        }
    }

    private Method getMethod(Object target, String methodName, boolean requiresArg) {
        Method[] methods;
        for (Method method : methods = target.getClass().getMethods()) {
            if (!method.getName().equalsIgnoreCase(methodName)) continue;
            if (requiresArg) {
                Class<?> arg;
                Class<?>[] args = method.getParameterTypes();
                if (args == null || args.length == 0 || (arg = method.getParameterTypes()[0]) != String.class && arg != Integer.TYPE && arg != Long.TYPE && arg != Boolean.TYPE) continue;
                return method;
            }
            return method;
        }
        return null;
    }

    private String getMethodName(String element) {
        StringBuilder sb = new StringBuilder();
        char[] chars = element.toCharArray();
        boolean upper = true;
        for (char c : chars) {
            if (c == '_' || c == '-' || c == '.') {
                upper = true;
                continue;
            }
            if (upper) {
                sb.append(Character.toUpperCase(c));
                upper = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private void handleJoin(Node node) {
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String name = XmlConfigBuilder.cleanNodeName(child.getNodeName());
            if ("multicast".equals(name)) {
                this.handleMulticast(child);
                continue;
            }
            if ("tcp-ip".equals(name)) {
                this.handleTcpIp(child);
                continue;
            }
            if (!"aws".equals(name)) continue;
            this.handleAWS(child);
        }
        JoinConfig joinConfig = this.config.getNetworkConfig().getJoin();
        joinConfig.verify();
    }

    private void handleAWS(Node node) {
        String value;
        JoinConfig join = this.config.getNetworkConfig().getJoin();
        NamedNodeMap atts = node.getAttributes();
        AwsConfig awsConfig = join.getAwsConfig();
        for (int a = 0; a < atts.getLength(); ++a) {
            Node att = atts.item(a);
            value = this.getTextContent(att).trim();
            if ("enabled".equalsIgnoreCase(att.getNodeName())) {
                awsConfig.setEnabled(this.checkTrue(value));
                continue;
            }
            if (!att.getNodeName().equals("connection-timeout-seconds")) continue;
            awsConfig.setConnectionTimeoutSeconds(this.getIntegerValue("connection-timeout-seconds", value, 5));
        }
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            value = this.getTextContent(n).trim();
            if ("secret-key".equals(XmlConfigBuilder.cleanNodeName(n.getNodeName()))) {
                awsConfig.setSecretKey(value);
                continue;
            }
            if ("access-key".equals(XmlConfigBuilder.cleanNodeName(n.getNodeName()))) {
                awsConfig.setAccessKey(value);
                continue;
            }
            if ("region".equals(XmlConfigBuilder.cleanNodeName(n.getNodeName()))) {
                awsConfig.setRegion(value);
                continue;
            }
            if ("host-header".equals(XmlConfigBuilder.cleanNodeName(n.getNodeName()))) {
                awsConfig.setHostHeader(value);
                continue;
            }
            if ("security-group-name".equals(XmlConfigBuilder.cleanNodeName(n.getNodeName()))) {
                awsConfig.setSecurityGroupName(value);
                continue;
            }
            if ("tag-key".equals(XmlConfigBuilder.cleanNodeName(n.getNodeName()))) {
                awsConfig.setTagKey(value);
                continue;
            }
            if (!"tag-value".equals(XmlConfigBuilder.cleanNodeName(n.getNodeName()))) continue;
            awsConfig.setTagValue(value);
        }
    }

    private void handleMulticast(Node node) {
        String value;
        JoinConfig join = this.config.getNetworkConfig().getJoin();
        NamedNodeMap atts = node.getAttributes();
        MulticastConfig multicastConfig = join.getMulticastConfig();
        for (int a = 0; a < atts.getLength(); ++a) {
            Node att = atts.item(a);
            value = this.getTextContent(att).trim();
            if ("enabled".equalsIgnoreCase(att.getNodeName())) {
                multicastConfig.setEnabled(this.checkTrue(value));
                continue;
            }
            if (!"loopbackModeEnabled".equalsIgnoreCase(att.getNodeName())) continue;
            multicastConfig.setLoopbackModeEnabled(this.checkTrue(value));
        }
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            value = this.getTextContent(n).trim();
            if ("multicast-group".equals(XmlConfigBuilder.cleanNodeName(n.getNodeName()))) {
                multicastConfig.setMulticastGroup(value);
                continue;
            }
            if ("multicast-port".equals(XmlConfigBuilder.cleanNodeName(n.getNodeName()))) {
                multicastConfig.setMulticastPort(Integer.parseInt(value));
                continue;
            }
            if ("multicast-timeout-seconds".equals(XmlConfigBuilder.cleanNodeName(n.getNodeName()))) {
                multicastConfig.setMulticastTimeoutSeconds(Integer.parseInt(value));
                continue;
            }
            if ("multicast-time-to-live-seconds".equals(XmlConfigBuilder.cleanNodeName(n.getNodeName()))) {
                multicastConfig.setMulticastTimeToLive(Integer.parseInt(value));
                continue;
            }
            if ("multicast-time-to-live".equals(XmlConfigBuilder.cleanNodeName(n.getNodeName()))) {
                multicastConfig.setMulticastTimeToLive(Integer.parseInt(value));
                continue;
            }
            if (!"trusted-interfaces".equals(XmlConfigBuilder.cleanNodeName(n.getNodeName()))) continue;
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(n.getChildNodes())) {
                if (!"interface".equalsIgnoreCase(XmlConfigBuilder.cleanNodeName(child.getNodeName()))) continue;
                multicastConfig.addTrustedInterface(this.getTextContent(child).trim());
            }
        }
    }

    private void handleTcpIp(Node node) {
        NamedNodeMap atts = node.getAttributes();
        JoinConfig join = this.config.getNetworkConfig().getJoin();
        TcpIpConfig tcpIpConfig = join.getTcpIpConfig();
        for (int a = 0; a < atts.getLength(); ++a) {
            Node att = atts.item(a);
            String value = this.getTextContent(att).trim();
            if (att.getNodeName().equals("enabled")) {
                tcpIpConfig.setEnabled(this.checkTrue(value));
                continue;
            }
            if (!att.getNodeName().equals("connection-timeout-seconds")) continue;
            tcpIpConfig.setConnectionTimeoutSeconds(this.getIntegerValue("connection-timeout-seconds", value, 5));
        }
        NodeList nodelist = node.getChildNodes();
        HashSet<String> memberTags = new HashSet<String>(Arrays.asList("interface", "member", "members"));
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Node n = nodelist.item(i);
            String value = this.getTextContent(n).trim();
            if (XmlConfigBuilder.cleanNodeName(n.getNodeName()).equals("required-member")) {
                tcpIpConfig.setRequiredMember(value);
                continue;
            }
            if (!memberTags.contains(XmlConfigBuilder.cleanNodeName(n.getNodeName()))) continue;
            tcpIpConfig.addMember(value);
        }
    }

    private void handlePort(Node node) {
        String portStr = this.getTextContent(node).trim();
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        if (portStr != null && portStr.length() > 0) {
            networkConfig.setPort(Integer.parseInt(portStr));
        }
        NamedNodeMap atts = node.getAttributes();
        for (int a = 0; a < atts.getLength(); ++a) {
            Node att = atts.item(a);
            String value = this.getTextContent(att).trim();
            if ("auto-increment".equals(att.getNodeName())) {
                networkConfig.setPortAutoIncrement(this.checkTrue(value));
                continue;
            }
            if (!"port-count".equals(att.getNodeName())) continue;
            int portCount = Integer.parseInt(value);
            networkConfig.setPortCount(portCount);
        }
    }

    private void handleOutboundPorts(Node child) {
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(child.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n.getNodeName());
            if (!"ports".equals(nodeName)) continue;
            String value = this.getTextContent(n);
            networkConfig.addOutboundPortDefinition(value);
        }
    }

    private void handleQueue(Node node) {
        Node attName = node.getAttributes().getNamedItem("name");
        String name = this.getTextContent(attName);
        QueueConfig qConfig = new QueueConfig();
        qConfig.setName(name);
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n.getNodeName());
            String value = this.getTextContent(n).trim();
            if ("max-size".equals(nodeName)) {
                qConfig.setMaxSize(this.getIntegerValue("max-size", value, 0));
                continue;
            }
            if ("backup-count".equals(nodeName)) {
                qConfig.setBackupCount(this.getIntegerValue("backup-count", value, 1));
                continue;
            }
            if ("async-backup-count".equals(nodeName)) {
                qConfig.setAsyncBackupCount(this.getIntegerValue("async-backup-count", value, 0));
                continue;
            }
            if ("item-listeners".equals(nodeName)) {
                for (Node listenerNode : new AbstractXmlConfigHelper.IterableNodeList(n.getChildNodes())) {
                    if (!"item-listener".equals(this.cleanNodeName(listenerNode))) continue;
                    NamedNodeMap attrs = listenerNode.getAttributes();
                    boolean incValue = this.checkTrue(this.getTextContent(attrs.getNamedItem("include-value")));
                    String listenerClass = this.getTextContent(listenerNode);
                    qConfig.addItemListenerConfig(new ItemListenerConfig(listenerClass, incValue));
                }
                continue;
            }
            if ("statistics-enabled".equals(nodeName)) {
                qConfig.setStatisticsEnabled(this.checkTrue(value));
                continue;
            }
            if ("queue-store".equals(nodeName)) {
                QueueStoreConfig queueStoreConfig = this.createQueueStoreConfig(n);
                qConfig.setQueueStoreConfig(queueStoreConfig);
                continue;
            }
            if (!"empty-queue-ttl".equals(nodeName)) continue;
            qConfig.setEmptyQueueTtl(this.getIntegerValue("empty-queue-ttl", value, -1));
        }
        this.config.addQueueConfig(qConfig);
    }

    private void handleList(Node node) {
        Node attName = node.getAttributes().getNamedItem("name");
        String name = this.getTextContent(attName);
        ListConfig lConfig = new ListConfig();
        lConfig.setName(name);
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n.getNodeName());
            String value = this.getTextContent(n).trim();
            if ("max-size".equals(nodeName)) {
                lConfig.setMaxSize(this.getIntegerValue("max-size", value, 0));
                continue;
            }
            if ("backup-count".equals(nodeName)) {
                lConfig.setBackupCount(this.getIntegerValue("backup-count", value, 1));
                continue;
            }
            if ("async-backup-count".equals(nodeName)) {
                lConfig.setAsyncBackupCount(this.getIntegerValue("async-backup-count", value, 0));
                continue;
            }
            if ("item-listeners".equals(nodeName)) {
                for (Node listenerNode : new AbstractXmlConfigHelper.IterableNodeList(n.getChildNodes())) {
                    if (!"item-listener".equals(this.cleanNodeName(listenerNode))) continue;
                    NamedNodeMap attrs = listenerNode.getAttributes();
                    boolean incValue = this.checkTrue(this.getTextContent(attrs.getNamedItem("include-value")));
                    String listenerClass = this.getTextContent(listenerNode);
                    lConfig.addItemListenerConfig(new ItemListenerConfig(listenerClass, incValue));
                }
                continue;
            }
            if (!"statistics-enabled".equals(nodeName)) continue;
            lConfig.setStatisticsEnabled(this.checkTrue(value));
        }
        this.config.addListConfig(lConfig);
    }

    private void handleSet(Node node) {
        Node attName = node.getAttributes().getNamedItem("name");
        String name = this.getTextContent(attName);
        SetConfig sConfig = new SetConfig();
        sConfig.setName(name);
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n.getNodeName());
            String value = this.getTextContent(n).trim();
            if ("max-size".equals(nodeName)) {
                sConfig.setMaxSize(this.getIntegerValue("max-size", value, 0));
                continue;
            }
            if ("backup-count".equals(nodeName)) {
                sConfig.setBackupCount(this.getIntegerValue("backup-count", value, 1));
                continue;
            }
            if ("async-backup-count".equals(nodeName)) {
                sConfig.setAsyncBackupCount(this.getIntegerValue("async-backup-count", value, 0));
                continue;
            }
            if ("item-listeners".equals(nodeName)) {
                for (Node listenerNode : new AbstractXmlConfigHelper.IterableNodeList(n.getChildNodes())) {
                    if (!"item-listener".equals(this.cleanNodeName(listenerNode))) continue;
                    NamedNodeMap attrs = listenerNode.getAttributes();
                    boolean incValue = this.checkTrue(this.getTextContent(attrs.getNamedItem("include-value")));
                    String listenerClass = this.getTextContent(listenerNode);
                    sConfig.addItemListenerConfig(new ItemListenerConfig(listenerClass, incValue));
                }
                continue;
            }
            if (!"statistics-enabled".equals(nodeName)) continue;
            sConfig.setStatisticsEnabled(this.checkTrue(value));
        }
        this.config.addSetConfig(sConfig);
    }

    private void handleMultiMap(Node node) {
        Node attName = node.getAttributes().getNamedItem("name");
        String name = this.getTextContent(attName);
        MultiMapConfig multiMapConfig = new MultiMapConfig();
        multiMapConfig.setName(name);
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n.getNodeName());
            String value = this.getTextContent(n).trim();
            if ("value-collection-type".equals(nodeName)) {
                multiMapConfig.setValueCollectionType(value);
                continue;
            }
            if ("backup-count".equals(nodeName)) {
                multiMapConfig.setBackupCount(this.getIntegerValue("backup-count", value, 1));
                continue;
            }
            if ("async-backup-count".equals(nodeName)) {
                multiMapConfig.setAsyncBackupCount(this.getIntegerValue("async-backup-count", value, 0));
                continue;
            }
            if ("entry-listeners".equals(nodeName)) {
                for (Node listenerNode : new AbstractXmlConfigHelper.IterableNodeList(n.getChildNodes())) {
                    if (!"entry-listener".equals(this.cleanNodeName(listenerNode))) continue;
                    NamedNodeMap attrs = listenerNode.getAttributes();
                    boolean incValue = this.checkTrue(this.getTextContent(attrs.getNamedItem("include-value")));
                    boolean local = this.checkTrue(this.getTextContent(attrs.getNamedItem("local")));
                    String listenerClass = this.getTextContent(listenerNode);
                    multiMapConfig.addEntryListenerConfig(new EntryListenerConfig(listenerClass, local, incValue));
                }
                continue;
            }
            if (!"statistics-enabled".equals(nodeName)) continue;
            multiMapConfig.setStatisticsEnabled(this.checkTrue(value));
        }
        this.config.addMultiMapConfig(multiMapConfig);
    }

    private void handleReplicatedMap(Node node) {
        Node attName = node.getAttributes().getNamedItem("name");
        String name = this.getTextContent(attName);
        ReplicatedMapConfig replicatedMapConfig = new ReplicatedMapConfig();
        replicatedMapConfig.setName(name);
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n.getNodeName());
            String value = this.getTextContent(n).trim();
            if ("concurrency-level".equals(nodeName)) {
                replicatedMapConfig.setConcurrencyLevel(this.getIntegerValue("concurrency-level", value, 32));
                continue;
            }
            if ("in-memory-format".equals(nodeName)) {
                replicatedMapConfig.setInMemoryFormat(InMemoryFormat.valueOf(StringUtil.upperCaseInternal(value)));
                continue;
            }
            if ("replication-delay-millis".equals(nodeName)) {
                replicatedMapConfig.setReplicationDelayMillis(this.getIntegerValue("replication-delay-millis", value, 100));
                continue;
            }
            if ("async-fillup".equals(nodeName)) {
                replicatedMapConfig.setAsyncFillup(this.checkTrue(value));
                continue;
            }
            if ("statistics-enabled".equals(nodeName)) {
                replicatedMapConfig.setStatisticsEnabled(this.checkTrue(value));
                continue;
            }
            if (!"entry-listeners".equals(nodeName)) continue;
            for (Node listenerNode : new AbstractXmlConfigHelper.IterableNodeList(n.getChildNodes())) {
                if (!"entry-listener".equals(this.cleanNodeName(listenerNode))) continue;
                NamedNodeMap attrs = listenerNode.getAttributes();
                boolean incValue = this.checkTrue(this.getTextContent(attrs.getNamedItem("include-value")));
                boolean local = this.checkTrue(this.getTextContent(attrs.getNamedItem("local")));
                String listenerClass = this.getTextContent(listenerNode);
                replicatedMapConfig.addEntryListenerConfig(new EntryListenerConfig(listenerClass, local, incValue));
            }
        }
        this.config.addReplicatedMapConfig(replicatedMapConfig);
    }

    private void handleMap(Node node) throws Exception {
        String name = this.getAttribute(node, "name");
        MapConfig mapConfig = new MapConfig();
        mapConfig.setName(name);
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n.getNodeName());
            String value = this.getTextContent(n).trim();
            if ("backup-count".equals(nodeName)) {
                mapConfig.setBackupCount(this.getIntegerValue("backup-count", value, 1));
                continue;
            }
            if ("in-memory-format".equals(nodeName)) {
                mapConfig.setInMemoryFormat(InMemoryFormat.valueOf(StringUtil.upperCaseInternal(value)));
                continue;
            }
            if ("async-backup-count".equals(nodeName)) {
                mapConfig.setAsyncBackupCount(this.getIntegerValue("async-backup-count", value, 0));
                continue;
            }
            if ("eviction-policy".equals(nodeName)) {
                mapConfig.setEvictionPolicy(EvictionPolicy.valueOf(StringUtil.upperCaseInternal(value)));
                continue;
            }
            if ("max-size".equals(nodeName)) {
                MaxSizeConfig msc = mapConfig.getMaxSizeConfig();
                Node maxSizePolicy = n.getAttributes().getNamedItem("policy");
                if (maxSizePolicy != null) {
                    msc.setMaxSizePolicy(MaxSizeConfig.MaxSizePolicy.valueOf(StringUtil.upperCaseInternal(this.getTextContent(maxSizePolicy))));
                }
                int size = this.sizeParser(value);
                msc.setSize(size);
                continue;
            }
            if ("eviction-percentage".equals(nodeName)) {
                mapConfig.setEvictionPercentage(this.getIntegerValue("eviction-percentage", value, 25));
                continue;
            }
            if ("min-eviction-check-millis".equals(nodeName)) {
                mapConfig.setMinEvictionCheckMillis(this.getLongValue("min-eviction-check-millis", value, 100L));
                continue;
            }
            if ("time-to-live-seconds".equals(nodeName)) {
                mapConfig.setTimeToLiveSeconds(this.getIntegerValue("time-to-live-seconds", value, 0));
                continue;
            }
            if ("max-idle-seconds".equals(nodeName)) {
                mapConfig.setMaxIdleSeconds(this.getIntegerValue("max-idle-seconds", value, 0));
                continue;
            }
            if ("map-store".equals(nodeName)) {
                MapStoreConfig mapStoreConfig = this.createMapStoreConfig(n);
                mapConfig.setMapStoreConfig(mapStoreConfig);
                continue;
            }
            if ("near-cache".equals(nodeName)) {
                this.handleViaReflection(n, mapConfig, new NearCacheConfig());
                continue;
            }
            if ("merge-policy".equals(nodeName)) {
                mapConfig.setMergePolicy(value);
                continue;
            }
            if ("read-backup-data".equals(nodeName)) {
                mapConfig.setReadBackupData(this.checkTrue(value));
                continue;
            }
            if ("statistics-enabled".equals(nodeName)) {
                mapConfig.setStatisticsEnabled(this.checkTrue(value));
                continue;
            }
            if ("optimize-queries".equals(nodeName)) {
                mapConfig.setOptimizeQueries(this.checkTrue(value));
                continue;
            }
            if ("wan-replication-ref".equals(nodeName)) {
                this.mapWanReplicationRefHandle(n, mapConfig);
                continue;
            }
            if ("indexes".equals(nodeName)) {
                this.mapIndexesHandle(n, mapConfig);
                continue;
            }
            if ("entry-listeners".equals(nodeName)) {
                this.mapEntryListenerHandle(n, mapConfig);
                continue;
            }
            if (!"partition-strategy".equals(nodeName)) continue;
            mapConfig.setPartitioningStrategyConfig(new PartitioningStrategyConfig(value));
        }
        this.config.addMapConfig(mapConfig);
    }

    private void handleCache(Node node) throws Exception {
        String name = this.getAttribute(node, "name");
        CacheSimpleConfig cacheConfig = new CacheSimpleConfig();
        cacheConfig.setName(name);
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n.getNodeName());
            String value = this.getTextContent(n).trim();
            if ("key-type".equals(nodeName)) {
                cacheConfig.setKeyType(this.getAttribute(n, "class-name"));
                continue;
            }
            if ("value-type".equals(nodeName)) {
                cacheConfig.setValueType(this.getAttribute(n, "class-name"));
                continue;
            }
            if ("statistics-enabled".equals(nodeName)) {
                cacheConfig.setStatisticsEnabled(this.checkTrue(value));
                continue;
            }
            if ("management-enabled".equals(nodeName)) {
                cacheConfig.setManagementEnabled(this.checkTrue(value));
                continue;
            }
            if ("read-through".equals(nodeName)) {
                cacheConfig.setReadThrough(this.checkTrue(value));
                continue;
            }
            if ("write-through".equals(nodeName)) {
                cacheConfig.setWriteThrough(this.checkTrue(value));
                continue;
            }
            if ("cache-loader-factory".equals(nodeName)) {
                cacheConfig.setCacheLoaderFactory(this.getAttribute(n, "class-name"));
                continue;
            }
            if ("cache-writer-factory".equals(nodeName)) {
                cacheConfig.setCacheWriterFactory(this.getAttribute(n, "class-name"));
                continue;
            }
            if ("expiry-policy-factory".equals(nodeName)) {
                cacheConfig.setExpiryPolicyFactory(this.getAttribute(n, "class-name"));
                continue;
            }
            if ("cache-entry-listeners".equals(nodeName)) {
                this.cacheListenerHandle(n, cacheConfig);
                continue;
            }
            if ("in-memory-format".equals(nodeName)) {
                cacheConfig.setInMemoryFormat(InMemoryFormat.valueOf(StringUtil.upperCaseInternal(value)));
                continue;
            }
            if ("backup-count".equals(nodeName)) {
                cacheConfig.setBackupCount(this.getIntegerValue("backup-count", value, 1));
                continue;
            }
            if ("async-backup-count".equals(nodeName)) {
                cacheConfig.setAsyncBackupCount(this.getIntegerValue("async-backup-count", value, 0));
                continue;
            }
            if (!"eviction".equals(nodeName)) continue;
            CacheEvictionConfig evictionConfig = new CacheEvictionConfig();
            Node size = n.getAttributes().getNamedItem("size");
            Node maxSizePolicy = n.getAttributes().getNamedItem("max-size-policy");
            Node evictionPolicy = n.getAttributes().getNamedItem("eviction-policy");
            if (size != null) {
                evictionConfig.setSize(Integer.parseInt(this.getTextContent(size)));
            }
            if (maxSizePolicy != null) {
                evictionConfig.setMaxSizePolicy(CacheEvictionConfig.CacheMaxSizePolicy.valueOf(StringUtil.upperCaseInternal(this.getTextContent(maxSizePolicy))));
            }
            if (evictionPolicy != null) {
                evictionConfig.setEvictionPolicy(EvictionPolicy.valueOf(StringUtil.upperCaseInternal(this.getTextContent(evictionPolicy))));
            }
            cacheConfig.setEvictionConfig(evictionConfig);
        }
        this.config.addCacheConfig(cacheConfig);
    }

    private void cacheListenerHandle(Node n, CacheSimpleConfig cacheSimpleConfig) {
        for (Node listenerNode : new AbstractXmlConfigHelper.IterableNodeList(n.getChildNodes())) {
            if (!"cache-entry-listener".equals(this.cleanNodeName(listenerNode))) continue;
            CacheSimpleEntryListenerConfig listenerConfig = new CacheSimpleEntryListenerConfig();
            for (Node listenerChildNode : new AbstractXmlConfigHelper.IterableNodeList(listenerNode.getChildNodes())) {
                if ("cache-entry-listener-factory".equals(this.cleanNodeName(listenerChildNode))) {
                    listenerConfig.setCacheEntryListenerFactory(this.getAttribute(listenerChildNode, "class-name"));
                }
                if (!"cache-entry-event-filter-factory".equals(this.cleanNodeName(listenerChildNode))) continue;
                listenerConfig.setCacheEntryEventFilterFactory(this.getAttribute(listenerChildNode, "class-name"));
            }
            NamedNodeMap attrs = listenerNode.getAttributes();
            listenerConfig.setOldValueRequired(this.checkTrue(this.getTextContent(attrs.getNamedItem("old-value-required"))));
            listenerConfig.setSynchronous(this.checkTrue(this.getTextContent(attrs.getNamedItem("synchronous"))));
            cacheSimpleConfig.addEntryListenerConfig(listenerConfig);
        }
    }

    private void mapWanReplicationRefHandle(Node n, MapConfig mapConfig) {
        WanReplicationRef wanReplicationRef = new WanReplicationRef();
        String wanName = this.getAttribute(n, "name");
        wanReplicationRef.setName(wanName);
        for (Node wanChild : new AbstractXmlConfigHelper.IterableNodeList(n.getChildNodes())) {
            String wanChildName = XmlConfigBuilder.cleanNodeName(wanChild.getNodeName());
            String wanChildValue = this.getTextContent(n);
            if (!"merge-policy".equals(wanChildName)) continue;
            wanReplicationRef.setMergePolicy(wanChildValue);
        }
        mapConfig.setWanReplicationRef(wanReplicationRef);
    }

    private void mapIndexesHandle(Node n, MapConfig mapConfig) {
        for (Node indexNode : new AbstractXmlConfigHelper.IterableNodeList(n.getChildNodes())) {
            if (!"index".equals(this.cleanNodeName(indexNode))) continue;
            NamedNodeMap attrs = indexNode.getAttributes();
            boolean ordered = this.checkTrue(this.getTextContent(attrs.getNamedItem("ordered")));
            String attribute = this.getTextContent(indexNode);
            mapConfig.addMapIndexConfig(new MapIndexConfig(attribute, ordered));
        }
    }

    private void mapEntryListenerHandle(Node n, MapConfig mapConfig) {
        for (Node listenerNode : new AbstractXmlConfigHelper.IterableNodeList(n.getChildNodes())) {
            if (!"entry-listener".equals(this.cleanNodeName(listenerNode))) continue;
            NamedNodeMap attrs = listenerNode.getAttributes();
            boolean incValue = this.checkTrue(this.getTextContent(attrs.getNamedItem("include-value")));
            boolean local = this.checkTrue(this.getTextContent(attrs.getNamedItem("local")));
            String listenerClass = this.getTextContent(listenerNode);
            mapConfig.addEntryListenerConfig(new EntryListenerConfig(listenerClass, local, incValue));
        }
    }

    private int sizeParser(String value) {
        int size;
        if (value.length() < 2) {
            size = Integer.parseInt(value);
        } else {
            char last = value.charAt(value.length() - 1);
            int type = 0;
            if (last == 'g' || last == 'G') {
                type = 1;
            } else if (last == 'm' || last == 'M') {
                type = 2;
            }
            size = type == 0 ? Integer.parseInt(value) : (type == 1 ? Integer.parseInt(value.substring(0, value.length() - 1)) * 5 : Integer.parseInt(value.substring(0, value.length() - 1)));
        }
        return size;
    }

    private MapStoreConfig createMapStoreConfig(Node node) {
        MapStoreConfig mapStoreConfig = new MapStoreConfig();
        NamedNodeMap atts = node.getAttributes();
        for (int a = 0; a < atts.getLength(); ++a) {
            Node att = atts.item(a);
            String value = this.getTextContent(att).trim();
            if ("enabled".equals(att.getNodeName())) {
                mapStoreConfig.setEnabled(this.checkTrue(value));
                continue;
            }
            if (!"initial-mode".equals(att.getNodeName())) continue;
            MapStoreConfig.InitialLoadMode mode = MapStoreConfig.InitialLoadMode.valueOf(StringUtil.upperCaseInternal(this.getTextContent(att)));
            mapStoreConfig.setInitialLoadMode(mode);
        }
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n.getNodeName());
            if ("class-name".equals(nodeName)) {
                mapStoreConfig.setClassName(this.getTextContent(n).trim());
                continue;
            }
            if ("factory-class-name".equals(nodeName)) {
                mapStoreConfig.setFactoryClassName(this.getTextContent(n).trim());
                continue;
            }
            if ("write-delay-seconds".equals(nodeName)) {
                mapStoreConfig.setWriteDelaySeconds(this.getIntegerValue("write-delay-seconds", this.getTextContent(n).trim(), 0));
                continue;
            }
            if ("write-batch-size".equals(nodeName)) {
                mapStoreConfig.setWriteBatchSize(this.getIntegerValue("write-batch-size", this.getTextContent(n).trim(), 1));
                continue;
            }
            if (!"properties".equals(nodeName)) continue;
            this.fillProperties(n, mapStoreConfig.getProperties());
        }
        return mapStoreConfig;
    }

    private QueueStoreConfig createQueueStoreConfig(Node node) {
        QueueStoreConfig queueStoreConfig = new QueueStoreConfig();
        NamedNodeMap atts = node.getAttributes();
        for (int a = 0; a < atts.getLength(); ++a) {
            Node att = atts.item(a);
            String value = this.getTextContent(att).trim();
            if (!att.getNodeName().equals("enabled")) continue;
            queueStoreConfig.setEnabled(this.checkTrue(value));
        }
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n.getNodeName());
            if ("class-name".equals(nodeName)) {
                queueStoreConfig.setClassName(this.getTextContent(n).trim());
                continue;
            }
            if ("factory-class-name".equals(nodeName)) {
                queueStoreConfig.setFactoryClassName(this.getTextContent(n).trim());
                continue;
            }
            if (!"properties".equals(nodeName)) continue;
            this.fillProperties(n, queueStoreConfig.getProperties());
        }
        return queueStoreConfig;
    }

    private void handleSSLConfig(Node node) {
        SSLConfig sslConfig = new SSLConfig();
        NamedNodeMap atts = node.getAttributes();
        Node enabledNode = atts.getNamedItem("enabled");
        boolean enabled = enabledNode != null && this.checkTrue(this.getTextContent(enabledNode).trim());
        sslConfig.setEnabled(enabled);
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n.getNodeName());
            if ("factory-class-name".equals(nodeName)) {
                sslConfig.setFactoryClassName(this.getTextContent(n).trim());
                continue;
            }
            if (!"properties".equals(nodeName)) continue;
            this.fillProperties(n, sslConfig.getProperties());
        }
        this.config.getNetworkConfig().setSSLConfig(sslConfig);
    }

    private void handleSocketInterceptorConfig(Node node) {
        SocketInterceptorConfig socketInterceptorConfig = this.parseSocketInterceptorConfig(node);
        this.config.getNetworkConfig().setSocketInterceptorConfig(socketInterceptorConfig);
    }

    private void handleTopic(Node node) {
        Node attName = node.getAttributes().getNamedItem("name");
        String name = this.getTextContent(attName);
        TopicConfig tConfig = new TopicConfig();
        tConfig.setName(name);
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n.getNodeName());
            if (nodeName.equals("global-ordering-enabled")) {
                tConfig.setGlobalOrderingEnabled(this.checkTrue(this.getTextContent(n)));
                continue;
            }
            if ("message-listeners".equals(nodeName)) {
                for (Node listenerNode : new AbstractXmlConfigHelper.IterableNodeList(n.getChildNodes())) {
                    if (!"message-listener".equals(this.cleanNodeName(listenerNode))) continue;
                    tConfig.addMessageListenerConfig(new ListenerConfig(this.getTextContent(listenerNode)));
                }
                continue;
            }
            if (!"statistics-enabled".equals(nodeName)) continue;
            tConfig.setStatisticsEnabled(this.checkTrue(this.getTextContent(n)));
        }
        this.config.addTopicConfig(tConfig);
    }

    private void handleJobTracker(Node node) {
        Node attName = node.getAttributes().getNamedItem("name");
        String name = this.getTextContent(attName);
        JobTrackerConfig jConfig = new JobTrackerConfig();
        jConfig.setName(name);
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n.getNodeName());
            String value = this.getTextContent(n).trim();
            if ("max-thread-size".equals(nodeName)) {
                jConfig.setMaxThreadSize(this.getIntegerValue("max-thread-size", value, JobTrackerConfig.DEFAULT_MAX_THREAD_SIZE));
                continue;
            }
            if ("queue-size".equals(nodeName)) {
                jConfig.setQueueSize(this.getIntegerValue("queue-size", value, 0));
                continue;
            }
            if ("retry-count".equals(nodeName)) {
                jConfig.setRetryCount(this.getIntegerValue("retry-count", value, 0));
                continue;
            }
            if ("chunk-size".equals(nodeName)) {
                jConfig.setChunkSize(this.getIntegerValue("chunk-size", value, 1000));
                continue;
            }
            if ("communicate-stats".equals(nodeName)) {
                jConfig.setCommunicateStats(value == null || value.length() == 0 ? true : Boolean.parseBoolean(value));
                continue;
            }
            if (!"topology-changed-stategy".equals(nodeName)) continue;
            TopologyChangedStrategy topologyChangedStrategy = JobTrackerConfig.DEFAULT_TOPOLOGY_CHANGED_STRATEGY;
            for (TopologyChangedStrategy temp : TopologyChangedStrategy.values()) {
                if (!temp.name().equals(value)) continue;
                topologyChangedStrategy = temp;
            }
            jConfig.setTopologyChangedStrategy(topologyChangedStrategy);
        }
        this.config.addJobTrackerConfig(jConfig);
    }

    private void handleSemaphore(Node node) {
        Node attName = node.getAttributes().getNamedItem("name");
        String name = this.getTextContent(attName);
        SemaphoreConfig sConfig = new SemaphoreConfig();
        sConfig.setName(name);
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n.getNodeName());
            String value = this.getTextContent(n).trim();
            if ("initial-permits".equals(nodeName)) {
                sConfig.setInitialPermits(this.getIntegerValue("initial-permits", value, 0));
                continue;
            }
            if ("backup-count".equals(nodeName)) {
                sConfig.setBackupCount(this.getIntegerValue("backup-count", value, 1));
                continue;
            }
            if (!"async-backup-count".equals(nodeName)) continue;
            sConfig.setAsyncBackupCount(this.getIntegerValue("async-backup-count", value, 0));
        }
        this.config.addSemaphoreConfig(sConfig);
    }

    private void handleListeners(Node node) throws Exception {
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            if (!"listener".equals(this.cleanNodeName(child))) continue;
            String listenerClass = this.getTextContent(child);
            this.config.addListenerConfig(new ListenerConfig(listenerClass));
        }
    }

    private void handlePartitionGroup(Node node) {
        NamedNodeMap atts = node.getAttributes();
        Node enabledNode = atts.getNamedItem("enabled");
        boolean enabled = enabledNode != null ? this.checkTrue(this.getTextContent(enabledNode)) : false;
        this.config.getPartitionGroupConfig().setEnabled(enabled);
        Node groupTypeNode = atts.getNamedItem("group-type");
        PartitionGroupConfig.MemberGroupType groupType = groupTypeNode != null ? PartitionGroupConfig.MemberGroupType.valueOf(StringUtil.upperCaseInternal(this.getTextContent(groupTypeNode))) : PartitionGroupConfig.MemberGroupType.PER_MEMBER;
        this.config.getPartitionGroupConfig().setGroupType(groupType);
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            if (!"member-group".equals(this.cleanNodeName(child))) continue;
            this.handleMemberGroup(child);
        }
    }

    private void handleMemberGroup(Node node) {
        MemberGroupConfig memberGroupConfig = new MemberGroupConfig();
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            if (!"interface".equals(this.cleanNodeName(child))) continue;
            String value = this.getTextContent(child);
            memberGroupConfig.addInterface(value);
        }
        this.config.getPartitionGroupConfig().addMemberGroupConfig(memberGroupConfig);
    }

    private void handleSerialization(Node node) {
        SerializationConfig serializationConfig = this.parseSerialization(node);
        this.config.setSerializationConfig(serializationConfig);
    }

    private void handleManagementCenterConfig(Node node) {
        NamedNodeMap attrs = node.getAttributes();
        Node enabledNode = attrs.getNamedItem("enabled");
        boolean enabled = enabledNode != null && this.checkTrue(this.getTextContent(enabledNode));
        Node intervalNode = attrs.getNamedItem("update-interval");
        int interval = intervalNode != null ? this.getIntegerValue("update-interval", this.getTextContent(intervalNode), 3) : 3;
        String url = this.getTextContent(node);
        ManagementCenterConfig managementCenterConfig = this.config.getManagementCenterConfig();
        managementCenterConfig.setEnabled(enabled);
        managementCenterConfig.setUpdateInterval(interval);
        managementCenterConfig.setUrl("".equals(url) ? null : url);
    }

    private void handleSecurity(Node node) throws Exception {
        NamedNodeMap atts = node.getAttributes();
        Node enabledNode = atts.getNamedItem("enabled");
        boolean enabled = enabledNode != null && this.checkTrue(this.getTextContent(enabledNode));
        this.config.getSecurityConfig().setEnabled(enabled);
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(child.getNodeName());
            if ("member-credentials-factory".equals(nodeName)) {
                this.handleCredentialsFactory(child);
                continue;
            }
            if ("member-login-modules".equals(nodeName)) {
                this.handleLoginModules(child, true);
                continue;
            }
            if ("client-login-modules".equals(nodeName)) {
                this.handleLoginModules(child, false);
                continue;
            }
            if ("client-permission-policy".equals(nodeName)) {
                this.handlePermissionPolicy(child);
                continue;
            }
            if ("client-permissions".equals(nodeName)) {
                this.handleSecurityPermissions(child);
                continue;
            }
            if (!"security-interceptors".equals(nodeName)) continue;
            this.handleSecurityInterceptors(child);
        }
    }

    private void handleSecurityInterceptors(Node node) throws Exception {
        SecurityConfig cfg = this.config.getSecurityConfig();
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(child.getNodeName());
            if (!"interceptor".equals(nodeName)) continue;
            NamedNodeMap attrs = child.getAttributes();
            Node classNameNode = attrs.getNamedItem("class-name");
            String className = this.getTextContent(classNameNode);
            cfg.addSecurityInterceptorConfig(new SecurityInterceptorConfig(className));
        }
    }

    private void handleMemberAttributes(Node node) {
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes(), 1)) {
            String name = XmlConfigBuilder.cleanNodeName(n.getNodeName());
            if (!"attribute".equals(name)) continue;
            String attributeName = this.getTextContent(n.getAttributes().getNamedItem("name"));
            String attributeType = this.getTextContent(n.getAttributes().getNamedItem("type"));
            String value = this.getTextContent(n);
            if ("string".equals(attributeType)) {
                this.config.getMemberAttributeConfig().setStringAttribute(attributeName, value);
                continue;
            }
            if ("boolean".equals(attributeType)) {
                this.config.getMemberAttributeConfig().setBooleanAttribute(attributeName, Boolean.parseBoolean(value));
                continue;
            }
            if ("byte".equals(attributeType)) {
                this.config.getMemberAttributeConfig().setByteAttribute(attributeName, Byte.parseByte(value));
                continue;
            }
            if ("double".equals(attributeType)) {
                this.config.getMemberAttributeConfig().setDoubleAttribute(attributeName, Double.parseDouble(value));
                continue;
            }
            if ("float".equals(attributeType)) {
                this.config.getMemberAttributeConfig().setFloatAttribute(attributeName, Float.parseFloat(value));
                continue;
            }
            if ("int".equals(attributeType)) {
                this.config.getMemberAttributeConfig().setIntAttribute(attributeName, Integer.parseInt(value));
                continue;
            }
            if ("long".equals(attributeType)) {
                this.config.getMemberAttributeConfig().setLongAttribute(attributeName, Long.parseLong(value));
                continue;
            }
            if ("short".equals(attributeType)) {
                this.config.getMemberAttributeConfig().setShortAttribute(attributeName, Short.parseShort(value));
                continue;
            }
            this.config.getMemberAttributeConfig().setStringAttribute(attributeName, value);
        }
    }

    private void handleCredentialsFactory(Node node) throws Exception {
        NamedNodeMap attrs = node.getAttributes();
        Node classNameNode = attrs.getNamedItem("class-name");
        String className = this.getTextContent(classNameNode);
        SecurityConfig cfg = this.config.getSecurityConfig();
        CredentialsFactoryConfig credentialsFactoryConfig = new CredentialsFactoryConfig(className);
        cfg.setMemberCredentialsConfig(credentialsFactoryConfig);
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(child.getNodeName());
            if (!"properties".equals(nodeName)) continue;
            this.fillProperties(child, credentialsFactoryConfig.getProperties());
            break;
        }
    }

    private void handleLoginModules(Node node, boolean member) throws Exception {
        SecurityConfig cfg = this.config.getSecurityConfig();
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(child.getNodeName());
            if (!"login-module".equals(nodeName)) continue;
            LoginModuleConfig lm = this.handleLoginModule(child);
            if (member) {
                cfg.addMemberLoginModuleConfig(lm);
                continue;
            }
            cfg.addClientLoginModuleConfig(lm);
        }
    }

    private LoginModuleConfig handleLoginModule(Node node) throws Exception {
        NamedNodeMap attrs = node.getAttributes();
        Node classNameNode = attrs.getNamedItem("class-name");
        String className = this.getTextContent(classNameNode);
        Node usageNode = attrs.getNamedItem("usage");
        LoginModuleConfig.LoginModuleUsage usage = usageNode != null ? LoginModuleConfig.LoginModuleUsage.get(this.getTextContent(usageNode)) : LoginModuleConfig.LoginModuleUsage.REQUIRED;
        LoginModuleConfig moduleConfig = new LoginModuleConfig(className, usage);
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(child.getNodeName());
            if (!"properties".equals(nodeName)) continue;
            this.fillProperties(child, moduleConfig.getProperties());
            break;
        }
        return moduleConfig;
    }

    private void handlePermissionPolicy(Node node) throws Exception {
        NamedNodeMap attrs = node.getAttributes();
        Node classNameNode = attrs.getNamedItem("class-name");
        String className = this.getTextContent(classNameNode);
        SecurityConfig cfg = this.config.getSecurityConfig();
        PermissionPolicyConfig policyConfig = new PermissionPolicyConfig(className);
        cfg.setClientPolicyConfig(policyConfig);
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(child.getNodeName());
            if (!"properties".equals(nodeName)) continue;
            this.fillProperties(child, policyConfig.getProperties());
            break;
        }
    }

    private void handleSecurityPermissions(Node node) throws Exception {
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            PermissionConfig.PermissionType type;
            String nodeName = XmlConfigBuilder.cleanNodeName(child.getNodeName());
            if ("map-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.MAP;
            } else if ("queue-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.QUEUE;
            } else if ("multimap-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.MULTIMAP;
            } else if ("topic-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.TOPIC;
            } else if ("list-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.LIST;
            } else if ("set-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.SET;
            } else if ("lock-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.LOCK;
            } else if ("atomic-long-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.ATOMIC_LONG;
            } else if ("countdown-latch-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.COUNTDOWN_LATCH;
            } else if ("semaphore-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.SEMAPHORE;
            } else if ("id-generator-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.ID_GENERATOR;
            } else if ("executor-service-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.EXECUTOR_SERVICE;
            } else if ("transaction-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.TRANSACTION;
            } else {
                if (!"all-permissions".equals(nodeName)) continue;
                type = PermissionConfig.PermissionType.ALL;
            }
            this.handleSecurityPermission(child, type);
        }
    }

    private void handleSecurityPermission(Node node, PermissionConfig.PermissionType type) throws Exception {
        SecurityConfig cfg = this.config.getSecurityConfig();
        NamedNodeMap attrs = node.getAttributes();
        Node nameNode = attrs.getNamedItem("name");
        String name = nameNode != null ? this.getTextContent(nameNode) : "*";
        Node principalNode = attrs.getNamedItem("principal");
        String principal = principalNode != null ? this.getTextContent(principalNode) : "*";
        PermissionConfig permConfig = new PermissionConfig(type, name, principal);
        cfg.addClientPermissionConfig(permConfig);
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(child.getNodeName());
            if ("endpoints".equals(nodeName)) {
                this.handleSecurityPermissionEndpoints(child, permConfig);
                continue;
            }
            if (!"actions".equals(nodeName)) continue;
            this.handleSecurityPermissionActions(child, permConfig);
        }
    }

    private void handleSecurityPermissionEndpoints(Node node, PermissionConfig permConfig) throws Exception {
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(child.getNodeName());
            if (!"endpoint".equals(nodeName)) continue;
            permConfig.addEndpoint(this.getTextContent(child).trim());
        }
    }

    private void handleSecurityPermissionActions(Node node, PermissionConfig permConfig) throws Exception {
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlConfigBuilder.cleanNodeName(child.getNodeName());
            if (!"action".equals(nodeName)) continue;
            permConfig.addAction(this.getTextContent(child).trim());
        }
    }
}

