/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl.operation;

import com.hazelcast.core.Member;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.replicatedmap.impl.ReplicatedMapService;
import com.hazelcast.replicatedmap.impl.messages.ReplicationMessage;
import com.hazelcast.replicatedmap.impl.operation.AbstractReplicatedMapOperation;
import com.hazelcast.replicatedmap.impl.operation.ReplicatedMapDataSerializerHook;
import com.hazelcast.replicatedmap.impl.record.AbstractReplicatedRecordStore;
import com.hazelcast.replicatedmap.impl.record.ReplicatedRecord;
import com.hazelcast.replicatedmap.impl.record.ReplicationPublisher;
import com.hazelcast.replicatedmap.impl.record.VectorClockTimestamp;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;

public class ReplicatedMapInitChunkOperation
extends AbstractReplicatedMapOperation
implements IdentifiedDataSerializable {
    private String name;
    private Member origin;
    private ReplicatedRecord[] replicatedRecords;
    private int recordCount;
    private boolean finalChunk;
    private boolean notYetReadyChooseSomeoneElse;

    ReplicatedMapInitChunkOperation() {
    }

    public ReplicatedMapInitChunkOperation(String name, Member origin) {
        this(name, origin, new ReplicatedRecord[0], 0, true);
        this.notYetReadyChooseSomeoneElse = true;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    public ReplicatedMapInitChunkOperation(String name, Member origin, ReplicatedRecord[] replicatedRecords, int recordCount, boolean finalChunk) {
        this.name = name;
        this.origin = origin;
        this.replicatedRecords = replicatedRecords;
        this.recordCount = recordCount;
        this.finalChunk = finalChunk;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void run() throws Exception {
        ReplicatedMapService replicatedMapService = (ReplicatedMapService)this.getService();
        AbstractReplicatedRecordStore recordStorage = (AbstractReplicatedRecordStore)replicatedMapService.getReplicatedRecordStore(this.name, true);
        ReplicationPublisher replicationPublisher = recordStorage.getReplicationPublisher();
        if (this.notYetReadyChooseSomeoneElse) {
            replicationPublisher.retryWithDifferentReplicationNode(this.origin);
        } else {
            for (int i = 0; i < this.recordCount; ++i) {
                ReplicatedRecord record = this.replicatedRecords[i];
                Object key = record.getKey();
                Object value = record.getValue();
                VectorClockTimestamp timestamp = record.getVectorClockTimestamp();
                int updateHash = record.getLatestUpdateHash();
                long ttlMillis = record.getTtlMillis();
                ReplicationMessage update = new ReplicationMessage(this.name, key, value, timestamp, this.origin, updateHash, ttlMillis);
                replicationPublisher.queueUpdateMessage(update);
            }
            if (this.finalChunk) {
                recordStorage.finalChunkReceived();
            }
        }
    }

    @Override
    public int getFactoryId() {
        return ReplicatedMapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 5;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        this.origin.writeData(out);
        out.writeInt(this.recordCount);
        for (int i = 0; i < this.recordCount; ++i) {
            this.replicatedRecords[i].writeData(out);
        }
        out.writeBoolean(this.finalChunk);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.origin = new MemberImpl();
        this.origin.readData(in);
        this.recordCount = in.readInt();
        this.replicatedRecords = new ReplicatedRecord[this.recordCount];
        for (int i = 0; i < this.recordCount; ++i) {
            ReplicatedRecord replicatedRecord = new ReplicatedRecord();
            replicatedRecord.readData(in);
            this.replicatedRecords[i] = replicatedRecord;
        }
        this.finalChunk = in.readBoolean();
    }
}

