/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableContext;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.query.QueryException;
import com.hazelcast.query.impl.AttributeType;
import com.hazelcast.query.impl.PortableExtractor;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.ReflectionHelper;

public class QueryEntry
implements QueryableEntry {
    private final SerializationService serializationService;
    private final Data indexKey;
    private Data key;
    private Object keyObject;
    private Data value;
    private Object valueObject;

    public QueryEntry(SerializationService serializationService, Data indexKey, Object key, Object value) {
        if (indexKey == null) {
            throw new IllegalArgumentException("index keyData cannot be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("keyData cannot be null");
        }
        this.indexKey = indexKey;
        if (key instanceof Data) {
            this.key = (Data)key;
        } else {
            this.keyObject = key;
        }
        this.serializationService = serializationService;
        if (value instanceof Data) {
            this.value = (Data)value;
        } else {
            this.valueObject = value;
        }
    }

    @Override
    public Object getValue() {
        if (this.valueObject == null && this.serializationService != null) {
            this.valueObject = this.serializationService.toObject(this.value);
        }
        return this.valueObject;
    }

    @Override
    public Object getKey() {
        if (this.keyObject == null && this.serializationService != null) {
            this.keyObject = this.serializationService.toObject(this.key);
        }
        return this.keyObject;
    }

    @Override
    public Comparable getAttribute(String attributeName) throws QueryException {
        Data data;
        if ("__key".equals(attributeName)) {
            return (Comparable)this.getKey();
        }
        if ("this".equals(attributeName)) {
            return (Comparable)this.getValue();
        }
        boolean key = attributeName.startsWith("__key");
        if (key) {
            attributeName = attributeName.substring("__key".length() + 1);
            data = this.getKeyData();
        } else {
            data = this.getValueData();
        }
        if (data != null && data.isPortable()) {
            return this.extractViaPortable(attributeName, data);
        }
        return this.extractViaReflection(attributeName, key);
    }

    private Comparable extractViaPortable(String attributeName, Data data) {
        try {
            return PortableExtractor.extractValue(this.serializationService, data, attributeName);
        }
        catch (QueryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QueryException(e);
        }
    }

    private Comparable extractViaReflection(String attributeName, boolean key) {
        try {
            Object obj = key ? this.getKey() : this.getValue();
            return ReflectionHelper.extractValue(obj, attributeName);
        }
        catch (QueryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QueryException(e);
        }
    }

    @Override
    public AttributeType getAttributeType(String attributeName) {
        Data data;
        if ("__key".equals(attributeName)) {
            return ReflectionHelper.getAttributeType(this.getKey().getClass());
        }
        if ("this".equals(attributeName)) {
            return ReflectionHelper.getAttributeType(this.getValue().getClass());
        }
        boolean key = attributeName.startsWith("__key");
        if (key) {
            attributeName = attributeName.substring("__key".length() + 1);
            data = this.getKeyData();
        } else {
            data = this.getValueData();
        }
        if (data != null && data.isPortable()) {
            PortableContext portableContext = this.serializationService.getPortableContext();
            return PortableExtractor.getAttributeType(portableContext, data, attributeName);
        }
        return ReflectionHelper.getAttributeType(key ? this.getKey() : this.getValue(), attributeName);
    }

    @Override
    public Data getKeyData() {
        if (this.key == null && this.serializationService != null) {
            this.key = this.serializationService.toData(this.keyObject);
        }
        return this.key;
    }

    @Override
    public Data getValueData() {
        if (this.value == null && this.serializationService != null) {
            this.value = this.serializationService.toData(this.valueObject);
        }
        return this.value;
    }

    @Override
    public Data getIndexKey() {
        return this.indexKey;
    }

    public Object setValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryEntry that = (QueryEntry)o;
        return this.indexKey.equals(that.indexKey);
    }

    @Override
    public int hashCode() {
        return this.indexKey.hashCode();
    }
}

