/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.lock;

import com.hazelcast.concurrent.lock.LockStore;
import com.hazelcast.concurrent.lock.LockStoreContainer;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.ObjectNamespace;
import java.util.Set;

public final class LockStoreProxy
implements LockStore {
    private final LockStoreContainer container;
    private final ObjectNamespace namespace;

    public LockStoreProxy(LockStoreContainer container, ObjectNamespace namespace) {
        this.container = container;
        this.namespace = namespace;
    }

    @Override
    public boolean lock(Data key, String caller, long threadId, long ttl) {
        LockStore lockStore = this.getLockStore();
        return lockStore.lock(key, caller, threadId, ttl);
    }

    @Override
    public boolean txnLock(Data key, String caller, long threadId, long ttl) {
        LockStore lockStore = this.getLockStore();
        return lockStore.txnLock(key, caller, threadId, ttl);
    }

    @Override
    public boolean extendLeaseTime(Data key, String caller, long threadId, long ttl) {
        LockStore lockStore = this.getLockStore();
        return lockStore.extendLeaseTime(key, caller, threadId, ttl);
    }

    @Override
    public boolean unlock(Data key, String caller, long threadId) {
        LockStore lockStore = this.getLockStore();
        return lockStore.unlock(key, caller, threadId);
    }

    @Override
    public boolean isLocked(Data key) {
        LockStore lockStore = this.getLockStore();
        return lockStore.isLocked(key);
    }

    @Override
    public boolean isLockedBy(Data key, String caller, long threadId) {
        LockStore lockStore = this.getLockStore();
        return lockStore.isLockedBy(key, caller, threadId);
    }

    @Override
    public int getLockCount(Data key) {
        LockStore lockStore = this.getLockStore();
        return lockStore.getLockCount(key);
    }

    @Override
    public long getRemainingLeaseTime(Data key) {
        LockStore lockStore = this.getLockStore();
        return lockStore.getRemainingLeaseTime(key);
    }

    @Override
    public boolean canAcquireLock(Data key, String caller, long threadId) {
        LockStore lockStore = this.getLockStore();
        return lockStore.canAcquireLock(key, caller, threadId);
    }

    @Override
    public boolean isTransactionallyLocked(Data key) {
        LockStore lockStore = this.getLockStore();
        return lockStore.isTransactionallyLocked(key);
    }

    @Override
    public Set<Data> getLockedKeys() {
        LockStore lockStore = this.getLockStore();
        return lockStore.getLockedKeys();
    }

    @Override
    public boolean forceUnlock(Data key) {
        LockStore lockStore = this.getLockStore();
        return lockStore.forceUnlock(key);
    }

    @Override
    public String getOwnerInfo(Data dataKey) {
        LockStore lockStore = this.getLockStore();
        return lockStore.getOwnerInfo(dataKey);
    }

    private LockStore getLockStore() {
        return this.container.getLockStore(this.namespace);
    }
}

