/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.ext.jaxb;

import com.owlike.genson.Context;
import com.owlike.genson.Converter;
import com.owlike.genson.Factory;
import com.owlike.genson.Genson;
import com.owlike.genson.GensonBuilder;
import com.owlike.genson.JsonBindingException;
import com.owlike.genson.Trilean;
import com.owlike.genson.annotation.HandleBeanView;
import com.owlike.genson.annotation.HandleClassMetadata;
import com.owlike.genson.convert.ChainedFactory;
import com.owlike.genson.convert.ContextualFactory;
import com.owlike.genson.convert.DefaultConverters;
import com.owlike.genson.ext.GensonBundle;
import com.owlike.genson.reflect.BeanCreator;
import com.owlike.genson.reflect.BeanMutatorAccessorResolver;
import com.owlike.genson.reflect.BeanProperty;
import com.owlike.genson.reflect.BeanPropertyFactory;
import com.owlike.genson.reflect.PropertyAccessor;
import com.owlike.genson.reflect.PropertyMutator;
import com.owlike.genson.reflect.PropertyNameResolver;
import com.owlike.genson.reflect.TypeUtil;
import com.owlike.genson.reflect.VisibilityFilter;
import com.owlike.genson.stream.ObjectReader;
import com.owlike.genson.stream.ObjectWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;

public class JAXBBundle
extends GensonBundle {
    private final DatatypeFactory dateFactory;
    private boolean wrapRootValues = false;

    public JAXBBundle() {
        try {
            this.dateFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException dce) {
            throw new IllegalStateException("Could not obtain an instance of DatatypeFactory.", dce);
        }
    }

    public JAXBBundle wrapRootValues(boolean enable) {
        this.wrapRootValues = enable;
        return this;
    }

    @Override
    public void configure(GensonBuilder builder) {
        builder.withConverters(new XMLGregorianCalendarConverter(), new DurationConveter()).with(new BeanMutatorAccessorResolver.GensonAnnotationsResolver(), new JaxbAnnotationsResolver()).with(new PropertyNameResolver.AnnotationPropertyNameResolver(), new JaxbNameResolver()).withConverterFactory(new EnumConverterFactory()).withBeanPropertyFactory(new JaxbBeanPropertyFactory()).withContextualFactory(new XmlTypeAdapterFactory());
        if (this.wrapRootValues) {
            builder.withConverterFactory(new ChainedFactory(){

                @Override
                protected Converter<?> create(Type type, Genson genson, Converter<?> nextConverter) {
                    Class<?> clazz = TypeUtil.getRawClass(type);
                    XmlRootElement ann = clazz.getAnnotation(XmlRootElement.class);
                    if (ann != null) {
                        String name = "##default".equals(ann.name()) ? JAXBBundle.this.firstCharToLower(clazz.getSimpleName()) : ann.name();
                        return new DefaultConverters.WrappedRootValueConverter(name, name, nextConverter);
                    }
                    return null;
                }
            });
        }
    }

    private String firstCharToLower(String str) {
        return Character.toLowerCase(str.charAt(0)) + (str.length() > 0 ? str.substring(1) : "");
    }

    private <A extends Annotation> A find(Class<A> annotation, AccessibleObject onObject, Class<?> onClass) {
        A ann = onObject.getAnnotation(annotation);
        if (ann != null) {
            return ann;
        }
        return this.find(annotation, onClass);
    }

    private <A extends Annotation> A find(Class<A> annotation, Class<?> onClass) {
        A ann = onClass.getAnnotation(annotation);
        if (ann == null && onClass.getPackage() != null) {
            ann = onClass.getPackage().getAnnotation(annotation);
        }
        return ann;
    }

    private <A extends Annotation> A find(Class<A> annotation, Class<?> inClass, String methodName, Class<?> ... parameterTypes) {
        A ann = null;
        block2: for (Class<?> clazz = inClass; clazz != null; clazz = clazz.getSuperclass()) {
            try {
                for (Method m : clazz.getDeclaredMethods()) {
                    if (!m.getName().equals(methodName) || !Arrays.equals(m.getParameterTypes(), parameterTypes)) continue;
                    if (!m.isAnnotationPresent(annotation)) continue block2;
                    return m.getAnnotation(annotation);
                }
                continue;
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
        }
        return ann;
    }

    private class JaxbAnnotationsResolver
    extends BeanMutatorAccessorResolver.PropertyBaseResolver {
        private JaxbAnnotationsResolver() {
        }

        @Override
        public Trilean isAccessor(Field field, Class<?> fromClass) {
            if (this.ignore(field, field.getType(), fromClass)) {
                return Trilean.FALSE;
            }
            if (this.include(field, field.getType(), fromClass)) {
                return Trilean.TRUE;
            }
            return this.analyzeAccessTypeInfo(field, field, XmlAccessType.FIELD, fromClass);
        }

        @Override
        public Trilean isMutator(Field field, Class<?> fromClass) {
            if (this.ignore(field, field.getType(), fromClass)) {
                return Trilean.FALSE;
            }
            if (this.include(field, field.getType(), fromClass)) {
                return Trilean.TRUE;
            }
            return this.analyzeAccessTypeInfo(field, field, XmlAccessType.FIELD, fromClass);
        }

        @Override
        public Trilean isAccessor(Method method, Class<?> fromClass) {
            if (this.ignore(method, method.getReturnType(), fromClass)) {
                return Trilean.FALSE;
            }
            String name = null;
            if (method.getName().startsWith("get") && method.getName().length() > 3) {
                name = method.getName().substring(3);
            } else if (method.getName().startsWith("is") && method.getName().length() > 2 && method.getReturnType() == Boolean.TYPE || method.getReturnType() == Boolean.class) {
                name = method.getName().substring(2);
            }
            if (name != null) {
                if (this.include(method, method.getReturnType(), fromClass)) {
                    return Trilean.TRUE;
                }
                if (JAXBBundle.this.find(XmlTransient.class, fromClass, "set" + name, new Class[]{method.getReturnType()}) != null) {
                    return Trilean.FALSE;
                }
            }
            return this.analyzeAccessTypeInfo(method, method, XmlAccessType.PROPERTY, fromClass);
        }

        @Override
        public Trilean isMutator(Method method, Class<?> fromClass) {
            Class<Object> paramClass;
            Class clazz = paramClass = method.getParameterTypes().length == 1 ? method.getParameterTypes()[0] : Object.class;
            if (this.ignore(method, paramClass, fromClass)) {
                return Trilean.FALSE;
            }
            if (method.getName().startsWith("set") && method.getName().length() > 3) {
                if (this.include(method, method.getReturnType(), fromClass)) {
                    return Trilean.TRUE;
                }
                String name = method.getName().substring(3);
                if (JAXBBundle.this.find(XmlTransient.class, fromClass, "get" + name, new Class[0]) != null) {
                    return Trilean.FALSE;
                }
                if ((paramClass.equals(Boolean.TYPE) || paramClass.equals(Boolean.class)) && JAXBBundle.this.find(XmlTransient.class, fromClass, "is" + name, new Class[0]) != null) {
                    return Trilean.FALSE;
                }
            }
            return this.analyzeAccessTypeInfo(method, method, XmlAccessType.PROPERTY, fromClass);
        }

        public Trilean analyzeAccessTypeInfo(AccessibleObject property, Member member, XmlAccessType accessType, Class<?> fromClass) {
            XmlAccessorType xmlAccessTypeAnn = (XmlAccessorType)JAXBBundle.this.find(XmlAccessorType.class, property, fromClass);
            if (xmlAccessTypeAnn != null) {
                if (xmlAccessTypeAnn.value() == accessType && VisibilityFilter.PRIVATE.isVisible(member)) {
                    return Trilean.TRUE;
                }
                if (xmlAccessTypeAnn.value() != accessType && xmlAccessTypeAnn.value() != XmlAccessType.PUBLIC_MEMBER) {
                    return Trilean.FALSE;
                }
            }
            return Trilean.UNKNOWN;
        }

        private boolean ignore(AccessibleObject property, Class<?> ofType, Class<?> fromClass) {
            XmlTransient xmlTransientAnn = (XmlTransient)JAXBBundle.this.find(XmlTransient.class, property, ofType);
            return xmlTransientAnn != null;
        }

        private boolean include(AccessibleObject property, Class<?> ofType, Class<?> fromClass) {
            return JAXBBundle.this.find(XmlAttribute.class, property, ofType) != null || JAXBBundle.this.find(XmlElement.class, property, ofType) != null;
        }
    }

    private class JaxbNameResolver
    implements PropertyNameResolver {
        private static final String DEFAULT_NAME = "##default";

        private JaxbNameResolver() {
        }

        @Override
        public String resolve(int parameterIdx, Constructor<?> fromConstructor) {
            return null;
        }

        @Override
        public String resolve(int parameterIdx, Method fromMethod) {
            return null;
        }

        @Override
        public String resolve(Field fromField) {
            return this.extractName(fromField);
        }

        @Override
        public String resolve(Method fromMethod) {
            return this.extractName(fromMethod);
        }

        private String extractName(AccessibleObject object) {
            String name = null;
            XmlAttribute attr = object.getAnnotation(XmlAttribute.class);
            if (attr != null) {
                name = attr.name();
            } else {
                XmlElement el = object.getAnnotation(XmlElement.class);
                if (el != null) {
                    name = el.name();
                }
            }
            return DEFAULT_NAME.equals(name) ? null : name;
        }
    }

    private class JaxbBeanPropertyFactory
    implements BeanPropertyFactory {
        private JaxbBeanPropertyFactory() {
        }

        @Override
        public PropertyAccessor createAccessor(String name, Field field, Type ofType, Genson genson) {
            Type newType = this.getType(field, field.getGenericType(), ofType);
            if (newType != null) {
                return new PropertyAccessor.FieldAccessor(name, field, newType, TypeUtil.getRawClass(ofType));
            }
            return null;
        }

        @Override
        public PropertyAccessor createAccessor(String name, Method method, Type ofType, Genson genson) {
            Type newType = this.getType(method, method.getReturnType(), ofType);
            if (newType != null) {
                return new PropertyAccessor.MethodAccessor(name, method, newType, TypeUtil.getRawClass(ofType));
            }
            return null;
        }

        @Override
        public PropertyMutator createMutator(String name, Field field, Type ofType, Genson genson) {
            Type newType = this.getType(field, field.getGenericType(), ofType);
            if (newType != null) {
                return new PropertyMutator.FieldMutator(name, field, newType, TypeUtil.getRawClass(ofType));
            }
            return null;
        }

        @Override
        public PropertyMutator createMutator(String name, Method method, Type ofType, Genson genson) {
            Type newType;
            if (method.getParameterTypes().length == 1 && (newType = this.getType(method, method.getReturnType(), ofType)) != null) {
                return new PropertyMutator.MethodMutator(name, method, newType, TypeUtil.getRawClass(ofType));
            }
            return null;
        }

        @Override
        public BeanCreator createCreator(Type ofType, Constructor<?> ctr, String[] resolvedNames, Genson genson) {
            return null;
        }

        @Override
        public BeanCreator createCreator(Type ofType, Method method, String[] resolvedNames, Genson genson) {
            return null;
        }

        private Type getType(AccessibleObject object, Type objectType, Type contextType) {
            XmlElement el = object.getAnnotation(XmlElement.class);
            if (el != null && el.type() != XmlElement.DEFAULT.class) {
                XmlJavaTypeAdapter ad;
                if (!TypeUtil.getRawClass(objectType).isAssignableFrom(el.type()) && (ad = object.getAnnotation(XmlJavaTypeAdapter.class)) == null) {
                    throw new ClassCastException("Inavlid XmlElement annotation, " + objectType + " is not assignable from " + el.type());
                }
                return el.type();
            }
            return null;
        }
    }

    private class EnumConverterFactory
    implements Factory<Converter<Enum<?>>> {
        private EnumConverterFactory() {
        }

        @Override
        public Converter<Enum<?>> create(Type type, Genson genson) {
            Class<?> rawClass = TypeUtil.getRawClass(type);
            if (rawClass.isEnum() || Enum.class.isAssignableFrom(rawClass)) {
                Class<?> enumClass = rawClass;
                try {
                    HashMap valueToEnum = new HashMap();
                    HashMap enumToValue = new HashMap();
                    for (Enum enumConstant : (Enum[])enumClass.getEnumConstants()) {
                        XmlEnumValue ann = rawClass.getField(enumConstant.name()).getAnnotation(XmlEnumValue.class);
                        if (ann != null) {
                            valueToEnum.put(ann.value(), enumConstant);
                            enumToValue.put(enumConstant, ann.value());
                            continue;
                        }
                        valueToEnum.put(enumConstant.name(), enumConstant);
                        enumToValue.put(enumConstant, enumConstant.name());
                    }
                    return new EnumConverter(valueToEnum, enumToValue);
                }
                catch (SecurityException e) {
                    throw new JsonBindingException("Unable to introspect enum " + enumClass, e);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
            return null;
        }

        @HandleClassMetadata
        @HandleBeanView
        private class EnumConverter
        implements Converter<Enum<?>> {
            private final Map<String, Enum<?>> valueToEnum;
            private final Map<Enum<?>, String> enumToValue;

            public EnumConverter(Map<String, Enum<?>> valueToEnum, Map<Enum<?>, String> enumToValue) {
                this.valueToEnum = valueToEnum;
                this.enumToValue = enumToValue;
            }

            @Override
            public void serialize(Enum<?> object, ObjectWriter writer, Context ctx) {
                writer.writeUnsafeValue(this.enumToValue.get(object));
            }

            @Override
            public Enum<?> deserialize(ObjectReader reader, Context ctx) {
                return this.valueToEnum.get(reader.valueAsString());
            }
        }
    }

    private class XmlTypeAdapterFactory
    implements ContextualFactory<Object> {
        private XmlTypeAdapterFactory() {
        }

        @Override
        public Converter<Object> create(BeanProperty property, Genson genson) {
            XmlJavaTypeAdapter ann = property.getAnnotation(XmlJavaTypeAdapter.class);
            AdaptedConverter converter = null;
            if (ann != null) {
                XmlElement el;
                Class xmlElementType;
                Class adapterClass = ann.value();
                Type adapterExpandedType = TypeUtil.expandType(TypeUtil.lookupGenericType(XmlAdapter.class, adapterClass), adapterClass);
                Type adaptedType = TypeUtil.typeOf(0, adapterExpandedType);
                Type originalType = TypeUtil.typeOf(1, adapterExpandedType);
                Class<?> propertyType = property.getType();
                if (TypeUtil.getRawClass(propertyType).isPrimitive()) {
                    propertyType = TypeUtil.wrap(TypeUtil.getRawClass(propertyType));
                }
                Class clazz = xmlElementType = (el = property.getAnnotation(XmlElement.class)) != null && el.type() != XmlElement.DEFAULT.class ? el.type() : null;
                if (xmlElementType != null ? !TypeUtil.match(adaptedType, xmlElementType, false) : !TypeUtil.match(propertyType, originalType, false)) {
                    throw new ClassCastException("The BoundType of XMLAdapter " + adapterClass + " is not assignable from property " + property.getName() + " declared in " + property.getDeclaringClass());
                }
                try {
                    XmlAdapter adapter = (XmlAdapter)adapterClass.newInstance();
                    Converter<Object> adaptedTypeConverter = genson.provideConverter(xmlElementType != null ? xmlElementType : adaptedType);
                    converter = new AdaptedConverter((XmlAdapter<Object, Object>)adapter, adaptedTypeConverter);
                }
                catch (InstantiationException e) {
                    throw new JsonBindingException("Could not instantiate XmlAdapter of type " + adapterClass, e);
                }
                catch (IllegalAccessException e) {
                    throw new JsonBindingException("Could not instantiate XmlAdapter of type " + adapterClass, e);
                }
            }
            return converter;
        }

        private class AdaptedConverter
        implements Converter<Object> {
            private final XmlAdapter<Object, Object> adapter;
            private final Converter<Object> converter;

            public AdaptedConverter(XmlAdapter<Object, Object> adapter, Converter<Object> converter) {
                this.adapter = adapter;
                this.converter = converter;
            }

            @Override
            public Object deserialize(ObjectReader reader, Context ctx) throws Exception {
                Object value = this.converter.deserialize(reader, ctx);
                try {
                    return this.adapter.unmarshal(value);
                }
                catch (Exception e) {
                    throw new JsonBindingException("Could not unmarshal object using adapter " + this.adapter.getClass());
                }
            }

            @Override
            public void serialize(Object object, ObjectWriter writer, Context ctx) throws Exception {
                Object adaptedValue = null;
                try {
                    adaptedValue = this.adapter.marshal(object);
                }
                catch (Exception e) {
                    throw new JsonBindingException("Could not marshal object using adapter " + this.adapter.getClass());
                }
                this.converter.serialize(adaptedValue, writer, ctx);
            }
        }
    }

    @HandleClassMetadata
    @HandleBeanView
    private class XMLGregorianCalendarConverter
    implements Converter<XMLGregorianCalendar> {
        private final DefaultConverters.DateConverter converter = new DefaultConverters.DateConverter();
        private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-DD'T'hh:mm:ssZ");

        private XMLGregorianCalendarConverter() {
        }

        @Override
        public void serialize(XMLGregorianCalendar object, ObjectWriter writer, Context ctx) {
            this.converter.serialize(object.toGregorianCalendar().getTime(), writer, ctx);
        }

        @Override
        public synchronized XMLGregorianCalendar deserialize(ObjectReader reader, Context ctx) {
            GregorianCalendar cal = new GregorianCalendar();
            try {
                cal.setTime(this.dateFormat.parse(reader.valueAsString()));
            }
            catch (ParseException e) {
                throw new JsonBindingException("Could not parse date " + reader.valueAsString(), e);
            }
            return JAXBBundle.this.dateFactory.newXMLGregorianCalendar(cal);
        }
    }

    private class DurationConveter
    implements Converter<Duration> {
        private DurationConveter() {
        }

        @Override
        public void serialize(Duration object, ObjectWriter writer, Context ctx) {
            writer.writeValue(object.toString());
        }

        @Override
        public Duration deserialize(ObjectReader reader, Context ctx) {
            return JAXBBundle.this.dateFactory.newDuration(reader.valueAsString());
        }
    }
}

