/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.impl;

import java.util.LinkedHashSet;
import java.util.Set;
import net.sf.jml.Email;
import net.sf.jml.MsnContact;
import net.sf.jml.MsnContactList;
import net.sf.jml.MsnGroup;
import net.sf.jml.MsnList;
import net.sf.jml.MsnObject;
import net.sf.jml.impl.MsnGroupImpl;
import net.sf.jml.impl.MsnUserImpl;

public class MsnContactImpl
extends MsnUserImpl
implements MsnContact {
    private final MsnContactList contactList;
    private String id;
    private String friendlyName;
    private int listNumber;
    private final Set<MsnGroup> belongGroups = new LinkedHashSet<MsnGroup>();
    private String personalMessage = "";
    private String currentMedia = "";
    private MsnObject avatar = null;

    public MsnContactImpl(MsnContactList msnContactList) {
        this.contactList = msnContactList;
    }

    public MsnContactList getContactList() {
        return this.contactList;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public void setFriendlyName(String string) {
        this.friendlyName = string;
    }

    public int getListNumber() {
        return this.listNumber;
    }

    public void setListNumber(int n) {
        this.listNumber = n;
    }

    public void setInList(MsnList msnList, boolean bl) {
        this.listNumber = bl ? (this.listNumber |= msnList.getListId()) : (this.listNumber &= ~msnList.getListId());
    }

    public boolean isInList(MsnList msnList) {
        if (msnList == null) {
            return false;
        }
        return (this.listNumber & msnList.getListId()) == msnList.getListId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MsnGroup[] getBelongGroups() {
        Set<MsnGroup> set = this.belongGroups;
        synchronized (set) {
            MsnGroup[] msnGroupArray = new MsnGroup[this.belongGroups.size()];
            this.belongGroups.toArray(msnGroupArray);
            return msnGroupArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean belongGroup(MsnGroup msnGroup) {
        Set<MsnGroup> set = this.belongGroups;
        synchronized (set) {
            return this.belongGroups.contains(msnGroup);
        }
    }

    public void addBelongGroup(String string) {
        MsnGroup msnGroup = this.getContactList().getGroup(string);
        if (msnGroup != null) {
            this.addBelongGroup(msnGroup);
        }
    }

    public void removeBelongGroup(String string) {
        MsnGroup msnGroup = this.getContactList().getGroup(string);
        if (msnGroup != null) {
            this.removeBelongGroup(msnGroup);
        }
    }

    void addBelongGroup(MsnGroup msnGroup) {
        this.belongGroups.add(msnGroup);
        if (!msnGroup.containContact(this)) {
            ((MsnGroupImpl)msnGroup).addContact(this);
        }
    }

    void removeBelongGroup(MsnGroup msnGroup) {
        if (this.belongGroups.remove(msnGroup) && msnGroup.containContact(this)) {
            ((MsnGroupImpl)msnGroup).removeContact(this);
        }
    }

    public String getPersonalMessage() {
        return this.personalMessage;
    }

    public void setPersonalMessage(String string) {
        this.personalMessage = string;
    }

    public String getCurrentMedia() {
        return this.currentMedia;
    }

    public void setCurrentMedia(String string) {
        this.currentMedia = string;
    }

    public MsnObject getAvatar() {
        return this.avatar;
    }

    public void setAvatar(MsnObject msnObject) {
        this.avatar = msnObject;
    }

    public void setEmail(Email email) {
        super.setEmail(email);
        if (email != null) {
            if (this.id == null) {
                this.setId(email.getEmailAddress());
            }
            if (this.friendlyName == null) {
                this.setFriendlyName(email.getEmailAddress());
            }
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MsnContactImpl)) {
            return false;
        }
        MsnContactImpl msnContactImpl = (MsnContactImpl)object;
        if (!(this.id != null ? this.id.equals(msnContactImpl.id) : msnContactImpl.id == null)) {
            return false;
        }
        return this.contactList == null ? msnContactImpl.contactList == null : this.contactList.equals(msnContactImpl.contactList);
    }

    public int hashCode() {
        return this.id == null ? 0 : this.id.hashCode();
    }

    public String toString() {
        return "MsnContact: [ID]" + this.id + " [Email] " + this.getEmail() + " [DisplayName] " + this.getDisplayName() + " [FriendlyName] " + this.friendlyName + " [Status] " + this.getStatus() + " [ListNum] " + this.listNumber;
    }
}

