/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator.packet;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pl.mn.communicator.IStatus;
import pl.mn.communicator.MessageClass;
import pl.mn.communicator.MessageStatus;
import pl.mn.communicator.RemoteStatus;
import pl.mn.communicator.StatusType;
import pl.mn.communicator.User;

public class GGConversion {
    private static final Log LOGGER = LogFactory.getLog((Class)GGConversion.class);

    public static User.UserMode getUserMode(int protocolStatus) {
        if ((protocolStatus & 0x8000) == 32768) {
            return User.UserMode.FRIEND;
        }
        if ((protocolStatus & 6) == 6) {
            return User.UserMode.BLOCKED;
        }
        LOGGER.warn((Object)"Unable to convert from protocolUserMode, falling back to unknown.");
        return User.UserMode.UNKNOWN;
    }

    public static byte getProtocolUserMode(User.UserMode userMode) {
        if (userMode == User.UserMode.BUDDY) {
            return 1;
        }
        if (userMode == User.UserMode.BLOCKED) {
            return 4;
        }
        if (userMode == User.UserMode.FRIEND) {
            return 2;
        }
        LOGGER.warn((Object)"Unable to convert userMode to protocolUserMode, falling back to unknown.");
        return -1;
    }

    public static RemoteStatus getClientRemoteStatus(int status, String description, long returnTimeInMillis) {
        RemoteStatus remoteStatus = null;
        switch (status) {
            case 2: {
                remoteStatus = new RemoteStatus(StatusType.ONLINE);
                break;
            }
            case 4: {
                remoteStatus = new RemoteStatus(StatusType.ONLINE_WITH_DESCRIPTION);
                remoteStatus.setDescription(description);
                break;
            }
            case 3: {
                remoteStatus = new RemoteStatus(StatusType.BUSY);
                break;
            }
            case 5: {
                remoteStatus = new RemoteStatus(StatusType.BUSY_WITH_DESCRIPTION);
                remoteStatus.setDescription(description);
                break;
            }
            case 20: {
                remoteStatus = new RemoteStatus(StatusType.INVISIBLE);
                break;
            }
            case 22: {
                remoteStatus = new RemoteStatus(StatusType.INVISIBLE_WITH_DESCRIPTION);
                remoteStatus.setDescription(description);
                break;
            }
            case 1: {
                remoteStatus = new RemoteStatus(StatusType.OFFLINE);
                break;
            }
            case 21: {
                remoteStatus = new RemoteStatus(StatusType.OFFLINE);
                remoteStatus.setDescription(description);
                break;
            }
            case 6: {
                remoteStatus = new RemoteStatus(StatusType.INVISIBLE);
                remoteStatus.setBlocked(true);
            }
        }
        if (remoteStatus != null && returnTimeInMillis != -1L) {
            remoteStatus.setReturnDate(new Date(returnTimeInMillis));
        }
        return remoteStatus;
    }

    public static int getProtocolStatus(IStatus clientStatus, boolean isFriendsOnly, boolean isBlocked) {
        if (clientStatus == null) {
            throw new NullPointerException("clientStatus cannot be null.");
        }
        int protocolStatus = -1;
        if (clientStatus.getStatusType() == StatusType.ONLINE) {
            protocolStatus = 2;
        } else if (clientStatus.getStatusType() == StatusType.ONLINE_WITH_DESCRIPTION) {
            protocolStatus = 4;
        } else if (clientStatus.getStatusType() == StatusType.BUSY) {
            protocolStatus = 3;
        } else if (clientStatus.getStatusType() == StatusType.BUSY_WITH_DESCRIPTION) {
            protocolStatus = 5;
        } else if (clientStatus.getStatusType() == StatusType.OFFLINE) {
            protocolStatus = 1;
        } else if (clientStatus.getStatusType() == StatusType.OFFLINE_WITH_DESCRIPTION) {
            protocolStatus = 21;
        } else if (clientStatus.getStatusType() == StatusType.INVISIBLE) {
            protocolStatus = 20;
        } else if (clientStatus.getStatusType() == StatusType.INVISIBLE_WITH_DESCRIPTION) {
            protocolStatus = 22;
        }
        if (protocolStatus != -1) {
            if (isFriendsOnly) {
                protocolStatus |= 0x8000;
            }
            if (isBlocked) {
                protocolStatus |= 6;
            }
            return protocolStatus;
        }
        LOGGER.warn((Object)"Unable to convert status, falling back to unknown.");
        return -1;
    }

    public static MessageStatus getClientMessageStatus(int protocolMessageStatus) {
        switch (protocolMessageStatus) {
            case 2: {
                return MessageStatus.DELIVERED;
            }
            case 6: {
                return MessageStatus.NOT_DELIVERED;
            }
            case 1: {
                return MessageStatus.BLOCKED;
            }
            case 4: {
                return MessageStatus.BLOCKED_MBOX_FULL;
            }
            case 3: {
                return MessageStatus.QUEUED;
            }
        }
        LOGGER.warn((Object)"Unable to convert message status, falling back to unknown.");
        return MessageStatus.UNKNOWN;
    }

    public static MessageClass getClientMessageClass(int protocolMessageClass) {
        switch (protocolMessageClass) {
            case 32: {
                return MessageClass.DO_NOT_CONFIRM;
            }
            case 8: {
                return MessageClass.CHAT;
            }
            case 16: {
                return MessageClass.PING;
            }
            case 4: {
                return MessageClass.MESSAGE;
            }
            case 1: {
                return MessageClass.QUEUED;
            }
            case 9: {
                return MessageClass.QUEUED;
            }
        }
        LOGGER.warn((Object)"Unable to convert message class, falling back to unknown.");
        return MessageClass.UNKNOWN;
    }

    public static int getProtocolMessageClass(MessageClass clientMessageClass) {
        if (clientMessageClass == MessageClass.CHAT) {
            return 8;
        }
        if (clientMessageClass == MessageClass.DO_NOT_CONFIRM) {
            return 32;
        }
        if (clientMessageClass == MessageClass.MESSAGE) {
            return 4;
        }
        if (clientMessageClass == MessageClass.QUEUED) {
            return 1;
        }
        if (clientMessageClass == MessageClass.PING) {
            return 16;
        }
        LOGGER.warn((Object)"Unable to convert protocol message class, falling back to unknown.");
        return -1;
    }
}

