/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.transaction.impl.xa;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.SerializableCollection;
import com.hazelcast.transaction.impl.xa.SerializableXID;
import com.hazelcast.transaction.impl.xa.XAService;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class CollectRemoteTransactionsOperation
extends Operation {
    private transient SerializableCollection xidSet;

    @Override
    public void beforeRun() throws Exception {
    }

    @Override
    public void run() throws Exception {
        XAService xaService = (XAService)this.getService();
        NodeEngine nodeEngine = this.getNodeEngine();
        Set<SerializableXID> xids = xaService.getPreparedXids();
        HashSet<Data> xidSet = new HashSet<Data>();
        for (SerializableXID xid : xids) {
            xidSet.add(nodeEngine.toData(xid));
        }
        this.xidSet = new SerializableCollection(xidSet);
    }

    @Override
    public void afterRun() throws Exception {
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    public Object getResponse() {
        return this.xidSet;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:xaService";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
    }
}

