/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.impl.queue;

import com.hazelcast.collection.impl.queue.QueueService;
import com.hazelcast.collection.impl.queue.operations.CheckAndEvictOperation;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.OperationService;
import com.hazelcast.util.scheduler.EntryTaskScheduler;
import com.hazelcast.util.scheduler.ScheduledEntry;
import com.hazelcast.util.scheduler.ScheduledEntryProcessor;
import java.util.Collection;

public class QueueEvictionProcessor
implements ScheduledEntryProcessor<String, Void> {
    private final NodeEngine nodeEngine;
    private final QueueService service;

    public QueueEvictionProcessor(NodeEngine nodeEngine, QueueService service) {
        this.nodeEngine = nodeEngine;
        this.service = service;
    }

    @Override
    public void process(EntryTaskScheduler<String, Void> scheduler, Collection<ScheduledEntry<String, Void>> entries) {
        if (entries.isEmpty()) {
            return;
        }
        InternalPartitionService partitionService = this.nodeEngine.getPartitionService();
        OperationService operationService = this.nodeEngine.getOperationService();
        for (ScheduledEntry<String, Void> entry : entries) {
            String name = entry.getKey();
            int partitionId = partitionService.getPartitionId(this.nodeEngine.toData(name));
            CheckAndEvictOperation op = new CheckAndEvictOperation(entry.getKey());
            operationService.invokeOnPartition("hz:impl:queueService", op, partitionId).getSafely();
        }
    }
}

