/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.Writable;
import net.kano.joscar.snaccmd.ExtraInfoBlock;
import net.kano.joscar.snaccmd.ExtraInfoData;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class CertificateInfo
implements LiveWritable {
    public static final int CODE_DEFAULT = 1;
    private static final ByteBlock HASH_DEFAULT;
    public static final ByteBlock HASHA_DEFAULT;
    public static final ByteBlock HASHB_DEFAULT;
    private static final int TYPE_NUMCERTS = 4;
    private static final int TYPE_COMMONCERTDATA = 1;
    private static final int TYPE_ENCCERTDATA = 1;
    private static final int TYPE_SIGNCERTDATA = 2;
    private static final int TYPE_HASH_A = 5;
    private static final int TYPE_HASH_B = 6;
    private final boolean common;
    private final ByteBlock commonCertData;
    private final ByteBlock encCertData;
    private final ByteBlock signCertData;
    private final ByteBlock hashA;
    private final ByteBlock hashB;

    public static byte[] getCertInfoHash(CertificateInfo certificateInfo) {
        MessageDigest messageDigest;
        DefensiveTools.checkNull(certificateInfo, "certInfo");
        ByteBlock byteBlock = ByteBlock.createByteBlock(certificateInfo);
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
        byte[] byArray = messageDigest.digest(byteBlock.toByteArray());
        return byArray;
    }

    public static CertificateInfo readCertInfoBlock(ByteBlock byteBlock) {
        ByteBlock byteBlock2;
        Writable writable;
        ByteBlock byteBlock3;
        Writable writable2;
        DefensiveTools.checkNull(byteBlock, "block");
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(byteBlock);
        ByteBlock byteBlock4 = null;
        Tlv tlv = immutableTlvChain.getLastTlv(5);
        if (tlv != null && (writable2 = ExtraInfoBlock.readExtraInfoBlock(byteBlock3 = tlv.getData())) != null) {
            byteBlock4 = ((ExtraInfoBlock)writable2).getExtraData().getData();
        }
        byteBlock3 = null;
        writable2 = immutableTlvChain.getLastTlv(6);
        if (writable2 != null && (writable = ExtraInfoBlock.readExtraInfoBlock(byteBlock2 = ((Tlv)writable2).getData())) != null) {
            byteBlock3 = ((ExtraInfoBlock)writable).getExtraData().getData();
        }
        byteBlock2 = null;
        writable = immutableTlvChain.getLastTlv(1);
        if (writable != null) {
            byteBlock2 = ((Tlv)writable).getData();
        }
        ByteBlock byteBlock5 = null;
        Tlv tlv2 = immutableTlvChain.getLastTlv(2);
        if (tlv2 != null) {
            byteBlock5 = tlv2.getData();
        }
        if (byteBlock5 == null) {
            return new CertificateInfo(byteBlock2, byteBlock4, byteBlock3);
        }
        return new CertificateInfo(byteBlock2, byteBlock5, byteBlock4, byteBlock3);
    }

    public CertificateInfo(ByteBlock byteBlock) {
        this(byteBlock, HASHA_DEFAULT, HASHB_DEFAULT);
    }

    public CertificateInfo(ByteBlock byteBlock, ByteBlock byteBlock2, ByteBlock byteBlock3) {
        this.common = true;
        this.commonCertData = byteBlock;
        this.encCertData = null;
        this.signCertData = null;
        this.hashA = byteBlock2;
        this.hashB = byteBlock3;
    }

    public CertificateInfo(ByteBlock byteBlock, ByteBlock byteBlock2) {
        this(byteBlock, byteBlock2, HASHA_DEFAULT, HASHB_DEFAULT);
    }

    public CertificateInfo(ByteBlock byteBlock, ByteBlock byteBlock2, ByteBlock byteBlock3, ByteBlock byteBlock4) {
        DefensiveTools.checkNull(byteBlock, "encCertData");
        DefensiveTools.checkNull(byteBlock2, "signCertData");
        this.common = false;
        this.commonCertData = null;
        this.encCertData = byteBlock;
        this.signCertData = byteBlock2;
        this.hashA = byteBlock3;
        this.hashB = byteBlock4;
    }

    public final boolean isCommon() {
        return this.common;
    }

    public final ByteBlock getCommonCertData() {
        return this.commonCertData;
    }

    public final ByteBlock getEncCertData() {
        return this.encCertData;
    }

    public final ByteBlock getSignCertData() {
        return this.signCertData;
    }

    public final ByteBlock getHashA() {
        return this.hashA;
    }

    public final ByteBlock getHashB() {
        return this.hashB;
    }

    private static void writeHash(OutputStream outputStream, int n, int n2, ByteBlock byteBlock) throws IOException {
        ExtraInfoData extraInfoData = new ExtraInfoData(1, byteBlock);
        ExtraInfoBlock extraInfoBlock = new ExtraInfoBlock(n2, extraInfoData);
        new Tlv(n, ByteBlock.createByteBlock(extraInfoBlock)).write(outputStream);
    }

    public void write(OutputStream outputStream) throws IOException {
        int n = this.common ? 1 : 2;
        Tlv.getUShortInstance(4, n).write(outputStream);
        if (n == 1) {
            if (this.commonCertData != null) {
                new Tlv(1, this.commonCertData).write(outputStream);
            }
        } else {
            new Tlv(1, this.encCertData).write(outputStream);
            new Tlv(2, this.signCertData).write(outputStream);
        }
        if (this.hashA != null) {
            CertificateInfo.writeHash(outputStream, 5, 1026, this.hashA);
        }
        if (this.hashB != null) {
            CertificateInfo.writeHash(outputStream, 6, 1027, this.hashB);
        }
    }

    public String toString() {
        return "CertificateInfo: " + (this.common ? "common cert" + (this.commonCertData == null ? " (null)" : "") : "enc cert, signing cert");
    }

    static {
        HASHB_DEFAULT = HASHA_DEFAULT = (HASH_DEFAULT = ByteBlock.wrap(new byte[]{-44, 29, -116, -39, -113, 0, -78, 4, -23, -128, 9, -104, -20, -8, 66, 126}));
    }
}

