/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvproto.ft;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.ImEncodedString;
import net.kano.joscar.ImEncodingParams;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.rvcmd.SegmentedFilename;

public final class FileTransferHeader
implements LiveWritable {
    public static final String FTVERSION_DEFAULT = "OFT2";
    public static final int HEADERTYPE_SENDHEADER = 257;
    public static final int HEADERTYPE_ACK = 514;
    public static final int HEADERTYPE_RECEIVED = 516;
    public static final int HEADERTYPE_RESUME = 517;
    public static final int HEADERTYPE_RESUME_SENDHEADER = 262;
    public static final int HEADERTYPE_RESUME_ACK = 519;
    public static final int HEADERTYPE_FILELIST_SENDLIST = 4360;
    public static final int HEADERTYPE_FILELIST_ACK = 4617;
    public static final int HEADERTYPE_FILELIST_RECEIVED = 4619;
    public static final int HEADERTYPE_FILELIST_REQFILE = 4620;
    public static final int HEADERTYPE_FILELIST_REQDIR = 4622;
    public static final int ENCRYPTION_NONE = 0;
    public static final int COMPRESSION_NONE = 0;
    public static final String CLIENTID_OLD = "OFT_Windows ICBMFT V1.1 32";
    public static final String CLIENTID_DEFAULT = "Cool FileXfer";
    public static final int LISTNAMEOFFSET_DEFAULT = 28;
    public static final int LISTSIZEOFFSET_DEFAULT = 17;
    public static final int FLAG_DEFAULT = 32;
    public static final int FLAG_DONE = 1;
    public static final int FLAG_FILELIST = 16;
    public static final ByteBlock DUMMY_DEFAULT = ByteBlock.wrap(new byte[69]);
    public static final ByteBlock MACFILEINFO_DEFAULT = ByteBlock.wrap(new byte[16]);
    private String ftVersion = null;
    private int headerType = -1;
    private long icbmMessageId = 0L;
    private int encryption = -1;
    private int compression = -1;
    private int fileCount = -1;
    private int filesLeft = -1;
    private int partCount = -1;
    private int partsLeft = -1;
    private long totalFileSize = -1L;
    private long fileSize = -1L;
    private long lastmod = -1L;
    private long checksum = -1L;
    private long resForkReceivedChecksum = -1L;
    private long resForkSize = -1L;
    private long created = -1L;
    private long resForkChecksum = -1L;
    private long bytesReceived = -1L;
    private long receivedChecksum = -1L;
    private String clientid = null;
    private int flags = -1;
    private int listNameOffset = -1;
    private int listSizeOffset = -1;
    private ByteBlock dummyBlock = null;
    private ByteBlock macFileInfo = null;
    private SegmentedFilename filename = null;
    private int headerSize = -1;

    public static FileTransferHeader readHeader(InputStream inputStream) throws IOException {
        int n;
        int n2;
        DefensiveTools.checkNull(inputStream, "in");
        byte[] byArray = new byte[6];
        for (int i = 0; i < byArray.length; i += n2) {
            n2 = inputStream.read(byArray, i, byArray.length - i);
            if (n2 != -1) continue;
            return null;
        }
        ByteBlock byteBlock = ByteBlock.wrap(byArray, 0, 4);
        String string = BinaryTools.getAsciiString(byteBlock);
        int n3 = BinaryTools.getUShort(ByteBlock.wrap(byArray), 4);
        if (n3 < 6) {
            return null;
        }
        byte[] byArray2 = new byte[n3 - 6];
        for (int i = 0; i < byArray2.length; i += n) {
            n = inputStream.read(byArray2, i, byArray2.length - i);
            if (n != -1) continue;
            return null;
        }
        FileTransferHeader fileTransferHeader = new FileTransferHeader();
        fileTransferHeader.setFtVersion(string);
        fileTransferHeader.setHeaderSize(n3);
        ByteBlock byteBlock2 = ByteBlock.wrap(byArray2);
        fileTransferHeader.setHeaderType(BinaryTools.getUShort(byteBlock2, 0));
        fileTransferHeader.setIcbmMessageId(BinaryTools.getLong(byteBlock2, 2));
        fileTransferHeader.setEncryption(BinaryTools.getUShort(byteBlock2, 10));
        fileTransferHeader.setCompression(BinaryTools.getUShort(byteBlock2, 12));
        fileTransferHeader.setFileCount(BinaryTools.getUShort(byteBlock2, 14));
        fileTransferHeader.setFilesLeft(BinaryTools.getUShort(byteBlock2, 16));
        fileTransferHeader.setPartCount(BinaryTools.getUShort(byteBlock2, 18));
        fileTransferHeader.setPartsLeft(BinaryTools.getUShort(byteBlock2, 20));
        fileTransferHeader.setTotalFileSize(BinaryTools.getUInt(byteBlock2, 22));
        fileTransferHeader.setFileSize(BinaryTools.getUInt(byteBlock2, 26));
        fileTransferHeader.setLastmod(BinaryTools.getUInt(byteBlock2, 30));
        fileTransferHeader.setChecksum(BinaryTools.getUInt(byteBlock2, 34));
        fileTransferHeader.setResForkReceivedChecksum(BinaryTools.getUInt(byteBlock2, 38));
        fileTransferHeader.setResForkSize(BinaryTools.getUInt(byteBlock2, 42));
        fileTransferHeader.setCreated(BinaryTools.getUInt(byteBlock2, 46));
        fileTransferHeader.setResForkChecksum(BinaryTools.getUInt(byteBlock2, 50));
        fileTransferHeader.setBytesReceived(BinaryTools.getUInt(byteBlock2, 54));
        fileTransferHeader.setReceivedChecksum(BinaryTools.getUInt(byteBlock2, 58));
        ByteBlock byteBlock3 = byteBlock2.subBlock(62, 32);
        fileTransferHeader.setClientid(BinaryTools.getNullPadded(byteBlock3).getString());
        ByteBlock byteBlock4 = byteBlock2.subBlock(94);
        fileTransferHeader.setFlags(BinaryTools.getUByte(byteBlock4, 0));
        fileTransferHeader.setListNameOffset(BinaryTools.getUByte(byteBlock4, 1));
        fileTransferHeader.setListSizeOffset(BinaryTools.getUByte(byteBlock4, 2));
        fileTransferHeader.setDummyBlock(byteBlock4.subBlock(3, 69));
        fileTransferHeader.setMacFileInfo(byteBlock4.subBlock(72, 16));
        int n4 = BinaryTools.getUShort(byteBlock4, 88);
        int n5 = BinaryTools.getUShort(byteBlock4, 90);
        ByteBlock byteBlock5 = byteBlock4.subBlock(92);
        ImEncodingParams imEncodingParams = new ImEncodingParams(n4, n5);
        String string2 = ImEncodedString.readImEncodedString(imEncodingParams, byteBlock5);
        int n6 = string2.indexOf(0);
        int n7 = string2.lastIndexOf(0);
        if (n6 != n7) {
            for (int i = n7 - 1; i >= 0; --i) {
                if (string2.charAt(i) == '\u0000') continue;
                n6 = i + 1;
                break;
            }
        }
        if (n6 != -1) {
            string2 = string2.substring(0, n6);
        }
        SegmentedFilename segmentedFilename = SegmentedFilename.fromFTFilename(string2);
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            System.out.println("char " + c + " = " + c);
        }
        fileTransferHeader.setFilename(segmentedFilename);
        return fileTransferHeader;
    }

    public FileTransferHeader() {
    }

    public FileTransferHeader(FileTransferHeader fileTransferHeader) {
        DefensiveTools.checkNull(fileTransferHeader, "other");
        this.ftVersion = fileTransferHeader.ftVersion;
        this.headerType = fileTransferHeader.headerType;
        this.icbmMessageId = fileTransferHeader.icbmMessageId;
        this.encryption = fileTransferHeader.encryption;
        this.compression = fileTransferHeader.compression;
        this.fileCount = fileTransferHeader.fileCount;
        this.filesLeft = fileTransferHeader.filesLeft;
        this.partCount = fileTransferHeader.partCount;
        this.partsLeft = fileTransferHeader.partsLeft;
        this.totalFileSize = fileTransferHeader.totalFileSize;
        this.fileSize = fileTransferHeader.fileSize;
        this.lastmod = fileTransferHeader.lastmod;
        this.checksum = fileTransferHeader.checksum;
        this.resForkReceivedChecksum = fileTransferHeader.resForkReceivedChecksum;
        this.resForkSize = fileTransferHeader.resForkSize;
        this.created = fileTransferHeader.created;
        this.resForkChecksum = fileTransferHeader.resForkChecksum;
        this.bytesReceived = fileTransferHeader.bytesReceived;
        this.receivedChecksum = fileTransferHeader.receivedChecksum;
        this.clientid = fileTransferHeader.clientid;
        this.flags = fileTransferHeader.flags;
        this.listNameOffset = fileTransferHeader.listNameOffset;
        this.listSizeOffset = fileTransferHeader.listSizeOffset;
        this.dummyBlock = fileTransferHeader.dummyBlock;
        this.macFileInfo = fileTransferHeader.macFileInfo;
        this.filename = fileTransferHeader.filename;
    }

    public synchronized String getFtVersion() {
        return this.ftVersion;
    }

    public synchronized int getHeaderType() {
        return this.headerType;
    }

    public synchronized long getIcbmMessageId() {
        return this.icbmMessageId;
    }

    public synchronized int getEncryption() {
        return this.encryption;
    }

    public synchronized int getCompression() {
        return this.compression;
    }

    public synchronized int getFileCount() {
        return this.fileCount;
    }

    public synchronized int getFilesLeft() {
        return this.filesLeft;
    }

    public synchronized int getPartCount() {
        return this.partCount;
    }

    public synchronized int getPartsLeft() {
        return this.partsLeft;
    }

    public synchronized long getTotalFileSize() {
        return this.totalFileSize;
    }

    public synchronized long getFileSize() {
        return this.fileSize;
    }

    public synchronized long getLastmod() {
        return this.lastmod;
    }

    public synchronized long getChecksum() {
        return this.checksum;
    }

    public synchronized long getResForkReceivedChecksum() {
        return this.resForkReceivedChecksum;
    }

    public synchronized long getResForkSize() {
        return this.resForkSize;
    }

    public synchronized long getCreated() {
        return this.created;
    }

    public synchronized long getResForkChecksum() {
        return this.resForkChecksum;
    }

    public synchronized long getBytesReceived() {
        return this.bytesReceived;
    }

    public synchronized long getReceivedChecksum() {
        return this.receivedChecksum;
    }

    public synchronized String getClientid() {
        return this.clientid;
    }

    public synchronized int getFlags() {
        return this.flags;
    }

    public synchronized int getListNameOffset() {
        return this.listNameOffset;
    }

    public synchronized int getListSizeOffset() {
        return this.listSizeOffset;
    }

    public synchronized ByteBlock getDummyBlock() {
        return this.dummyBlock;
    }

    public synchronized ByteBlock getMacFileInfo() {
        return this.macFileInfo;
    }

    public synchronized SegmentedFilename getFilename() {
        return this.filename;
    }

    public synchronized int getHeaderSize() {
        return this.headerSize;
    }

    public synchronized void setFtVersion(String string) {
        this.ftVersion = string;
    }

    public synchronized void setHeaderType(int n) {
        this.headerType = n;
    }

    public synchronized void setIcbmMessageId(long l) {
        this.icbmMessageId = l;
    }

    public synchronized void setEncryption(int n) {
        this.encryption = n;
    }

    public synchronized void setCompression(int n) {
        this.compression = n;
    }

    public synchronized void setFileCount(int n) {
        this.fileCount = n;
    }

    public synchronized void setFilesLeft(int n) {
        this.filesLeft = n;
    }

    public synchronized void setPartCount(int n) {
        this.partCount = n;
    }

    public synchronized void setPartsLeft(int n) {
        this.partsLeft = n;
    }

    public synchronized void setTotalFileSize(long l) {
        this.totalFileSize = l;
    }

    public synchronized void setFileSize(long l) {
        this.fileSize = l;
    }

    public synchronized void setLastmod(long l) {
        this.lastmod = l;
    }

    public synchronized void setChecksum(long l) {
        this.checksum = l;
    }

    public synchronized void setResForkReceivedChecksum(long l) {
        this.resForkReceivedChecksum = l;
    }

    public synchronized void setResForkSize(long l) {
        this.resForkSize = l;
    }

    public synchronized void setCreated(long l) {
        this.created = l;
    }

    public synchronized void setResForkChecksum(long l) {
        this.resForkChecksum = l;
    }

    public synchronized void setBytesReceived(long l) {
        this.bytesReceived = l;
    }

    public synchronized void setReceivedChecksum(long l) {
        this.receivedChecksum = l;
    }

    public synchronized void setClientid(String string) {
        this.clientid = string;
    }

    public synchronized void setFlags(int n) {
        this.flags = n;
    }

    public synchronized void setListNameOffset(int n) {
        this.listNameOffset = n;
    }

    public synchronized void setListSizeOffset(int n) {
        this.listSizeOffset = n;
    }

    public synchronized void setDummyBlock(ByteBlock byteBlock) {
        this.dummyBlock = byteBlock;
    }

    public synchronized void setMacFileInfo(ByteBlock byteBlock) {
        this.macFileInfo = byteBlock;
    }

    public synchronized void setFilename(SegmentedFilename segmentedFilename) {
        this.filename = segmentedFilename;
    }

    private synchronized void setHeaderSize(int n) {
        this.headerSize = n;
    }

    public final synchronized void setDefaults() {
        this.clientid = CLIENTID_DEFAULT;
        this.compression = 0;
        this.encryption = 0;
        this.icbmMessageId = 0L;
        this.dummyBlock = DUMMY_DEFAULT;
        this.flags = 32;
        this.ftVersion = FTVERSION_DEFAULT;
        this.resForkChecksum = 0L;
        this.resForkReceivedChecksum = 0L;
        this.resForkSize = 0L;
        this.created = 0L;
        this.lastmod = 0L;
        this.checksum = 0L;
        this.listNameOffset = 0;
        this.listSizeOffset = 0;
        this.macFileInfo = MACFILEINFO_DEFAULT;
        this.bytesReceived = 0L;
        this.fileCount = 0;
        this.fileSize = 0L;
        this.filesLeft = 0;
        this.partCount = 0;
        this.partsLeft = 0;
        this.receivedChecksum = 0L;
        this.totalFileSize = 0L;
    }

    private synchronized void checkValidity() throws IllegalArgumentException {
        DefensiveTools.checkNull(this.ftVersion, "ftVersion");
        DefensiveTools.checkRange(this.headerType, "headerType", 0);
        DefensiveTools.checkRange(this.encryption, "encryption", 0);
        DefensiveTools.checkRange(this.compression, "compression", 0);
        DefensiveTools.checkRange(this.fileCount, "fileCount", 0);
        DefensiveTools.checkRange(this.filesLeft, "filesLeft", 0);
        DefensiveTools.checkRange(this.partCount, "partCount", 0);
        DefensiveTools.checkRange(this.partsLeft, "partsLeft", 0);
        DefensiveTools.checkRange(this.totalFileSize, "totalFileSize", 0);
        DefensiveTools.checkRange(this.fileSize, "fileSize", 0);
        DefensiveTools.checkRange(this.lastmod, "lastmod", 0);
        DefensiveTools.checkRange(this.checksum, "checksum", 0);
        DefensiveTools.checkRange(this.resForkReceivedChecksum, "resForkReceivedChecksum", 0);
        DefensiveTools.checkRange(this.resForkSize, "resForkSize", 0);
        DefensiveTools.checkRange(this.created, "created", 0);
        DefensiveTools.checkRange(this.resForkChecksum, "resForkChecksum", 0);
        DefensiveTools.checkRange(this.bytesReceived, "bytesReceived", 0);
        DefensiveTools.checkRange(this.receivedChecksum, "receivedChecksum", 0);
        DefensiveTools.checkNull(this.clientid, "clientid");
        DefensiveTools.checkRange(this.flags, "flags", 0);
        DefensiveTools.checkRange(this.listNameOffset, "listNameOffset", 0);
        DefensiveTools.checkRange(this.listSizeOffset, "listSizeOffset", 0);
        DefensiveTools.checkNull(this.dummyBlock, "dummyBlock");
        DefensiveTools.checkNull(this.macFileInfo, "macFileInfo");
    }

    public synchronized void write(OutputStream outputStream) throws IOException, IllegalArgumentException {
        DefensiveTools.checkNull(outputStream, "out");
        this.checkValidity();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(300);
        BinaryTools.writeUShort(byteArrayOutputStream, this.headerType);
        BinaryTools.writeLong(byteArrayOutputStream, this.icbmMessageId);
        BinaryTools.writeUShort(byteArrayOutputStream, this.encryption);
        BinaryTools.writeUShort(byteArrayOutputStream, this.compression);
        BinaryTools.writeUShort(byteArrayOutputStream, this.fileCount);
        BinaryTools.writeUShort(byteArrayOutputStream, this.filesLeft);
        BinaryTools.writeUShort(byteArrayOutputStream, this.partCount);
        BinaryTools.writeUShort(byteArrayOutputStream, this.partsLeft);
        BinaryTools.writeUInt(byteArrayOutputStream, this.totalFileSize);
        BinaryTools.writeUInt(byteArrayOutputStream, this.fileSize);
        BinaryTools.writeUInt(byteArrayOutputStream, this.lastmod);
        BinaryTools.writeUInt(byteArrayOutputStream, this.checksum);
        BinaryTools.writeUInt(byteArrayOutputStream, this.resForkReceivedChecksum);
        BinaryTools.writeUInt(byteArrayOutputStream, this.resForkSize);
        BinaryTools.writeUInt(byteArrayOutputStream, this.created);
        BinaryTools.writeUInt(byteArrayOutputStream, this.resForkChecksum);
        BinaryTools.writeUInt(byteArrayOutputStream, this.bytesReceived);
        BinaryTools.writeUInt(byteArrayOutputStream, this.receivedChecksum);
        ByteBlock byteBlock = ByteBlock.wrap(BinaryTools.getAsciiBytes(this.clientid));
        BinaryTools.writeNullPadded(byteArrayOutputStream, byteBlock, 32);
        BinaryTools.writeUByte(byteArrayOutputStream, this.flags);
        BinaryTools.writeUByte(byteArrayOutputStream, this.listNameOffset);
        BinaryTools.writeUByte(byteArrayOutputStream, this.listSizeOffset);
        BinaryTools.writeNullPadded(byteArrayOutputStream, this.dummyBlock, 69);
        BinaryTools.writeNullPadded(byteArrayOutputStream, this.macFileInfo, 16);
        String string = this.filename == null ? "" : this.filename.toFTFilename();
        ImEncodedString imEncodedString = ImEncodedString.encodeString(string);
        ImEncodingParams imEncodingParams = imEncodedString.getEncoding();
        BinaryTools.writeUShort(byteArrayOutputStream, imEncodingParams.getCharsetCode());
        BinaryTools.writeUShort(byteArrayOutputStream, imEncodingParams.getCharsetSubcode());
        byte[] byArray = imEncodedString.getBytes();
        byteArrayOutputStream.write(byArray);
        for (int i = byArray.length; i < 63; ++i) {
            byteArrayOutputStream.write(0);
        }
        byteArrayOutputStream.write(0);
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(byteArrayOutputStream.size() + 6);
        byteArrayOutputStream2.write(BinaryTools.getAsciiBytes(this.ftVersion));
        BinaryTools.writeUShort(byteArrayOutputStream2, byteArrayOutputStream.size() + 6);
        byteArrayOutputStream.writeTo(byteArrayOutputStream2);
        byteArrayOutputStream2.writeTo(outputStream);
    }

    public synchronized String toString() {
        return "FileTransferHeader:\n ftVersion='" + this.ftVersion + "'" + "\n headerType=0x" + Integer.toHexString(this.headerType) + "\n icbmMessageId=" + this.icbmMessageId + "\n encryption=" + this.encryption + "\n compression=" + this.compression + "\n fileCount=" + this.fileCount + "\n filesLeft=" + this.filesLeft + "\n partCount=" + this.partCount + "\n partsLeft=" + this.partsLeft + "\n totalSize=" + this.totalFileSize + "\n fileSize=" + this.fileSize + "\n lastmod=" + this.lastmod + "\n checksum=" + this.checksum + "\n resForkReceivedChecksum=" + this.resForkReceivedChecksum + "\n resForkSize=" + this.resForkSize + "\n created=" + this.created + "\n resForkChecksum=" + this.resForkChecksum + "\n bytesReceived=" + this.bytesReceived + "\n receivedChecksum=" + this.receivedChecksum + "\n clientid='" + this.clientid + "'" + "\n flags=0x" + Integer.toHexString(this.flags) + "\n listNameOffset=" + this.listNameOffset + "\n listSizeOffset=" + this.listSizeOffset + "\n macFileInfo=" + BinaryTools.describeData(this.macFileInfo) + "\n filename=" + this.filename;
    }
}

