/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator.packet.out;

import pl.mn.communicator.ILocalStatus;
import pl.mn.communicator.packet.GGConversion;
import pl.mn.communicator.packet.GGUtils;
import pl.mn.communicator.packet.out.GGOutgoingPackage;

public class GGLogin60
implements GGOutgoingPackage {
    public static final int GG_LOGIN60 = 21;
    private int m_uin = -1;
    private char[] m_password = null;
    private int m_loginHash = -1;
    private int m_status = 2;
    private byte[] m_localIP = new byte[]{0, 0, 0, 0};
    private int m_localPort = 1550;
    private byte[] m_externalIP = new byte[]{0, 0, 0, 0};
    private int m_externalPort = 1550;
    private byte m_imageSize = (byte)64;
    private String m_description = null;
    private int m_version = 33;
    private int m_time = -1;

    public GGLogin60(int uin, char[] password, int seed) {
        if (uin < 0) {
            throw new IllegalArgumentException("uin cannot be less than 0");
        }
        if (password == null) {
            throw new NullPointerException("password cannot be null");
        }
        this.m_uin = uin;
        this.m_password = password;
        this.m_loginHash = GGUtils.getLoginHash(password, seed);
    }

    public void setStatus(ILocalStatus localStatus) {
        if (localStatus == null) {
            throw new NullPointerException("localStatus cannot be null");
        }
        this.m_status = GGConversion.getProtocolStatus(localStatus, localStatus.isFriendsOnly(), false);
        if (localStatus.isDescriptionSet()) {
            this.m_description = localStatus.getDescription();
        }
        if (localStatus.isReturnDateSet()) {
            this.m_time = GGUtils.millisToSeconds(localStatus.getReturnDate().getTime());
        }
    }

    public int getUin() {
        return this.m_uin;
    }

    public char[] getPassword() {
        return this.m_password;
    }

    public void setLocalIP(byte[] localIP) {
        if (localIP == null) {
            throw new NullPointerException("localIP cannot be null");
        }
        if (localIP.length != 4) {
            throw new IllegalArgumentException("localIp table has to have 4 entries");
        }
        this.m_localIP = localIP;
    }

    public byte[] getLocalIP() {
        return this.m_localIP;
    }

    public void setLocalPort(int port) {
        if (port < 0) {
            throw new IllegalArgumentException("port cannot be null");
        }
        this.m_localPort = port;
    }

    public int getLocalPort() {
        return this.m_localPort;
    }

    public void setExternalIP(byte[] externalIP) {
        if (externalIP == null) {
            throw new NullPointerException("externalIP cannot be null");
        }
        if (externalIP.length != 4) {
            throw new IllegalArgumentException("externalIP table has to have 4 entries");
        }
        this.m_externalIP = externalIP;
    }

    public void setExternalPort(int externalPort) {
        if (externalPort < 0) {
            throw new IllegalArgumentException("port cannot be null");
        }
        this.m_externalPort = externalPort;
    }

    public void setImageSize(byte imageSize) {
        if (imageSize < 0) {
            throw new IllegalArgumentException("imageSize cannot be less than 0");
        }
        this.m_imageSize = imageSize;
    }

    public int getPacketType() {
        return 21;
    }

    public int getLength() {
        int length = 31;
        if (this.m_description != null) {
            length += this.m_description.length() + 1;
            if (this.m_time != -1) {
                length += 4;
            }
        }
        return length;
    }

    public byte[] getContents() {
        byte[] toSend = new byte[this.getLength()];
        toSend[0] = (byte)(this.m_uin & 0xFF);
        toSend[1] = (byte)(this.m_uin >> 8 & 0xFF);
        toSend[2] = (byte)(this.m_uin >> 16 & 0xFF);
        toSend[3] = (byte)(this.m_uin >> 24 & 0xFF);
        toSend[4] = (byte)(this.m_loginHash & 0xFF);
        toSend[5] = (byte)(this.m_loginHash >> 8 & 0xFF);
        toSend[6] = (byte)(this.m_loginHash >> 16 & 0xFF);
        toSend[7] = (byte)(this.m_loginHash >> 24 & 0xFF);
        toSend[8] = (byte)(this.m_status & 0xFF);
        toSend[9] = (byte)(this.m_status >> 8 & 0xFF);
        toSend[10] = (byte)(this.m_status >> 16 & 0xFF);
        toSend[11] = (byte)(this.m_status >> 24 & 0xFF);
        toSend[12] = (byte)(this.m_version & 0xFF);
        toSend[13] = (byte)(this.m_version >> 8 & 0xFF);
        toSend[14] = (byte)(this.m_version >> 16 & 0xFF);
        toSend[15] = (byte)(this.m_version >> 24 & 0xFF);
        toSend[16] = 0;
        toSend[17] = this.m_localIP[0];
        toSend[18] = this.m_localIP[1];
        toSend[19] = this.m_localIP[2];
        toSend[20] = this.m_localIP[3];
        toSend[21] = (byte)(this.m_localPort & 0xFF);
        toSend[22] = (byte)(this.m_localPort >> 8 & 0xFF);
        toSend[23] = this.m_externalIP[0];
        toSend[24] = this.m_externalIP[1];
        toSend[25] = this.m_externalIP[2];
        toSend[26] = this.m_externalIP[3];
        toSend[27] = (byte)(this.m_externalPort & 0xFF);
        toSend[28] = (byte)(this.m_externalPort >> 8 & 0xFF);
        toSend[29] = this.m_imageSize;
        toSend[30] = -66;
        if (this.m_description != null) {
            byte[] descBytes = GGUtils.stringToBytes(this.m_description);
            for (int i = 0; i < descBytes.length; ++i) {
                toSend[31 + i] = descBytes[i];
                if (this.m_time == -1) continue;
                toSend[31 + descBytes.length + 1] = (byte)(this.m_time >> 24 & 0xFF);
                toSend[31 + descBytes.length + 2] = (byte)(this.m_time >> 16 & 0xFF);
                toSend[31 + descBytes.length + 3] = (byte)(this.m_time >> 8 & 0xFF);
                toSend[31 + descBytes.length + 4] = (byte)(this.m_time & 0xFF);
            }
        }
        return toSend;
    }
}

