/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.client;

import com.hazelcast.client.impl.client.KeyBasedClientRequest;
import com.hazelcast.client.impl.client.SecureRequest;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapPortableHook;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.operation.RemoveOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;

public class MapRemoveRequest
extends KeyBasedClientRequest
implements Portable,
SecureRequest {
    protected String name;
    protected Data key;
    protected long threadId;
    protected boolean async;
    protected transient long startTime;

    public MapRemoveRequest() {
    }

    public MapRemoveRequest(String name, Data key, long threadId) {
        this.name = name;
        this.key = key;
        this.threadId = threadId;
    }

    @Override
    public int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 9;
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    protected void beforeProcess() {
        this.startTime = System.currentTimeMillis();
    }

    @Override
    protected void beforeResponse() {
        long latency = System.currentTimeMillis() - this.startTime;
        MapService mapService = (MapService)this.getService();
        MapContainer mapContainer = mapService.getMapServiceContext().getMapContainer(this.name);
        if (mapContainer.getMapConfig().isStatisticsEnabled()) {
            mapService.getMapServiceContext().getLocalMapStatsProvider().getLocalMapStatsImpl(this.name).incrementRemoves(latency);
        }
    }

    @Override
    protected Operation prepareOperation() {
        RemoveOperation op = new RemoveOperation(this.name, this.key);
        op.setThreadId(this.threadId);
        return op;
    }

    public void setAsAsync() {
        this.async = true;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeLong("t", this.threadId);
        writer.writeBoolean("a", this.async);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeData(this.key);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.threadId = reader.readLong("t");
        this.async = reader.readBoolean("a");
        ObjectDataInput in = reader.getRawDataInput();
        this.key = in.readData();
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.name, "remove");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }

    @Override
    public String getMethodName() {
        if (this.async) {
            return "removeAsync";
        }
        return "remove";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.key};
    }
}

