/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.ratelim;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.ratelim.RateMonitor;
import net.kano.joscar.snaccmd.conn.RateClassInfo;

public class RateClassMonitor {
    private static final Logger logger;
    private final RateMonitor rateMonitor;
    private RateClassInfo rateInfo;
    private long last = -1L;
    private long runningAvg;
    private boolean limited = false;
    private int errorMargin = -1;
    static final /* synthetic */ boolean $assertionsDisabled;

    RateClassMonitor(RateMonitor rateMonitor, RateClassInfo rateClassInfo) {
        this.rateMonitor = rateMonitor;
        this.rateInfo = rateClassInfo;
        this.runningAvg = rateClassInfo.getMax();
    }

    synchronized void updateRateInfo(int n, RateClassInfo rateClassInfo) {
        DefensiveTools.checkNull(rateClassInfo, "rateInfo");
        if (rateClassInfo.getRateClass() != this.rateInfo.getRateClass()) {
            throw new IllegalArgumentException("updated rate information is not the same class as the previous rate information for this rate class monitor");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Rate monitor for class " + rateClassInfo.getRateClass() + " thinks rate average is " + this.runningAvg + "ms; server " + "thinks it is " + rateClassInfo.getCurrentAvg() + "ms");
        }
        this.rateInfo = rateClassInfo;
        this.runningAvg = Math.min(rateClassInfo.getMax(), this.runningAvg);
        if (n == 3) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Rate class " + this.rateInfo.getRateClass() + ") is now rate-limited!");
            }
            this.setLimited(true);
        } else if (n == 4) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Rate class " + this.rateInfo.getRateClass() + ") is no longer rate-limited, according to server");
            }
            this.setLimited(false);
        }
    }

    synchronized void updateRate(long l) {
        if (this.last != -1L) {
            if (!$assertionsDisabled && l < this.last) {
                throw new AssertionError();
            }
            this.runningAvg = this.computeCurrentAvg(l);
        }
        this.last = l;
    }

    public final synchronized RateClassInfo getRateInfo() {
        return this.rateInfo;
    }

    private synchronized void updateLimitedStatus() {
        long l;
        if (this.limited && (l = this.computeCurrentAvg()) > this.rateInfo.getClearAvg() + (long)this.getErrorMargin()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("We think that rate class " + this.rateInfo.getRateClass() + " is not limited " + "anymore (avg is " + l + ")");
            }
            this.setLimited(false);
        }
    }

    public final synchronized int getErrorMargin() {
        if (this.errorMargin == -1) {
            return this.rateMonitor.getErrorMargin();
        }
        return this.errorMargin;
    }

    public final synchronized int getLocalErrorMargin() {
        return this.errorMargin;
    }

    public final synchronized void setErrorMargin(int n) {
        DefensiveTools.checkRange(n, "errorMargin", -1);
        this.errorMargin = n;
    }

    private synchronized long computeCurrentAvg(long l) {
        long l2 = l - this.last;
        long l3 = this.rateInfo.getWindowSize();
        long l4 = this.rateInfo.getMax();
        return Math.min(l4, (this.runningAvg * (l3 - 1L) + l2) / l3);
    }

    private synchronized long computeCurrentAvg() {
        return this.computeCurrentAvg(System.currentTimeMillis());
    }

    private synchronized void setLimited(boolean bl) {
        if (bl != this.limited) {
            this.limited = bl;
            this.rateMonitor.fireLimitedEvent(this, this.limited);
        }
    }

    public final synchronized boolean isLimited() {
        this.updateLimitedStatus();
        return this.limited;
    }

    public final synchronized long getLastRateAvg() {
        return this.runningAvg;
    }

    public final long getPotentialAvg() {
        return this.getPotentialAvg(System.currentTimeMillis());
    }

    public final long getPotentialAvg(long l) {
        return this.computeCurrentAvg(l);
    }

    public final synchronized long getOptimalWaitTime() {
        return this.getTimeUntil(this.getMinSafeAvg() + (long)this.getErrorMargin());
    }

    private synchronized long getMinSafeAvg() {
        if (this.isLimited()) {
            return this.rateInfo.getClearAvg();
        }
        return this.rateInfo.getLimitedAvg();
    }

    public final synchronized long getTimeUntil(long l) {
        if (this.last == -1L) {
            return 0L;
        }
        long l2 = this.rateInfo.getWindowSize();
        long l3 = System.currentTimeMillis() - this.last;
        long l4 = l2 * l - this.runningAvg * (l2 - 1L);
        long l5 = l4 - l3 + 1L;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Class " + this.rateInfo.getRateClass() + " should be waiting " + l5 + "ms (avg is " + this.computeCurrentAvg() + "ms)");
        }
        return Math.max(l5, 0L);
    }

    public final synchronized int getPossibleCmdCount() {
        return this.getPossibleCmdCount(this.runningAvg);
    }

    public final synchronized int getMaxCmdCount() {
        return this.getPossibleCmdCount(this.rateInfo.getMax());
    }

    private synchronized int getPossibleCmdCount(long l) {
        long l2 = System.currentTimeMillis() - this.last;
        long l3 = this.rateInfo.getWindowSize();
        long l4 = this.getMinSafeAvg() + (long)this.getErrorMargin();
        long l5 = l;
        int n = 0;
        while (l5 > l4) {
            l5 = (l2 + l5 * (l3 - 1L)) / l3;
            l2 = 0L;
            ++n;
        }
        if (n == 0) {
            return 0;
        }
        return n - 1;
    }

    static {
        $assertionsDisabled = !RateClassMonitor.class.desiredAssertionStatus();
        logger = Logger.getLogger("net.kano.joscar.ratelim");
    }
}

