/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.stats;

import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.videobridge.stats.ColibriStatsTransport;
import org.jitsi.videobridge.stats.PubSubStatsTransport;
import org.jitsi.videobridge.stats.StatsManager;
import org.jitsi.videobridge.stats.VideobridgeStatistics;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class StatsManagerBundleActivator
implements BundleActivator {
    private static BundleContext bundleContext;
    private static final int DEFAULT_STAT_INTERVAL = 1000;
    private static final String DEFAULT_STAT_TRANSPORT;
    private static final String ENABLE_STATISTICS_PNAME = "org.jitsi.videobridge.ENABLE_STATISTICS";
    private static final Logger logger;
    private static final String PUBSUB_NODE_PNAME = "org.jitsi.videobridge.PUBSUB_NODE";
    private static final String PUBSUB_SERVICE_PNAME = "org.jitsi.videobridge.PUBSUB_SERVICE";
    private static final String STAT_TRANSPORT_COLIBRI = "colibri";
    private static final String STAT_TRANSPORT_PUBSUB = "pubsub";
    private static final String STATISTICS_INTERVAL_PNAME = "org.jitsi.videobridge.STATISTICS_INTERVAL";
    private static final String STATISTICS_TRANSPORT_PNAME = "org.jitsi.videobridge.STATISTICS_TRANSPORT";
    private ServiceRegistration<StatsManager> serviceRegistration;

    public static BundleContext getBundleContext() {
        return bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext bundleContext) throws Exception {
        ConfigurationService cfg = (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class);
        boolean enable = false;
        if (cfg != null) {
            enable = cfg.getBoolean(ENABLE_STATISTICS_PNAME, enable);
        }
        if (enable) {
            StatsManagerBundleActivator.bundleContext = bundleContext;
            boolean started = false;
            try {
                this.start(cfg);
                started = true;
                Object var6_5 = null;
                if (!started && StatsManagerBundleActivator.bundleContext == bundleContext) {
                    StatsManagerBundleActivator.bundleContext = null;
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (!started && StatsManagerBundleActivator.bundleContext == bundleContext) {
                    StatsManagerBundleActivator.bundleContext = null;
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(ConfigurationService cfg) throws Exception {
        StatsManager statsMgr = new StatsManager();
        String transport = DEFAULT_STAT_TRANSPORT;
        int interval = 1000;
        if (cfg != null) {
            transport = cfg.getString(STATISTICS_TRANSPORT_PNAME, transport);
            interval = cfg.getInt(STATISTICS_INTERVAL_PNAME, interval);
        }
        if (STAT_TRANSPORT_COLIBRI.equals(transport)) {
            statsMgr.addTransport(new ColibriStatsTransport(), interval);
        } else if (STAT_TRANSPORT_PUBSUB.equals(transport)) {
            String service = cfg.getString(PUBSUB_SERVICE_PNAME);
            String node = cfg.getString(PUBSUB_NODE_PNAME);
            if (service != null && node != null) {
                statsMgr.addTransport(new PubSubStatsTransport(service, node), interval);
            } else {
                logger.error((Object)"No configuration options for PubSub service and/or node found.");
            }
        } else if (transport != null) {
            logger.error((Object)("Unknown statistics transport: " + transport));
        }
        statsMgr.addStatistics(new VideobridgeStatistics(), interval);
        statsMgr.start(bundleContext);
        ServiceRegistration serviceRegistration = null;
        try {
            serviceRegistration = bundleContext.registerService(StatsManager.class, (Object)statsMgr, null);
            Object var8_7 = null;
            if (serviceRegistration != null) {
                this.serviceRegistration = serviceRegistration;
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (serviceRegistration != null) {
                this.serviceRegistration = serviceRegistration;
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext bundleContext) throws Exception {
        ServiceRegistration<StatsManager> serviceRegistration = this.serviceRegistration;
        this.serviceRegistration = null;
        StatsManager statsMgr = null;
        try {
            statsMgr = (StatsManager)bundleContext.getService(serviceRegistration.getReference());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            serviceRegistration.unregister();
            if (statsMgr != null) {
                statsMgr.stop(bundleContext);
            }
            throw throwable;
        }
        serviceRegistration.unregister();
        if (statsMgr != null) {
            statsMgr.stop(bundleContext);
        }
    }

    static {
        DEFAULT_STAT_TRANSPORT = null;
        logger = Logger.getLogger(StatsManagerBundleActivator.class);
    }
}

