/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.rest;

import java.net.MalformedURLException;
import java.util.ArrayList;
import org.eclipse.jetty.rewrite.handler.RewriteHandler;
import org.eclipse.jetty.rewrite.handler.RewriteRegexRule;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.jitsi.videobridge.rest.AbstractJettyBundleActivator;
import org.jitsi.videobridge.rest.HandlerImpl;
import org.jitsi.videobridge.rest.ProxyServletImpl;
import org.osgi.framework.BundleContext;

public class RESTBundleActivator
extends AbstractJettyBundleActivator {
    private static final String ENABLE_REST_SHUTDOWN_PNAME = "org.jitsi.videobridge.ENABLE_REST_SHUTDOWN";
    private static final String JETTY_PROXY_SERVLET_HOST_HEADER_PNAME = "org.jitsi.videobridge.rest.jetty.ProxyServlet.hostHeader";
    private static final String JETTY_PROXY_SERVLET_PATH_SPEC_PNAME = "org.jitsi.videobridge.rest.jetty.ProxyServlet.pathSpec";
    private static final String JETTY_PROXY_SERVLET_PROXY_TO_PNAME = "org.jitsi.videobridge.rest.jetty.ProxyServlet.proxyTo";
    private static final String JETTY_RESOURCE_HANDLER_RESOURCE_BASE_PNAME = "org.jitsi.videobridge.rest.jetty.ResourceHandler.resourceBase";
    private static final String JETTY_RESOURCE_HANDLER_ALIAS_PREFIX = "org.jitsi.videobridge.rest.jetty.ResourceHandler.alias";
    private static final String JETTY_REWRITE_HANDLER_REGEX_PNAME = "org.jitsi.videobridge.rest.jetty.RewriteHandler.regex";
    private static final String JETTY_REWRITE_HANDLER_REPLACEMENT_PNAME = "org.jitsi.videobridge.rest.jetty.RewriteHandler.replacement";

    public RESTBundleActivator() {
        super("org.jitsi.videobridge.rest");
    }

    protected void doStop(BundleContext bundleContext) throws Exception {
        if (this.server != null) {
            Thread.sleep(1000L);
        }
        super.doStop(bundleContext);
    }

    private Handler initializeColibriHandler(BundleContext bundleContext, Server server) {
        return new HandlerImpl(bundleContext, this.getCfgBoolean(ENABLE_REST_SHUTDOWN_PNAME, false));
    }

    protected Handler initializeHandler(BundleContext bundleContext, Server server) throws Exception {
        Handler handler = super.initializeHandler(bundleContext, server);
        HandlerWrapper rewriteHandler = this.initializeRewriteHandler(bundleContext, server);
        if (rewriteHandler != null) {
            rewriteHandler.setHandler(handler);
            handler = rewriteHandler;
        }
        return handler;
    }

    protected Handler initializeHandlerList(BundleContext bundleContext, Server server) throws Exception {
        Handler servletHandler;
        Handler aliasHandler;
        Handler resourceHandler;
        ArrayList<Handler> handlers = new ArrayList<Handler>();
        Handler colibriHandler = this.initializeColibriHandler(bundleContext, server);
        if (colibriHandler != null) {
            handlers.add(colibriHandler);
        }
        if ((resourceHandler = this.initializeResourceHandler(bundleContext, server)) != null) {
            handlers.add(resourceHandler);
        }
        if ((aliasHandler = this.initializeResourceHandlerAliases(bundleContext, server)) != null) {
            handlers.add(aliasHandler);
        }
        if ((servletHandler = this.initializeServletHandler(bundleContext, server)) != null) {
            handlers.add(servletHandler);
        }
        return RESTBundleActivator.initializeHandlerList(handlers);
    }

    private Handler initializeResourceHandler(BundleContext bundleContext, Server server) {
        ResourceHandler resourceHandler;
        String resourceBase = this.getCfgString(JETTY_RESOURCE_HANDLER_RESOURCE_BASE_PNAME, null);
        if (resourceBase == null || resourceBase.length() == 0) {
            resourceHandler = null;
        } else {
            resourceHandler = new ResourceHandler();
            resourceHandler.setResourceBase(resourceBase);
        }
        ContextHandler contextHandler = new ContextHandler();
        contextHandler.setHandler((Handler)resourceHandler);
        contextHandler.addAliasCheck((ContextHandler.AliasCheck)new ContextHandler.ApproveAliases());
        return contextHandler;
    }

    private Handler initializeResourceHandlerAliases(BundleContext bundleContext, Server server) {
        return new ResourceHandler(){

            public Resource getResource(String path) throws MalformedURLException {
                String value = RESTBundleActivator.this.getCfgString("org.jitsi.videobridge.rest.jetty.ResourceHandler.alias." + path, null);
                if (value == null) {
                    return null;
                }
                return Resource.newResource((String)value);
            }
        };
    }

    private HandlerWrapper initializeRewriteHandler(BundleContext bundleContext, Server server) {
        String replacement;
        String regex = this.getCfgString(JETTY_REWRITE_HANDLER_REGEX_PNAME, null);
        RewriteHandler handler = null;
        if (regex != null && regex.length() != 0 && (replacement = this.getCfgString(JETTY_REWRITE_HANDLER_REPLACEMENT_PNAME, null)) != null) {
            RewriteRegexRule rule = new RewriteRegexRule();
            rule.setRegex(regex);
            rule.setReplacement(replacement);
            handler = new RewriteHandler();
            handler.addRule((Rule)rule);
        }
        return handler;
    }

    private Handler initializeServletHandler(BundleContext bundleContext, Server server) {
        String proxyTo;
        String pathSpec = this.getCfgString(JETTY_PROXY_SERVLET_PATH_SPEC_PNAME, null);
        ServletContextHandler handler = null;
        if (pathSpec != null && pathSpec.length() != 0 && (proxyTo = this.getCfgString(JETTY_PROXY_SERVLET_PROXY_TO_PNAME, null)) != null && proxyTo.length() != 0) {
            ServletHolder holder = new ServletHolder();
            holder.setHeldClass(ProxyServletImpl.class);
            holder.setInitParameter("maxThreads", Integer.toString(256));
            holder.setInitParameter("prefix", pathSpec);
            holder.setInitParameter("proxyTo", proxyTo);
            String hostHeader = this.getCfgString(JETTY_PROXY_SERVLET_HOST_HEADER_PNAME, null);
            if (hostHeader != null && hostHeader.length() != 0) {
                holder.setInitParameter("hostHeader", hostHeader);
            }
            ServletContextHandler servletContextHandler = new ServletContextHandler();
            servletContextHandler.addServlet(holder, pathSpec);
            servletContextHandler.setContextPath("/");
            handler = servletContextHandler;
        }
        return handler;
    }

    protected boolean willStart(BundleContext bundleContext) throws Exception {
        boolean b = super.willStart(bundleContext);
        if (b) {
            b = this.getCfgBoolean("org.jitsi.videobridge.rest", false);
        }
        return b;
    }
}

