/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.freedesktop.dbus.Gettext;

public class BusAddress {
    private String type;
    private Map<String, String> parameters;

    public BusAddress(String string) throws ParseException {
        if (null == string || "".equals(string)) {
            throw new ParseException(Gettext._("Bus address is blank"), 0);
        }
        String[] stringArray = string.split(":", 2);
        if (stringArray.length < 2) {
            throw new ParseException(Gettext._("Bus address is invalid: ") + string, 0);
        }
        this.type = stringArray[0];
        String[] stringArray2 = stringArray[1].split(",");
        this.parameters = new HashMap<String, String>();
        for (String string2 : stringArray2) {
            String[] stringArray3 = string2.split("=", 2);
            this.parameters.put(stringArray3[0], stringArray3[1]);
        }
    }

    public String getType() {
        return this.type;
    }

    public String getParameter(String string) {
        return this.parameters.get(string);
    }

    public String toString() {
        return this.type + ": " + this.parameters;
    }
}

