/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ui.wizards;

import java.awt.Component;
import java.util.logging.Logger;
import javax.media.control.TrackControl;
import net.sf.fmj.media.datasink.rtp.ParsedRTPUrl;
import net.sf.fmj.media.datasink.rtp.ParsedRTPUrlElement;
import net.sf.fmj.media.datasink.rtp.RTPUrlParser;
import net.sf.fmj.media.datasink.rtp.RTPUrlParserException;
import net.sf.fmj.ui.objeditor.ComponentValidationException;
import net.sf.fmj.ui.objeditor.ComponentValidator;
import net.sf.fmj.ui.utils.ErrorDialog;
import net.sf.fmj.ui.wizard.WizardPanelDescriptor;
import net.sf.fmj.ui.wizards.ContentAndTrackFormatPanelDescriptor;
import net.sf.fmj.ui.wizards.RTPDestPanel;
import net.sf.fmj.ui.wizards.RTPTransmitWizardConfig;
import net.sf.fmj.ui.wizards.RTPTransmitWizardResult;
import net.sf.fmj.ui.wizards.WizardStepException;
import net.sf.fmj.utility.LoggerSingleton;

public class RTPDestPanelDescriptor
extends WizardPanelDescriptor {
    private static final Logger logger = LoggerSingleton.logger;
    public static final String IDENTIFIER = RTPDestPanelDescriptor.class.getName();
    private final RTPDestPanel panel = new RTPDestPanel();
    private final RTPTransmitWizardConfig config;
    private final RTPTransmitWizardResult result;

    public RTPDestPanelDescriptor(RTPTransmitWizardConfig rTPTransmitWizardConfig, RTPTransmitWizardResult rTPTransmitWizardResult) {
        this.setPanelDescriptorIdentifier(IDENTIFIER);
        this.setPanelComponent(this.panel);
        this.config = rTPTransmitWizardConfig;
        this.result = rTPTransmitWizardResult;
    }

    public boolean aboutToDisplayPanel(Object object) {
        if (object == this.getBackPanelDescriptor()) {
            int n;
            int n2 = 0;
            TrackControl[] trackControlArray = this.result.processor.getTrackControls();
            if (trackControlArray.length == 0) {
                this.showError("No tracks available");
                return false;
            }
            for (n = 0; n < trackControlArray.length; ++n) {
                if (!trackControlArray[n].isEnabled()) continue;
                ++n2;
            }
            if (n2 < 1) {
                this.showError("At least 1 track must be enabled");
                return false;
            }
            for (n = 0; n < trackControlArray.length; ++n) {
                if (!trackControlArray[n].isEnabled()) continue;
                boolean bl = true;
                this.getRTPDestPanel().addTrack(n, bl);
                if (this.config.destUrl == null) continue;
                try {
                    ParsedRTPUrl parsedRTPUrl = RTPUrlParser.parse(this.config.destUrl);
                    this.getRTPDestPanel().getTextSessionAddress(n).setText(parsedRTPUrl.elements[n].host);
                    this.getRTPDestPanel().getTextPort(n).setText("" + parsedRTPUrl.elements[n].port);
                    this.getRTPDestPanel().getComboTTL(n).setSelectedItem("" + parsedRTPUrl.elements[n].ttl);
                    continue;
                }
                catch (RTPUrlParserException rTPUrlParserException) {
                    logger.warning("Unable to parse RTP URL: " + this.config.destUrl + ": " + rTPUrlParserException);
                }
            }
        }
        return true;
    }

    public boolean aboutToHidePanel(Object object) {
        if (object == this.getNextPanelDescriptor()) {
            ParsedRTPUrl parsedRTPUrl = null;
            TrackControl[] trackControlArray = this.result.processor.getTrackControls();
            for (int i = 0; i < trackControlArray.length; ++i) {
                if (!trackControlArray[i].isEnabled()) continue;
                boolean bl = true;
                ComponentValidator componentValidator = new ComponentValidator();
                try {
                    componentValidator.validateNotEmpty(this.getRTPDestPanel().getTextSessionAddress(i), this.getRTPDestPanel().getLabelSessionAddress());
                    componentValidator.validateNotEmpty(this.getRTPDestPanel().getTextPort(i), this.getRTPDestPanel().getLabelPort());
                    componentValidator.validateInteger(this.getRTPDestPanel().getTextPort(i), this.getRTPDestPanel().getLabelPort());
                    componentValidator.validateNotEmpty(this.getRTPDestPanel().getComboTTL(i), this.getRTPDestPanel().getLabelTTL());
                    componentValidator.validateInteger(this.getRTPDestPanel().getComboTTL(i), this.getRTPDestPanel().getLabelTTL());
                }
                catch (ComponentValidationException componentValidationException) {
                    ErrorDialog.showError((Component)this.getRTPDestPanel(), componentValidationException.getMessage());
                    return false;
                }
                String string = this.getRTPDestPanel().getTextSessionAddress(i).getText();
                int n = Integer.parseInt(this.getRTPDestPanel().getTextPort(i).getText());
                int n2 = Integer.parseInt((String)this.getRTPDestPanel().getComboTTL(i).getSelectedItem());
                ParsedRTPUrlElement parsedRTPUrlElement = new ParsedRTPUrlElement();
                parsedRTPUrlElement.host = string;
                parsedRTPUrlElement.port = n;
                parsedRTPUrlElement.ttl = n2;
                parsedRTPUrlElement.type = bl ? "audio" : "video";
                logger.fine("ParsedRTPUrlElement: " + parsedRTPUrlElement);
                parsedRTPUrl = new ParsedRTPUrl(parsedRTPUrlElement);
            }
            try {
                this.config.destUrl = parsedRTPUrl.toString();
                this.result.step4_setDestUrlAndStart(this.config);
            }
            catch (WizardStepException wizardStepException) {
                this.showError(wizardStepException);
                return false;
            }
        }
        return true;
    }

    public Object getBackPanelDescriptor() {
        return ContentAndTrackFormatPanelDescriptor.IDENTIFIER;
    }

    public Object getNextPanelDescriptor() {
        return FINISH;
    }

    public RTPDestPanel getRTPDestPanel() {
        return (RTPDestPanel)this.getPanelComponent();
    }
}

