/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp.util;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import net.sf.fmj.media.rtp.util.Packet;
import net.sf.fmj.media.rtp.util.PacketSource;
import net.sf.fmj.media.rtp.util.UDPPacket;

public class UDPPacketReceiver
implements PacketSource {
    private DatagramSocket sock;
    private int maxsize;
    byte[] dataBuf = new byte[1];

    public UDPPacketReceiver(DatagramSocket datagramSocket, int n) {
        this.sock = datagramSocket;
        this.maxsize = n;
        try {
            datagramSocket.setSoTimeout(5000);
        }
        catch (SocketException socketException) {
            System.out.println("could not set timeout on socket");
        }
    }

    public UDPPacketReceiver(int n, String string, int n2, String string2, int n3, DatagramSocket datagramSocket) throws SocketException, UnknownHostException, IOException {
        InetAddress inetAddress = InetAddress.getByName(string);
        InetAddress inetAddress2 = InetAddress.getByName(string2);
        if (inetAddress2.isMulticastAddress()) {
            MulticastSocket multicastSocket = new MulticastSocket(n2);
            multicastSocket.joinGroup(inetAddress2);
            this.sock = multicastSocket;
            this.maxsize = n3;
        } else {
            this.sock = datagramSocket != null ? datagramSocket : new DatagramSocket(n, inetAddress);
            if (string2 == null) {
                // empty if block
            }
            this.maxsize = n3;
        }
        try {
            this.sock.setSoTimeout(5000);
        }
        catch (SocketException socketException) {
            System.out.println("could not set timeout on socket");
        }
    }

    public void closeSource() {
        if (this.sock != null) {
            this.sock.close();
            this.sock = null;
        }
    }

    public DatagramSocket getSocket() {
        return this.sock;
    }

    public Packet receiveFrom() throws IOException {
        DatagramPacket datagramPacket;
        int n;
        do {
            if (this.dataBuf.length < this.maxsize) {
                this.dataBuf = new byte[this.maxsize];
            }
            datagramPacket = new DatagramPacket(this.dataBuf, this.maxsize);
            this.sock.receive(datagramPacket);
            n = datagramPacket.getLength();
            if (n <= this.maxsize >> 1) continue;
            this.maxsize = n << 1;
        } while (n >= datagramPacket.getData().length);
        UDPPacket uDPPacket = new UDPPacket();
        uDPPacket.receiptTime = System.currentTimeMillis();
        uDPPacket.data = datagramPacket.getData();
        uDPPacket.offset = 0;
        uDPPacket.length = n;
        uDPPacket.datagrampacket = datagramPacket;
        uDPPacket.localPort = this.sock.getLocalPort();
        uDPPacket.remotePort = datagramPacket.getPort();
        uDPPacket.remoteAddress = datagramPacket.getAddress();
        return uDPPacket;
    }

    public String sourceString() {
        String string = "UDP Datagram Packet Receiver on port " + this.sock.getLocalPort() + "on local address " + this.sock.getLocalAddress();
        return string;
    }
}

