/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.DataOutputStream;
import java.io.IOException;
import net.sf.fmj.media.rtp.RTCPPacket;

public class RTCPBYEPacket
extends RTCPPacket {
    int[] ssrc;
    byte[] reason;

    public RTCPBYEPacket(int[] nArray, byte[] byArray) {
        if (nArray.length > 31) {
            throw new IllegalArgumentException("Too many SSRCs");
        }
        this.ssrc = nArray;
        this.reason = byArray == null ? new byte[]{} : byArray;
    }

    public RTCPBYEPacket(RTCPPacket rTCPPacket) {
        super(rTCPPacket);
        this.type = 203;
    }

    public void assemble(DataOutputStream dataOutputStream) throws IOException {
        int n;
        dataOutputStream.writeByte(128 + this.ssrc.length);
        dataOutputStream.writeByte(203);
        dataOutputStream.writeShort(this.ssrc.length + (this.reason.length <= 0 ? 0 : this.reason.length + 4 >> 2));
        for (n = 0; n < this.ssrc.length; ++n) {
            dataOutputStream.writeInt(this.ssrc[n]);
        }
        if (this.reason.length > 0) {
            dataOutputStream.writeByte(this.reason.length);
            dataOutputStream.write(this.reason);
            for (n = (this.reason.length + 4 & 0xFFFFFFFC) - this.reason.length - 1; n > 0; --n) {
                dataOutputStream.writeByte(0);
            }
        }
    }

    public int calcLength() {
        return 4 + (this.ssrc.length << 2) + (this.reason.length <= 0 ? 0 : this.reason.length + 4 & 0xFFFFFFFC);
    }

    public String toString() {
        return "\tRTCP BYE packet for sync source(s) " + this.toString(this.ssrc) + " for " + (this.reason.length <= 0 ? "no reason" : "reason " + new String(this.reason)) + "\n";
    }

    public String toString(int[] nArray) {
        if (nArray.length == 0) {
            return "(none)";
        }
        String string = "" + nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            string = string + ", " + nArray[i];
        }
        return string;
    }
}

