/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.protocol.javasound;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;

public class SimpleAudioRecorder
extends Thread {
    private TargetDataLine m_line;
    private AudioFileFormat.Type m_targetType;
    private AudioInputStream m_audioInputStream;
    private File m_outputFile;

    public static void main(String[] stringArray) {
        if (stringArray.length != 1 || stringArray[0].equals("-h")) {
            SimpleAudioRecorder.printUsageAndExit();
        }
        String string = stringArray[0];
        File file = new File(string);
        AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 2, 4, 44100.0f, false);
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, audioFormat);
        TargetDataLine targetDataLine = null;
        try {
            targetDataLine = (TargetDataLine)AudioSystem.getLine(info);
            targetDataLine.open(audioFormat);
        }
        catch (LineUnavailableException lineUnavailableException) {
            SimpleAudioRecorder.out("unable to get a recording line");
            lineUnavailableException.printStackTrace();
            System.exit(1);
        }
        AudioFileFormat.Type type = AudioFileFormat.Type.WAVE;
        SimpleAudioRecorder simpleAudioRecorder = new SimpleAudioRecorder(targetDataLine, type, file);
        SimpleAudioRecorder.out("Press ENTER to start the recording.");
        try {
            System.in.read();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        simpleAudioRecorder.start();
        SimpleAudioRecorder.out("Recording...");
        SimpleAudioRecorder.out("Press ENTER to stop the recording.");
        try {
            System.in.read();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        simpleAudioRecorder.stopRecording();
        SimpleAudioRecorder.out("Recording stopped.");
    }

    private static void out(String string) {
        System.out.println(string);
    }

    private static void printUsageAndExit() {
        SimpleAudioRecorder.out("SimpleAudioRecorder: usage:");
        SimpleAudioRecorder.out("\tjava SimpleAudioRecorder -h");
        SimpleAudioRecorder.out("\tjava SimpleAudioRecorder <audiofile>");
        System.exit(0);
    }

    public SimpleAudioRecorder(TargetDataLine targetDataLine, AudioFileFormat.Type type, File file) {
        this.m_line = targetDataLine;
        this.m_audioInputStream = new AudioInputStream(targetDataLine);
        this.m_targetType = type;
        this.m_outputFile = file;
    }

    public void run() {
        try {
            AudioSystem.write(this.m_audioInputStream, this.m_targetType, this.m_outputFile);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void start() {
        this.m_line.start();
        super.start();
    }

    public void stopRecording() {
        this.m_line.stop();
        this.m_line.close();
    }
}

