/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.header.SIPHeader;
import javax.sip.InvalidArgumentException;
import javax.sip.header.ContentLengthHeader;

public class ContentLength
extends SIPHeader
implements ContentLengthHeader {
    private static final long serialVersionUID = 1187190542411037027L;
    protected Integer contentLength;

    public ContentLength() {
        super("Content-Length");
    }

    public ContentLength(int n) {
        super("Content-Length");
        this.contentLength = new Integer(n);
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(int n) throws InvalidArgumentException {
        if (n < 0) {
            throw new InvalidArgumentException("JAIN-SIP Exception, ContentLength, setContentLength(), the contentLength parameter is <0");
        }
        this.contentLength = new Integer(n);
    }

    public String encodeBody() {
        return this.encodeBody(new StringBuffer()).toString();
    }

    protected StringBuffer encodeBody(StringBuffer stringBuffer) {
        if (this.contentLength == null) {
            stringBuffer.append("0");
        } else {
            stringBuffer.append(this.contentLength.toString());
        }
        return stringBuffer;
    }

    public boolean match(Object object) {
        return object instanceof ContentLength;
    }

    public boolean equals(Object object) {
        if (object instanceof ContentLengthHeader) {
            ContentLengthHeader contentLengthHeader = (ContentLengthHeader)object;
            return this.getContentLength() == contentLengthHeader.getContentLength();
        }
        return false;
    }
}

