/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx;

import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.PEPListener;
import org.jivesoftware.smackx.packet.PEPEvent;
import org.jivesoftware.smackx.packet.PEPItem;
import org.jivesoftware.smackx.packet.PEPPubSub;

public class PEPManager {
    private List<PEPListener> pepListeners = new ArrayList<PEPListener>();
    private Connection connection;
    private PacketFilter packetFilter = new PacketExtensionFilter("event", "http://jabber.org/protocol/pubsub#event");
    private PacketListener packetListener;

    public PEPManager(Connection connection) {
        this.connection = connection;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPEPListener(PEPListener pepListener) {
        List<PEPListener> list = this.pepListeners;
        synchronized (list) {
            if (!this.pepListeners.contains(pepListener)) {
                this.pepListeners.add(pepListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePEPListener(PEPListener pepListener) {
        List<PEPListener> list = this.pepListeners;
        synchronized (list) {
            this.pepListeners.remove(pepListener);
        }
    }

    public void publish(PEPItem item) {
        PEPPubSub pubSub = new PEPPubSub(item);
        pubSub.setType(IQ.Type.SET);
        this.connection.sendPacket(pubSub);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePEPListeners(String from, PEPEvent event) {
        PEPListener[] listeners = null;
        List<PEPListener> list = this.pepListeners;
        synchronized (list) {
            listeners = new PEPListener[this.pepListeners.size()];
            this.pepListeners.toArray(listeners);
        }
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].eventReceived(from, event);
        }
    }

    private void init() {
        this.packetListener = new PacketListener(){

            public void processPacket(Packet packet) {
                Message message = (Message)packet;
                PEPEvent event = (PEPEvent)message.getExtension("event", "http://jabber.org/protocol/pubsub#event");
                PEPManager.this.firePEPListeners(message.getFrom(), event);
            }
        };
        this.connection.addPacketListener(this.packetListener, this.packetFilter);
    }

    public void destroy() {
        if (this.connection != null) {
            this.connection.removePacketListener(this.packetListener);
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }
}

