/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.ssi;

import java.util.SortedSet;
import java.util.TreeSet;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.snaccmd.ssi.CreateItemsCmd;
import net.kano.joscar.snaccmd.ssi.ItemsCmd;
import net.kano.joscar.snaccmd.ssi.ModifyItemsCmd;
import net.kano.joscar.snaccmd.ssi.SsiItem;
import net.kano.joscar.ssiitem.DefaultSsiItemObjFactory;
import net.kano.joscar.ssiitem.PrivacyItem;
import net.kano.joscar.ssiitem.SsiItemObj;
import net.kano.joscar.ssiitem.SsiItemObjectFactory;
import net.kano.joscar.ssiitem.SsiItemObjectWithId;
import net.kano.joscar.ssiitem.VisibilityItem;
import net.kano.joustsim.oscar.oscar.service.ssi.ItemIdComparator;
import net.kano.joustsim.oscar.oscar.service.ssi.ServerStoredSettings;
import net.kano.joustsim.oscar.oscar.service.ssi.ServerStoredSettingsListener;
import net.kano.joustsim.oscar.oscar.service.ssi.SsiItemChangeListener;
import net.kano.joustsim.oscar.oscar.service.ssi.SsiServiceImpl;
import net.kano.joustsim.oscar.oscar.service.ssi.SsiTools;

public class SsiServerStoredSettings
implements ServerStoredSettings,
SsiItemChangeListener {
    private SsiServiceImpl ssiService;
    private CopyOnWriteArrayList<ServerStoredSettingsListener> listeners = new CopyOnWriteArrayList();
    private SsiItemObjectFactory factory = new DefaultSsiItemObjFactory();
    private SortedSet<PrivacyItem> privacyItems = new TreeSet<SsiItemObjectWithId>(new ItemIdComparator());
    private SortedSet<VisibilityItem> visibilityItems = new TreeSet<SsiItemObjectWithId>(new ItemIdComparator());

    SsiServerStoredSettings(SsiServiceImpl ssiService) {
        this.ssiService = ssiService;
        ssiService.addItemChangeListener(this);
    }

    public void handleItemCreated(final SsiItem item) {
        this.modifyItems(new Runnable(){

            public void run() {
                SsiItemObj itemObj = SsiServerStoredSettings.this.factory.getItemObj(item);
                SsiServerStoredSettings.this.handleItemActuallyCreated(itemObj);
            }
        });
    }

    public void handleItemModified(final SsiItem item) {
        this.modifyItems(new Runnable(){

            public void run() {
                SsiItemObj itemObj = SsiServerStoredSettings.this.factory.getItemObj(item);
                SsiServerStoredSettings.this.handleItemActuallyModified(itemObj);
            }
        });
    }

    public void handleItemDeleted(final SsiItem item) {
        this.modifyItems(new Runnable(){

            public void run() {
                SsiItemObj itemObj = SsiServerStoredSettings.this.factory.getItemObj(item);
                SsiServerStoredSettings.this.handleItemActuallyDeleted(itemObj);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyItems(Runnable runnable) {
        boolean recentUsed;
        boolean typingShown;
        boolean idleTimeShown;
        boolean mobileDeviceShown;
        boolean wasRecentUsed;
        boolean wasTypingShown;
        boolean wasIdleTimeShown;
        boolean wasMobileDeviceShown;
        SsiServerStoredSettings ssiServerStoredSettings = this;
        synchronized (ssiServerStoredSettings) {
            wasMobileDeviceShown = this.isMobileDeviceShown();
            wasIdleTimeShown = this.isIdleTimeShown();
            wasTypingShown = this.isTypingShown();
            wasRecentUsed = this.isRecentBuddiesUsed();
            runnable.run();
            mobileDeviceShown = this.isMobileDeviceShown();
            idleTimeShown = this.isIdleTimeShown();
            typingShown = this.isTypingShown();
            recentUsed = this.isRecentBuddiesUsed();
        }
        if (wasMobileDeviceShown != mobileDeviceShown) {
            for (ServerStoredSettingsListener listener : this.listeners) {
                listener.handleMobileDeviceShownChanged(this, mobileDeviceShown);
            }
        }
        if (wasIdleTimeShown != idleTimeShown) {
            for (ServerStoredSettingsListener listener : this.listeners) {
                listener.handleIdleTimeShownChanged(this, idleTimeShown);
            }
        }
        if (wasTypingShown != typingShown) {
            for (ServerStoredSettingsListener listener : this.listeners) {
                listener.handleTypingShownChanged(this, typingShown);
            }
        }
        if (wasRecentUsed != recentUsed) {
            for (ServerStoredSettingsListener listener : this.listeners) {
                listener.handleRecentBuddiesUsedChanged(this, recentUsed);
            }
        }
    }

    public boolean isMobileDeviceShown() {
        PrivacyItem privacyItem = this.getPrivacyItem();
        return privacyItem == null ? true : (privacyItem.getVisibleMask() & 2L) == 0L;
    }

    public boolean isIdleTimeShown() {
        return this.isVisiblityFlagOn(1024L);
    }

    private boolean isVisiblityFlagOn(long mask) {
        VisibilityItem visibilityItem = this.getVisibilityItem();
        return visibilityItem == null ? true : (visibilityItem.getVisFlags() & mask) != 0L;
    }

    public boolean isTypingShown() {
        return this.isVisiblityFlagOn(0x400000L);
    }

    public boolean isRecentBuddiesUsed() {
        return !this.isVisiblityFlagOn(131072L);
    }

    public void changeMobileDeviceShown(boolean shown) {
        PrivacyItem oldItem = this.getPrivacyItem();
        if (oldItem == null) {
            int id = this.ssiService.getUniqueItemId(4, 0);
            long newMask = shown ? 0L : 2L;
            PrivacyItem item = new PrivacyItem(id, 1, newMask);
            this.ssiService.sendSsiModification((ItemsCmd)new CreateItemsCmd(new SsiItem[]{item.toSsiItem()}));
        } else {
            PrivacyItem item = new PrivacyItem(oldItem);
            long oldMask = item.getVisibleMask();
            long newMask = shown ? oldMask & 0xFFFFFFFFFFFFFFFDL : oldMask | 2L;
            item.setVisibleMask(newMask);
            this.ssiService.sendSsiModification((ItemsCmd)new ModifyItemsCmd(new SsiItem[]{item.toSsiItem()}));
        }
    }

    public void changeIdleTimeShown(boolean shown) {
        this.changeVisibilityMaskBit(1024L, shown);
    }

    public void changeTypingShown(boolean shown) {
        this.changeVisibilityMaskBit(0x400000L, shown);
    }

    public void changeRecentBuddiesUsed(boolean used) {
        this.changeVisibilityMaskBit(131072L, !used);
    }

    private void changeVisibilityMaskBit(long mask, boolean shown) {
        VisibilityItem oldItem = this.getVisibilityItem();
        if (oldItem == null) {
            int id = this.ssiService.getUniqueItemId(5, 0);
            long newMask = shown ? mask : 0L;
            VisibilityItem item = new VisibilityItem(id, newMask);
            this.ssiService.sendSsiModification((ItemsCmd)new CreateItemsCmd(new SsiItem[]{item.toSsiItem()}));
        } else {
            VisibilityItem item = new VisibilityItem(oldItem);
            long oldMask = item.getVisFlags();
            long newMask = shown ? oldMask | mask : oldMask & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            item.setVisFlags(newMask);
            this.ssiService.sendSsiModification((ItemsCmd)new ModifyItemsCmd(new SsiItem[]{item.toSsiItem()}));
        }
    }

    private synchronized void handleItemActuallyCreated(SsiItemObj itemObj) {
        if (itemObj instanceof PrivacyItem) {
            PrivacyItem privacyItem = (PrivacyItem)itemObj;
            this.privacyItems.add(privacyItem);
        } else if (itemObj instanceof VisibilityItem) {
            VisibilityItem visibilityItem = (VisibilityItem)itemObj;
            this.visibilityItems.add(visibilityItem);
        }
    }

    private synchronized void handleItemActuallyModified(SsiItemObj itemObj) {
        if (itemObj instanceof PrivacyItem) {
            PrivacyItem privacyItem = (PrivacyItem)itemObj;
            SsiTools.removeItemsWithId(this.privacyItems, privacyItem.getId());
            this.privacyItems.add(privacyItem);
        } else if (itemObj instanceof VisibilityItem) {
            VisibilityItem visibilityItem = (VisibilityItem)itemObj;
            SsiTools.removeItemsWithId(this.visibilityItems, visibilityItem.getId());
            this.visibilityItems.add(visibilityItem);
        }
    }

    private synchronized void handleItemActuallyDeleted(SsiItemObj itemObj) {
        if (itemObj instanceof PrivacyItem) {
            PrivacyItem privacyItem = (PrivacyItem)itemObj;
            SsiTools.removeItemsWithId(this.privacyItems, privacyItem.getId());
        } else if (itemObj instanceof VisibilityItem) {
            VisibilityItem visibilityItem = (VisibilityItem)itemObj;
            SsiTools.removeItemsWithId(this.visibilityItems, visibilityItem.getId());
        }
    }

    private synchronized PrivacyItem getPrivacyItem() {
        return this.privacyItems.isEmpty() ? null : this.privacyItems.last();
    }

    private synchronized VisibilityItem getVisibilityItem() {
        return this.visibilityItems.isEmpty() ? null : this.visibilityItems.last();
    }

    public void addListener(ServerStoredSettingsListener listener) {
        this.listeners.addIfAbsent((Object)listener);
    }

    public void removeListener(ServerStoredSettingsListener listener) {
        this.listeners.remove((Object)listener);
    }
}

