/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.util;

import java.io.File;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;
import net.java.sip.communicator.util.Logger;

public class FileUtils {
    private static final Logger logger = Logger.getLogger(FileUtils.class);

    public static boolean isImage(String fileName) {
        String[] imageTypes;
        fileName = fileName.toLowerCase();
        String[] stringArray = imageTypes = new String[]{"jpeg", "jpg", "png", "gif"};
        int n = imageTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String imageType = stringArray[n2];
            if (fileName.endsWith(imageType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Icon getIcon(File file) {
        Icon fileIcon;
        block5: {
            fileIcon = null;
            try {
                fileIcon = FileSystemView.getFileSystemView().getSystemIcon(file);
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed to obtain file icon from ShellFolder.", e);
                }
                try {
                    fileIcon = new JFileChooser().getIcon(file);
                }
                catch (Exception e1) {
                    if (!logger.isDebugEnabled()) break block5;
                    logger.debug("Failed to obtain file icon from JFileChooser.", e1);
                }
            }
        }
        return fileIcon;
    }
}

