/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.util;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public abstract class AbstractServiceDependentActivator
implements BundleActivator {
    private Object dependentService = null;

    public void start(BundleContext bundleContext) throws Exception {
        this.setBundleContext(bundleContext);
        if (this.getDependentService(bundleContext) == null) {
            try {
                bundleContext.addServiceListener((ServiceListener)new DependentServiceListener(bundleContext), "(objectClass=" + this.getDependentServiceClass().getName() + ')');
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
            return;
        }
        this.start(this.getDependentService(bundleContext));
    }

    public abstract void start(Object var1);

    public abstract Class<?> getDependentServiceClass();

    public abstract void setBundleContext(BundleContext var1);

    private Object getDependentService(BundleContext context) {
        ServiceReference serviceRef;
        if (this.dependentService == null && (serviceRef = context.getServiceReference(this.getDependentServiceClass().getName())) != null) {
            this.dependentService = context.getService(serviceRef);
        }
        return this.dependentService;
    }

    private class DependentServiceListener
    implements ServiceListener {
        private BundleContext context;

        DependentServiceListener(BundleContext context) {
            this.context = context;
        }

        public void serviceChanged(ServiceEvent serviceEvent) {
            Object depService = AbstractServiceDependentActivator.this.getDependentService(this.context);
            if (depService != null) {
                this.context.removeServiceListener((ServiceListener)this);
                AbstractServiceDependentActivator.this.start(depService);
            }
        }
    }
}

