/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.dns;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.java.sip.communicator.impl.dns.SecureMessage;
import net.java.sip.communicator.impl.dns.UnboundApi;
import net.java.sip.communicator.impl.dns.UnboundException;
import net.java.sip.communicator.impl.dns.UnboundResult;
import net.java.sip.communicator.service.dns.CustomResolver;
import net.java.sip.communicator.service.dns.DnssecRuntimeException;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.NetworkUtils;
import org.xbill.DNS.Message;
import org.xbill.DNS.ResolverConfig;
import org.xbill.DNS.ResolverListener;
import org.xbill.DNS.TSIG;

public class UnboundResolver
implements CustomResolver {
    private static final Logger logger = Logger.getLogger(UnboundResolver.class);
    private int timeout = 10000;
    private String[] forwarders;
    private List<String> trustAnchors = new LinkedList<String>();
    private ExecutorService threadPool = Executors.newCachedThreadPool();

    public void setForwarders(String[] forwarders) {
        this.forwarders = forwarders;
    }

    public void clearTrustAnchors() {
        this.trustAnchors.clear();
    }

    public void addTrustAnchor(String anchor) {
        this.trustAnchors.add(anchor);
    }

    public SecureMessage send(final Message query) throws IOException {
        Future<SecureMessage> future = this.threadPool.submit(new Callable<SecureMessage>(){

            @Override
            public SecureMessage call() throws Exception {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)query);
                }
                SecureMessage secureMessage = null;
                long context = UnboundResolver.this.prepareContext();
                try {
                    UnboundResult result = UnboundApi.resolve(context, query.getQuestion().getName().toString(), query.getQuestion().getType(), query.getQuestion().getDClass());
                    secureMessage = new SecureMessage(result);
                    UnboundResolver.this.validateMessage(secureMessage);
                }
                catch (Throwable throwable) {
                    UnboundApi.deleteContext(context);
                    if (logger.isDebugEnabled() && secureMessage != null) {
                        logger.debug(secureMessage);
                    }
                    throw throwable;
                }
                UnboundApi.deleteContext(context);
                if (logger.isDebugEnabled() && secureMessage != null) {
                    logger.debug((Object)secureMessage);
                }
                return secureMessage;
            }
        });
        try {
            return future.get(this.timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.error((Object)e);
            throw new IOException(e.getMessage());
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof DnssecRuntimeException) {
                throw new DnssecRuntimeException(e.getCause().getMessage());
            }
            logger.error((Object)e);
            throw new IOException(e.getMessage());
        }
        catch (TimeoutException e) {
            throw new SocketTimeoutException(e.getMessage());
        }
    }

    protected void validateMessage(SecureMessage msg) throws DnssecRuntimeException {
    }

    private long prepareContext() {
        long context = UnboundApi.createContext();
        if (logger.isTraceEnabled()) {
            UnboundApi.setDebugLevel(context, 100);
        }
        String[] stringArray = this.forwarders == null ? ResolverConfig.getCurrentConfig().servers() : this.forwarders;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fwd = stringArray[n2];
            if (NetworkUtils.isValidIPAddress((String)(fwd = fwd.trim()))) {
                if (fwd.startsWith("[")) {
                    fwd = fwd.substring(1, fwd.length() - 1);
                }
                UnboundApi.setForwarder(context, fwd);
            }
            ++n2;
        }
        for (String anchor : this.trustAnchors) {
            UnboundApi.addTrustAnchor(context, anchor);
        }
        return context;
    }

    private static synchronized void deleteContext(CallbackData cbData, boolean cancelAsync) {
        if (cbData.context == 0L) {
            return;
        }
        if (cancelAsync) {
            try {
                UnboundApi.cancelAsync(cbData.context, cbData.asyncId);
            }
            catch (UnboundException unboundException) {
                // empty catch block
            }
        }
        UnboundApi.deleteContext(cbData.context);
        cbData.context = 0L;
    }

    public CallbackData sendAsync(Message query, ResolverListener listener) {
        int asyncId;
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        final long context = this.prepareContext();
        final CallbackData cbData = new CallbackData();
        cbData.listener = listener;
        cbData.context = context;
        try {
            asyncId = UnboundApi.resolveAsync(context, query.getQuestion().getName().toString(), query.getQuestion().getType(), query.getQuestion().getDClass(), cbData, new UnboundApi.UnboundCallback(){

                @Override
                public void UnboundResolveCallback(Object data, int err, UnboundResult result) {
                    CallbackData cbData = (CallbackData)data;
                    UnboundResolver.deleteContext(cbData, false);
                    ResolverListener l = cbData.listener;
                    if (err == 0) {
                        try {
                            l.receiveMessage(data, (Message)new SecureMessage(result));
                        }
                        catch (IOException e) {
                            l.handleException(data, (Exception)e);
                        }
                    } else {
                        l.handleException(data, new Exception(UnboundApi.errorCodeToString(err)));
                    }
                    cbData.sync.countDown();
                }
            });
        }
        catch (UnboundException e) {
            listener.handleException(null, (Exception)e);
            return null;
        }
        cbData.asyncId = asyncId;
        this.threadPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    UnboundApi.processAsync(context);
                }
                catch (UnboundException ex) {
                    cbData.listener.handleException((Object)this, (Exception)ex);
                    UnboundResolver.deleteContext(cbData, false);
                    cbData.sync.countDown();
                }
            }
        });
        return cbData;
    }

    public void setEDNS(int level) {
        throw new UnsupportedOperationException();
    }

    public void setEDNS(int level, int payloadSize, int flags, List options) {
        throw new UnsupportedOperationException();
    }

    public void setIgnoreTruncation(boolean flag) {
        throw new UnsupportedOperationException();
    }

    public void setPort(int port) {
        throw new UnsupportedOperationException();
    }

    public void setTCP(boolean flag) {
        throw new UnsupportedOperationException();
    }

    public void setTSIGKey(TSIG key) {
        throw new UnsupportedOperationException();
    }

    public void setTimeout(int secs) {
        this.timeout = secs * 1000;
    }

    public void setTimeout(int secs, int msecs) {
        this.timeout = secs * 1000 + msecs;
    }

    public void reset() {
    }

    private static class CallbackData {
        ResolverListener listener;
        long context;
        int asyncId;
        CountDownLatch sync = new CountDownLatch(1);

        private CallbackData() {
        }
    }
}

