/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.video.h264;

import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.VideoFormat;
import net.sf.fmj.media.AbstractCodec;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.impl.neomedia.codec.FFmpeg;
import org.jitsi.impl.neomedia.codec.video.AVFrame;
import org.jitsi.impl.neomedia.codec.video.AVFrameFormat;
import org.jitsi.service.neomedia.control.KeyFrameControl;

public class JNIDecoder
extends AbstractCodec {
    private static final VideoFormat[] DEFAULT_OUTPUT_FORMATS = new VideoFormat[]{new AVFrameFormat(0)};
    private static final String PLUGIN_NAME = "H.264 Decoder";
    private long avctx;
    private AVFrame avframe;
    private final boolean[] got_picture = new boolean[1];
    private boolean gotPictureAtLeastOnce;
    private int height;
    private KeyFrameControl keyFrameControl;
    private final VideoFormat[] outputFormats;
    private int width;

    public JNIDecoder() {
        this.inputFormats = new VideoFormat[]{new VideoFormat("h264")};
        this.outputFormats = DEFAULT_OUTPUT_FORMATS;
    }

    public boolean checkFormat(Format format) {
        return format.getEncoding().equals("h264/rtp");
    }

    @Override
    public synchronized void close() {
        if (this.opened) {
            this.opened = false;
            super.close();
            FFmpeg.avcodec_close(this.avctx);
            FFmpeg.av_free(this.avctx);
            this.avctx = 0L;
            if (this.avframe != null) {
                this.avframe.free();
                this.avframe = null;
            }
            this.gotPictureAtLeastOnce = false;
        }
    }

    private float ensureFrameRate(float frameRate) {
        return frameRate;
    }

    protected Format[] getMatchingOutputFormats(Format inputFormat) {
        VideoFormat inputVideoFormat = (VideoFormat)inputFormat;
        return new Format[]{new AVFrameFormat(inputVideoFormat.getSize(), this.ensureFrameRate(inputVideoFormat.getFrameRate()), 0)};
    }

    @Override
    public String getName() {
        return PLUGIN_NAME;
    }

    @Override
    public Format[] getSupportedOutputFormats(Format inputFormat) {
        Format[] supportedOutputFormats = inputFormat == null ? this.outputFormats : (!(inputFormat instanceof VideoFormat) || AbstractCodec2.matches(inputFormat, this.inputFormats) == null ? new Format[]{} : this.getMatchingOutputFormats(inputFormat));
        return supportedOutputFormats;
    }

    @Override
    public synchronized void open() throws ResourceUnavailableException {
        if (this.opened) {
            return;
        }
        if (this.avframe != null) {
            this.avframe.free();
            this.avframe = null;
        }
        this.avframe = new AVFrame();
        long avcodec = FFmpeg.avcodec_find_decoder(28);
        this.avctx = FFmpeg.avcodec_alloc_context3(avcodec);
        FFmpeg.avcodeccontext_set_workaround_bugs(this.avctx, 1);
        FFmpeg.avcodeccontext_add_flags2(this.avctx, 32768);
        if (FFmpeg.avcodec_open2(this.avctx, avcodec, new String[0]) < 0) {
            throw new RuntimeException("Could not open codec CODEC_ID_H264");
        }
        this.gotPictureAtLeastOnce = false;
        this.opened = true;
        super.open();
    }

    @Override
    public synchronized int process(Buffer in, Buffer out) {
        long pts;
        if (!this.checkInputBuffer(in)) {
            return 1;
        }
        if (this.isEOM(in) || !this.opened) {
            this.propagateEOM(out);
            return 0;
        }
        if (in.isDiscard()) {
            out.setDiscard(true);
            return 0;
        }
        this.got_picture[0] = false;
        FFmpeg.avcodec_decode_video(this.avctx, this.avframe.getPtr(), this.got_picture, (byte[])in.getData(), in.getLength());
        if (!this.got_picture[0]) {
            if ((in.getFlags() & 0x800) != 0 && this.keyFrameControl != null) {
                this.keyFrameControl.requestKeyFrame(!this.gotPictureAtLeastOnce);
            }
            out.setDiscard(true);
            return 0;
        }
        this.gotPictureAtLeastOnce = true;
        int width = FFmpeg.avcodeccontext_get_width(this.avctx);
        int height = FFmpeg.avcodeccontext_get_height(this.avctx);
        if (width > 0 && height > 0 && (this.width != width || this.height != height)) {
            this.width = width;
            this.height = height;
            Dimension outSize = new Dimension(this.width, this.height);
            VideoFormat inFormat = (VideoFormat)in.getFormat();
            float outFrameRate = this.ensureFrameRate(inFormat.getFrameRate());
            this.outputFormat = new AVFrameFormat(outSize, outFrameRate, 0);
        }
        out.setFormat(this.outputFormat);
        if (out.getData() != this.avframe) {
            out.setData(this.avframe);
        }
        if ((pts = Long.MIN_VALUE) == Long.MIN_VALUE) {
            out.setTimeStamp(-1L);
        } else {
            out.setTimeStamp(pts);
            int outFlags = out.getFlags();
            outFlags |= 0x100;
            out.setFlags(outFlags &= 0xFFFFEF7F);
        }
        return 0;
    }

    @Override
    public Format setInputFormat(Format format) {
        Format setFormat = super.setInputFormat(format);
        if (setFormat != null) {
            this.reset();
        }
        return setFormat;
    }

    public void setKeyFrameControl(KeyFrameControl keyFrameControl) {
        this.keyFrameControl = keyFrameControl;
    }
}

