/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OptionalDataException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import net.sf.fmj.media.util.FormatTable;

public class Resource {
    private static Hashtable hash = null;
    private static String filename = null;
    private static final int versionNumber = 200;
    private static final String USERHOME = "user.home";
    private static String userhome = null;
    static FormatTable audioFmtTbl;
    static FormatTable videoFmtTbl;
    static FormatTable miscFmtTbl;
    static Object fmtTblSync;
    static int AUDIO_TBL_SIZE;
    static int VIDEO_TBL_SIZE;
    static int MISC_TBL_SIZE;
    static String AUDIO_SIZE_KEY;
    static String AUDIO_INPUT_KEY;
    static String AUDIO_FORMAT_KEY;
    static String AUDIO_HIT_KEY;
    static String VIDEO_SIZE_KEY;
    static String VIDEO_INPUT_KEY;
    static String VIDEO_FORMAT_KEY;
    static String VIDEO_HIT_KEY;
    static String MISC_SIZE_KEY;
    static String MISC_INPUT_KEY;
    static String MISC_FORMAT_KEY;
    static String MISC_HIT_KEY;
    static boolean needSaving;

    public static final synchronized boolean commit() throws IOException {
        return true;
    }

    public static final synchronized void destroy() {
        if (filename == null) {
            return;
        }
        try {
            File file = new File(filename);
            file.delete();
        }
        catch (Throwable t) {
            filename = null;
        }
    }

    private static final synchronized InputStream findResourceFile() {
        FileInputStream ris = null;
        if (userhome == null) {
            return null;
        }
        try {
            filename = userhome + File.separator + ".fmj.resource";
            ris = Resource.getResourceStream(new File(filename));
        }
        catch (Throwable t) {
            filename = null;
            return null;
        }
        return ris;
    }

    public static final synchronized Object get(String key) {
        if (key != null) {
            return hash.get(key);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Format[] getDB(Format input) {
        Object object = fmtTblSync;
        synchronized (object) {
            if (audioFmtTbl == null) {
                Resource.initDB();
            }
            if (input instanceof AudioFormat) {
                return audioFmtTbl.get(input);
            }
            if (input instanceof VideoFormat) {
                return videoFmtTbl.get(input);
            }
            return miscFmtTbl.get(input);
        }
    }

    private static final FileInputStream getResourceStream(File file) throws IOException {
        try {
            if (!file.exists()) {
                return null;
            }
            return new FileInputStream(file.getPath());
        }
        catch (Throwable t) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void initDB() {
        Object object = fmtTblSync;
        synchronized (object) {
            audioFmtTbl = new FormatTable(AUDIO_TBL_SIZE);
            videoFmtTbl = new FormatTable(VIDEO_TBL_SIZE);
            miscFmtTbl = new FormatTable(MISC_TBL_SIZE);
            Resource.loadDB();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void loadDB() {
        Object object = fmtTblSync;
        synchronized (object) {
            Object hit;
            Object value;
            int i;
            Object key = Resource.get(AUDIO_SIZE_KEY);
            int size = key instanceof Integer ? (Integer)key : 0;
            if (size > AUDIO_TBL_SIZE) {
                System.err.println("Resource file is corrupted");
                size = AUDIO_TBL_SIZE;
            }
            Resource.audioFmtTbl.last = size;
            for (i = 0; i < size; ++i) {
                key = Resource.get(AUDIO_INPUT_KEY + i);
                value = Resource.get(AUDIO_FORMAT_KEY + i);
                hit = Resource.get(AUDIO_HIT_KEY + i);
                if (!(key instanceof Format && value instanceof Format[] && hit instanceof Integer)) {
                    System.err.println("Resource file is corrupted");
                    Resource.audioFmtTbl.last = 0;
                    break;
                }
                Resource.audioFmtTbl.keys[i] = (Format)key;
                Resource.audioFmtTbl.table[i] = (Format[])value;
                Resource.audioFmtTbl.hits[i] = (Integer)hit;
            }
            if ((size = (key = Resource.get(VIDEO_SIZE_KEY)) instanceof Integer ? (Integer)key : 0) > VIDEO_TBL_SIZE) {
                System.err.println("Resource file is corrupted");
                size = VIDEO_TBL_SIZE;
            }
            Resource.videoFmtTbl.last = size;
            for (i = 0; i < size; ++i) {
                key = Resource.get(VIDEO_INPUT_KEY + i);
                value = Resource.get(VIDEO_FORMAT_KEY + i);
                hit = Resource.get(VIDEO_HIT_KEY + i);
                if (!(key instanceof Format && value instanceof Format[] && hit instanceof Integer)) {
                    System.err.println("Resource file is corrupted");
                    Resource.videoFmtTbl.last = 0;
                    break;
                }
                Resource.videoFmtTbl.keys[i] = (Format)key;
                Resource.videoFmtTbl.table[i] = (Format[])value;
                Resource.videoFmtTbl.hits[i] = (Integer)hit;
            }
            if ((size = (key = Resource.get(MISC_SIZE_KEY)) instanceof Integer ? (Integer)key : 0) > MISC_TBL_SIZE) {
                System.err.println("Resource file is corrupted");
                size = MISC_TBL_SIZE;
            }
            Resource.miscFmtTbl.last = size;
            for (i = 0; i < size; ++i) {
                key = Resource.get(MISC_INPUT_KEY + i);
                value = Resource.get(MISC_FORMAT_KEY + i);
                hit = Resource.get(MISC_HIT_KEY + i);
                if (!(key instanceof Format && value instanceof Format[] && hit instanceof Integer)) {
                    System.err.println("Resource file is corrupted");
                    Resource.miscFmtTbl.last = 0;
                    break;
                }
                Resource.miscFmtTbl.keys[i] = (Format)key;
                Resource.miscFmtTbl.table[i] = (Format[])value;
                Resource.miscFmtTbl.hits[i] = (Integer)hit;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void purgeDB() {
        Object object = fmtTblSync;
        synchronized (object) {
            if (audioFmtTbl == null) {
                return;
            }
            audioFmtTbl = new FormatTable(AUDIO_TBL_SIZE);
            videoFmtTbl = new FormatTable(VIDEO_TBL_SIZE);
            miscFmtTbl = new FormatTable(MISC_TBL_SIZE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Format[] putDB(Format input, Format[] supported) {
        Object object = fmtTblSync;
        synchronized (object) {
            Format in = input.relax();
            Format[] list = new Format[supported.length];
            for (int i = 0; i < supported.length; ++i) {
                list[i] = supported[i].relax();
            }
            if (in instanceof AudioFormat) {
                audioFmtTbl.save(in, list);
            } else if (in instanceof VideoFormat) {
                videoFmtTbl.save(in, list);
            } else {
                miscFmtTbl.save(in, list);
            }
            needSaving = true;
            return list;
        }
    }

    private static final synchronized boolean readResource(InputStream ris) {
        if (ris == null) {
            return false;
        }
        try {
            ObjectInputStream ois = new ObjectInputStream(ris);
            int tableSize = ois.readInt();
            int version = ois.readInt();
            if (version > 200) {
                System.err.println("Version number mismatch.\nThere could be errors in reading the resource");
            }
            hash = new Hashtable();
            for (int i = 0; i < tableSize; ++i) {
                String key = ois.readUTF();
                boolean failed = false;
                try {
                    Object value = ois.readObject();
                    hash.put(key, value);
                    continue;
                }
                catch (ClassNotFoundException cnfe) {
                    failed = true;
                    continue;
                }
                catch (OptionalDataException ode) {
                    failed = true;
                }
            }
            ois.close();
            ris.close();
        }
        catch (IOException ioe) {
            System.err.println("IOException in readResource: " + ioe);
        }
        finally {
            return false;
        }
        return true;
    }

    public static final synchronized boolean remove(String key) {
        if (key != null && hash.containsKey(key)) {
            hash.remove(key);
            return true;
        }
        return false;
    }

    public static final synchronized void removeGroup(String keyStart) {
        Vector<String> keys = new Vector<String>();
        if (keyStart != null) {
            Enumeration e = hash.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!key.startsWith(keyStart)) continue;
                keys.addElement(key);
            }
        }
        for (int i = 0; i < keys.size(); ++i) {
            hash.remove(keys.elementAt(i));
        }
    }

    public static final synchronized void reset() {
        hash = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void saveDB() {
        Object object = fmtTblSync;
        synchronized (object) {
            int i;
            if (!needSaving) {
                return;
            }
            Resource.reset();
            Resource.set(AUDIO_SIZE_KEY, new Integer(Resource.audioFmtTbl.last));
            for (i = 0; i < Resource.audioFmtTbl.last; ++i) {
                Resource.set(AUDIO_INPUT_KEY + i, Resource.audioFmtTbl.keys[i]);
                Resource.set(AUDIO_FORMAT_KEY + i, Resource.audioFmtTbl.table[i]);
                Resource.set(AUDIO_HIT_KEY + i, new Integer(Resource.audioFmtTbl.hits[i]));
            }
            Resource.set(VIDEO_SIZE_KEY, new Integer(Resource.videoFmtTbl.last));
            for (i = 0; i < Resource.videoFmtTbl.last; ++i) {
                Resource.set(VIDEO_INPUT_KEY + i, Resource.videoFmtTbl.keys[i]);
                Resource.set(VIDEO_FORMAT_KEY + i, Resource.videoFmtTbl.table[i]);
                Resource.set(VIDEO_HIT_KEY + i, new Integer(Resource.videoFmtTbl.hits[i]));
            }
            Resource.set(MISC_SIZE_KEY, new Integer(Resource.miscFmtTbl.last));
            for (i = 0; i < Resource.miscFmtTbl.last; ++i) {
                Resource.set(MISC_INPUT_KEY + i, Resource.miscFmtTbl.keys[i]);
                Resource.set(MISC_FORMAT_KEY + i, Resource.miscFmtTbl.table[i]);
                Resource.set(MISC_HIT_KEY + i, new Integer(Resource.miscFmtTbl.hits[i]));
            }
            try {
                Resource.commit();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            needSaving = false;
        }
    }

    public static final synchronized boolean set(String key, Object value) {
        if (key != null && value != null) {
            hash.put(key, value);
            return true;
        }
        return false;
    }

    static {
        hash = new Hashtable();
        boolean securityPrivelege = true;
        try {
            if (securityPrivelege) {
                userhome = System.getProperty(USERHOME);
            }
        }
        catch (Exception e) {
            userhome = null;
            securityPrivelege = false;
        }
        if (userhome == null) {
            securityPrivelege = false;
        }
        InputStream is = null;
        if (securityPrivelege && (is = Resource.findResourceFile()) == null) {
            securityPrivelege = false;
        }
        if (!Resource.readResource(is)) {
            hash = new Hashtable();
        }
        fmtTblSync = new Object();
        AUDIO_TBL_SIZE = 40;
        VIDEO_TBL_SIZE = 20;
        MISC_TBL_SIZE = 10;
        AUDIO_SIZE_KEY = "ATS";
        AUDIO_INPUT_KEY = "AI.";
        AUDIO_FORMAT_KEY = "AF.";
        AUDIO_HIT_KEY = "AH.";
        VIDEO_SIZE_KEY = "VTS";
        VIDEO_INPUT_KEY = "VI.";
        VIDEO_FORMAT_KEY = "VF.";
        VIDEO_HIT_KEY = "VH.";
        MISC_SIZE_KEY = "MTS";
        MISC_INPUT_KEY = "MI.";
        MISC_FORMAT_KEY = "MF.";
        MISC_HIT_KEY = "MH.";
        needSaving = false;
    }
}

