/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.media.rtp.SessionAddress;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.RTPLevelRelayType;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.SourcePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.DtlsFingerprintPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.IceUdpTransportPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.PayloadTypePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RawUdpTransportPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.jinglesdp.JingleUtils;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.sf.fmj.media.rtp.GenerateSSRCCause;
import org.ice4j.socket.DatagramPacketFilter;
import org.jitsi.impl.neomedia.MediaStreamImpl;
import org.jitsi.impl.neomedia.RTPConnectorInputStream;
import org.jitsi.impl.neomedia.RTPTranslatorImpl;
import org.jitsi.impl.neomedia.transform.zrtp.ZrtpRawPacket;
import org.jitsi.service.neomedia.AudioMediaStream;
import org.jitsi.service.neomedia.DtlsControl;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.MediaService;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.MediaStreamTarget;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.RTPExtension;
import org.jitsi.service.neomedia.SSRCFactory;
import org.jitsi.service.neomedia.SrtpControl;
import org.jitsi.service.neomedia.SrtpControlType;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.service.neomedia.device.MediaDevice;
import org.jitsi.service.neomedia.event.SimpleAudioLevelListener;
import org.jitsi.service.neomedia.format.MediaFormat;
import org.jitsi.util.Logger;
import org.jitsi.util.event.PropertyChangeNotifier;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Content;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.IceUdpTransportManager;
import org.jitsi.videobridge.RawUdpTransportManager;
import org.jitsi.videobridge.TransportManager;
import org.jitsi.videobridge.Videobridge;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.PacketExtension;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Channel
extends PropertyChangeNotifier {
    private static final Logger logger = Logger.getLogger(Channel.class);
    public static final int DEFAULT_EXPIRE = 60;
    private static final ExecutorService executorService = Executors.newCachedThreadPool();
    public static final String INITIATOR_PROPERTY = "initiator";
    private static final long[] NO_RECEIVE_SSRCS = new long[0];
    private final Content content;
    private Endpoint endpoint;
    private int expire = 60;
    private boolean expired = false;
    private final String id;
    private final long initialLocalSSRC;
    private boolean initiator = true;
    private long lastActivityTime;
    private Integer lastN;
    private long[] receiveSSRCs = NO_RECEIVE_SSRCS;
    private final RTPLevelRelayType rtpLevelRelayType;
    private final SSRCFactoryImpl ssrcFactory = new SSRCFactoryImpl();
    private final MediaStream stream;
    private SimpleAudioLevelListener streamAudioLevelListener;
    private final PropertyChangeListener streamPropertyChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent ev) {
            Channel.this.streamPropertyChange(ev);
        }
    };
    private final SessionAddress streamTarget = new SessionAddress();
    private TransportManager transportManager;
    private final Object transportManagerSyncRoot = new Object();
    private WrapupConnectivityEstablishmentCommand wrapupConnectivityEstablishmentCommand;

    private static void logd(String s) {
        logger.info((Object)s);
    }

    public Channel(Content content, String id) throws Exception {
        if (content == null) {
            throw new NullPointerException("content");
        }
        if (id == null) {
            throw new NullPointerException("id");
        }
        this.content = content;
        this.id = id;
        MediaType mediaType = this.content.getMediaType();
        this.rtpLevelRelayType = MediaType.AUDIO.equals((Object)mediaType) ? RTPLevelRelayType.MIXER : RTPLevelRelayType.TRANSLATOR;
        MediaService mediaService = this.getMediaService();
        this.stream = mediaService.createMediaStream(null, mediaType, mediaService.createSrtpControl(SrtpControlType.DTLS_SRTP));
        this.stream.addPropertyChangeListener(this.streamPropertyChangeListener);
        this.stream.setName(this.id);
        this.stream.setSSRCFactory((SSRCFactory)this.ssrcFactory);
        switch (this.getRTPLevelRelayType()) {
            case MIXER: {
                MediaDevice device = this.content.getMixer();
                this.stream.setDevice(device);
                if (MediaType.AUDIO.equals((Object)mediaType)) {
                    List rtpExtensions = device.getSupportedExtensions();
                    if (rtpExtensions.size() == 1) {
                        this.stream.addRTPExtension((byte)1, (RTPExtension)rtpExtensions.get(0));
                    }
                    ((AudioMediaStream)this.stream).setStreamAudioLevelListener(this.getStreamAudioLevelListener());
                }
                this.stream.setDirection(MediaDirection.RECVONLY);
                this.initialLocalSSRC = (long)this.ssrcFactory.doGenerateSSRC() & 0xFFFFFFFFL;
                break;
            }
            case TRANSLATOR: {
                this.initialLocalSSRC = -1L;
                this.stream.setRTPTranslator(this.content.getRTPTranslator());
                break;
            }
            default: {
                throw new IllegalStateException("rtpLevelRelayType");
            }
        }
        this.touch();
    }

    private boolean acceptControlInputStreamDatagramPacket(DatagramPacket p) {
        boolean accept;
        InetAddress ctrlAddr = this.streamTarget.getControlAddress();
        int ctrlPort = this.streamTarget.getControlPort();
        if (ctrlAddr == null) {
            this.streamTarget.setControlHostAddress(p.getAddress());
            this.streamTarget.setControlPort(p.getPort());
            InetAddress dataAddr = this.streamTarget.getDataAddress();
            int dataPort = this.streamTarget.getDataPort();
            if (dataAddr != null) {
                ctrlAddr = this.streamTarget.getControlAddress();
                ctrlPort = this.streamTarget.getControlPort();
                this.stream.setTarget(new MediaStreamTarget(dataAddr, dataPort, ctrlAddr, ctrlPort));
            }
            accept = true;
        } else {
            boolean bl = accept = ctrlAddr.equals(p.getAddress()) && ctrlPort == p.getPort();
        }
        if (accept) {
            int ssrc;
            int sc;
            int offset;
            byte[] data;
            byte b0;
            this.touch();
            if (p.getLength() > 8 && ((b0 = (data = p.getData())[offset = p.getOffset()]) & 0xC0) >>> 6 == 2 && (data[offset + 1] & 0xFF) == 203 && (sc = b0 & 0x1F) > 0 && this.removeReceiveSSRC(ssrc = RTPTranslatorImpl.readInt((byte[])data, (int)(offset + 4)))) {
                this.notifyFocus();
            }
        }
        return accept;
    }

    private boolean acceptDataInputStreamDatagramPacket(DatagramPacket p) {
        boolean accept;
        InetAddress dataAddr = this.streamTarget.getDataAddress();
        int dataPort = this.streamTarget.getDataPort();
        if (dataAddr == null) {
            this.streamTarget.setDataHostAddress(p.getAddress());
            this.streamTarget.setDataPort(p.getPort());
            dataAddr = this.streamTarget.getDataAddress();
            dataPort = this.streamTarget.getDataPort();
            InetAddress ctrlAddr = this.streamTarget.getControlAddress();
            int ctrlPort = this.streamTarget.getControlPort();
            MediaStreamTarget newStreamTarget = ctrlAddr == null ? new MediaStreamTarget(new InetSocketAddress(dataAddr, dataPort), null) : new MediaStreamTarget(dataAddr, dataPort, ctrlAddr, ctrlPort);
            this.stream.setTarget(newStreamTarget);
            accept = true;
        } else {
            boolean bl = accept = dataAddr.equals(p.getAddress()) && dataPort == p.getPort();
        }
        if (accept) {
            this.touch();
            if (p.getLength() >= 12) {
                int off;
                byte[] data = p.getData();
                int v = (data[off = p.getOffset()] & 0xC0) >>> 6;
                if (v == 0) {
                    byte[] zrtpMagicCookie;
                    if ((data[off] & 0x10) == 16 && data[off + 4] == (zrtpMagicCookie = ZrtpRawPacket.ZRTP_MAGIC)[0] && data[off + 5] == zrtpMagicCookie[1] && data[off + 6] == zrtpMagicCookie[2] && data[off + 7] == zrtpMagicCookie[3]) {
                        accept = false;
                    }
                } else if (v == 2) {
                    int pt;
                    MediaFormat format;
                    Map payloadTypes;
                    int ssrc = RTPTranslatorImpl.readInt((byte[])data, (int)(off + 8));
                    boolean notify = this.addReceiveSSRC(ssrc);
                    if (RTPLevelRelayType.MIXER.equals((Object)this.getRTPLevelRelayType()) && (payloadTypes = this.stream.getDynamicRTPPayloadTypes()) != null && (format = (MediaFormat)payloadTypes.get((byte)(pt = data[off + 1] & 0x7F))) != null && !format.equals(this.stream.getFormat())) {
                        this.stream.setFormat(format);
                        this.stream.setDirection(MediaDirection.SENDRECV);
                        notify = true;
                    }
                    if (notify) {
                        this.notifyFocus();
                    }
                }
            }
        }
        return accept;
    }

    private synchronized boolean addReceiveSSRC(int receiveSSRC) {
        long now = System.currentTimeMillis();
        int length = this.receiveSSRCs.length;
        for (int i = 0; i < length; i += 2) {
            if ((int)this.receiveSSRCs[i] != receiveSSRC) continue;
            this.receiveSSRCs[i + 1] = now;
            return false;
        }
        long[] newReceiveSSRCs = new long[length + 2];
        System.arraycopy(this.receiveSSRCs, 0, newReceiveSSRCs, 0, length);
        newReceiveSSRCs[length] = 0xFFFFFFFFL & (long)receiveSSRC;
        newReceiveSSRCs[length + 1] = now;
        this.receiveSSRCs = newReceiveSSRCs;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StreamConnector createStreamConnector() throws IOException {
        Object object = this.transportManagerSyncRoot;
        synchronized (object) {
            TransportManager transportManager = this.transportManager;
            return transportManager == null ? null : transportManager.getStreamConnector();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaStreamTarget createStreamTarget() {
        Object object = this.transportManagerSyncRoot;
        synchronized (object) {
            TransportManager transportManager = this.transportManager;
            return transportManager == null ? null : transportManager.getStreamTarget();
        }
    }

    private TransportManager createTransportManager(String xmlNamespace) throws IOException {
        if ("urn:xmpp:jingle:transports:ice-udp:1".equals(xmlNamespace)) {
            return new IceUdpTransportManager(this);
        }
        if ("urn:xmpp:jingle:transports:raw-udp:1".equals(xmlNamespace)) {
            return new RawUdpTransportManager(this);
        }
        throw new IllegalArgumentException("Unsupported Jingle transport " + xmlNamespace);
    }

    public void describe(ColibriConferenceIQ.Channel iq) {
        iq.setDirection(this.stream.getDirection());
        Endpoint endpoint = this.getEndpoint();
        if (endpoint != null) {
            iq.setEndpoint(endpoint.getID());
        }
        iq.setExpire(this.getExpire());
        iq.setID(this.getID());
        iq.setInitiator(Boolean.valueOf(this.isInitiator()));
        iq.setLastN(this.lastN);
        iq.setRTPLevelRelayType(this.rtpLevelRelayType);
        if (this.initialLocalSSRC != -1L) {
            SourcePacketExtension source = new SourcePacketExtension();
            source.setSSRC(this.initialLocalSSRC);
            iq.addSource(source);
        }
        iq.setSSRCs(this.getReceiveSSRCs());
        this.describeTransportManager(iq);
        this.describeSrtpControl(iq);
    }

    private void describeSrtpControl(ColibriConferenceIQ.Channel iq) {
        SrtpControl srtpControl = this.stream.getSrtpControl();
        if (srtpControl instanceof DtlsControl) {
            DtlsFingerprintPacketExtension fingerprintPE;
            DtlsControl dtlsControl = (DtlsControl)srtpControl;
            String fingerprint = dtlsControl.getLocalFingerprint();
            String hash = dtlsControl.getLocalFingerprintHashFunction();
            IceUdpTransportPacketExtension transportPE = iq.getTransport();
            if (transportPE == null) {
                transportPE = new RawUdpTransportPacketExtension();
                iq.setTransport(transportPE);
            }
            if ((fingerprintPE = (DtlsFingerprintPacketExtension)transportPE.getFirstChildOfType(DtlsFingerprintPacketExtension.class)) == null) {
                fingerprintPE = new DtlsFingerprintPacketExtension();
                transportPE.addChildExtension((PacketExtension)fingerprintPE);
            }
            fingerprintPE.setFingerprint(fingerprint);
            fingerprintPE.setHash(hash);
        }
    }

    private void describeTransportManager(ColibriConferenceIQ.Channel iq) {
        TransportManager transportManager;
        try {
            transportManager = this.getTransportManager();
        }
        catch (IOException ioe) {
            throw new UndeclaredThrowableException(ioe);
        }
        if (transportManager != null) {
            transportManager.describe(iq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire() {
        Object v1;
        Conference conference22;
        Channel channel = this;
        synchronized (channel) {
            if (this.expired) {
                return;
            }
            this.expired = true;
        }
        Content content = this.getContent();
        try {
            content.expireChannel(this);
            Object var4_3 = null;
            conference22 = content.getConference();
        }
        catch (Throwable throwable) {
            Conference conference22;
            block27: {
                Object v0;
                Object var4_4 = null;
                conference22 = content.getConference();
                try {
                    try {
                        this.stream.close();
                        this.stream.removePropertyChangeListener(this.streamPropertyChangeListener);
                        v0 = null;
                    }
                    catch (Throwable t) {
                        logger.warn((Object)("Failed to close the MediaStream/stream of channel " + this.getID() + " of content " + content.getName() + " of conference " + conference22.getID() + "!"), t);
                        if (t instanceof ThreadDeath) {
                            throw (ThreadDeath)t;
                        }
                        v0 = null;
                    }
                }
                catch (Throwable throwable2) {
                    v0 = null;
                }
                Object var8_12 = v0;
                try {
                    Object object = this.transportManagerSyncRoot;
                    synchronized (object) {
                        this.wrapupConnectivityEstablishmentCommand = null;
                        if (this.transportManager != null) {
                            this.transportManager.close();
                        }
                    }
                }
                catch (Throwable t2) {
                    logger.warn((Object)("Failed to close the TransportManager/transportManager of channel " + this.getID() + " of content " + content.getName() + " of conference " + conference22.getID() + "!"), t2);
                    if (!(t2 instanceof ThreadDeath)) break block27;
                    throw (ThreadDeath)t2;
                }
            }
            Videobridge videobridge = conference22.getVideobridge();
            Channel.logd("Expired channel " + this.getID() + " of content " + content.getName() + " of conference " + conference22.getID() + ". The total number of conferences is now " + videobridge.getConferenceCount() + ", channels " + videobridge.getChannelCount() + ".");
            throw throwable;
        }
        try {
            try {
                this.stream.close();
                this.stream.removePropertyChangeListener(this.streamPropertyChangeListener);
                v1 = null;
            }
            catch (Throwable t) {
                logger.warn((Object)("Failed to close the MediaStream/stream of channel " + this.getID() + " of content " + content.getName() + " of conference " + conference22.getID() + "!"), t);
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                v1 = null;
            }
        }
        catch (Throwable throwable) {
            v1 = null;
        }
        Object var8_11 = v1;
        try {
            Object object = this.transportManagerSyncRoot;
            synchronized (object) {
                this.wrapupConnectivityEstablishmentCommand = null;
                if (this.transportManager != null) {
                    this.transportManager.close();
                }
            }
        }
        catch (Throwable t2) {
            logger.warn((Object)("Failed to close the TransportManager/transportManager of channel " + this.getID() + " of content " + content.getName() + " of conference " + conference22.getID() + "!"), t2);
            if (t2 instanceof ThreadDeath) {
                throw (ThreadDeath)t2;
            }
        }
        Videobridge videobridge = conference22.getVideobridge();
        Channel.logd("Expired channel " + this.getID() + " of content " + content.getName() + " of conference " + conference22.getID() + ". The total number of conferences is now " + videobridge.getConferenceCount() + ", channels " + videobridge.getChannelCount() + ".");
    }

    public final MediaStream getMediaStream() {
        return this.stream;
    }

    public final Content getContent() {
        return this.content;
    }

    public BundleContext getBundleContext() {
        return this.getContent().getBundleContext();
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public int getExpire() {
        return this.expire;
    }

    public final String getID() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastActivityTime() {
        Channel channel = this;
        synchronized (channel) {
            return this.lastActivityTime;
        }
    }

    private MediaService getMediaService() {
        return this.getContent().getMediaService();
    }

    public synchronized int[] getReceiveSSRCs() {
        int length = this.receiveSSRCs.length;
        if (length == 0) {
            return ColibriConferenceIQ.NO_SSRCS;
        }
        int[] receiveSSRCs = new int[length / 2];
        int src = 0;
        int dst = 0;
        while (src < length) {
            receiveSSRCs[dst] = (int)this.receiveSSRCs[src];
            src += 2;
            ++dst;
        }
        return receiveSSRCs;
    }

    public RTPLevelRelayType getRTPLevelRelayType() {
        return this.rtpLevelRelayType;
    }

    private SimpleAudioLevelListener getStreamAudioLevelListener() {
        if (this.streamAudioLevelListener == null) {
            this.streamAudioLevelListener = new SimpleAudioLevelListener(){

                public void audioLevelChanged(int level) {
                    Channel.this.streamAudioLevelChanged(level);
                }
            };
        }
        return this.streamAudioLevelListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransportManager getTransportManager() throws IOException {
        Object object = this.transportManagerSyncRoot;
        synchronized (object) {
            if (this.transportManager == null) {
                this.wrapupConnectivityEstablishmentCommand = null;
                this.transportManager = this.createTransportManager(this.getContent().getConference().getVideobridge().getDefaultTransportManager());
                if ("urn:xmpp:jingle:transports:raw-udp:1".equals(this.transportManager.getXmlNamespace())) {
                    this.maybeStartStream();
                }
            }
            return this.transportManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExpired() {
        Channel channel = this;
        synchronized (channel) {
            return this.expired;
        }
    }

    public boolean isInitiator() {
        return this.initiator;
    }

    private void maybeStartStream() throws IOException {
        StreamConnector connector = this.createStreamConnector();
        if (connector == null) {
            return;
        }
        this.stream.setConnector(connector);
        MediaStreamTarget streamTarget = this.createStreamTarget();
        if (streamTarget != null) {
            InetSocketAddress ctrlAddr;
            InetSocketAddress dataAddr = streamTarget.getDataAddress();
            if (dataAddr != null) {
                this.streamTarget.setDataHostAddress(dataAddr.getAddress());
                this.streamTarget.setDataPort(dataAddr.getPort());
            }
            if ((ctrlAddr = streamTarget.getControlAddress()) != null) {
                this.streamTarget.setControlHostAddress(ctrlAddr.getAddress());
                this.streamTarget.setControlPort(ctrlAddr.getPort());
            }
            if (dataAddr != null) {
                this.stream.setTarget(streamTarget);
            }
        }
        Content content = this.getContent();
        if (!this.stream.isStarted()) {
            SrtpControl srtpControl = this.stream.getSrtpControl();
            if (srtpControl != null) {
                if (srtpControl instanceof DtlsControl) {
                    DtlsControl dtlsControl = (DtlsControl)srtpControl;
                    dtlsControl.setSetup(this.isInitiator() ? DtlsControl.Setup.PASSIVE : DtlsControl.Setup.ACTIVE);
                }
                srtpControl.start(content.getMediaType());
            }
            this.stream.start();
        }
        Channel.logd("Direction of channel " + this.getID() + " of content " + content.getName() + " of conference " + content.getConference().getID() + " is " + this.stream.getDirection() + ".");
        this.touch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFocus() {
        boolean interrupted = false;
        try {
            try {
                Content content = this.getContent();
                Conference conference = content.getConference();
                ColibriConferenceIQ conferenceIQ = new ColibriConferenceIQ();
                conference.describe(conferenceIQ);
                ColibriConferenceIQ.Content contentIQ = conferenceIQ.getOrCreateContent(content.getName());
                ColibriConferenceIQ.Channel channelIQ = new ColibriConferenceIQ.Channel();
                this.describe(channelIQ);
                contentIQ.addChannel(channelIQ);
                conferenceIQ.setTo(conference.getFocus());
                conferenceIQ.setType(IQ.Type.SET);
                conference.getVideobridge().getComponent().send((IQ)conferenceIQ);
            }
            catch (Throwable t) {
                if (t instanceof InterruptedException) {
                    interrupted = true;
                } else if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                Object var8_9 = null;
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            Object var8_8 = null;
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            throw throwable;
        }
    }

    private synchronized boolean removeReceiveSSRC(int receiveSSRC) {
        boolean removed;
        block4: {
            int length;
            block3: {
                length = this.receiveSSRCs.length;
                removed = false;
                if (length != 2) break block3;
                if ((int)this.receiveSSRCs[0] != receiveSSRC) break block4;
                this.receiveSSRCs = NO_RECEIVE_SSRCS;
                removed = true;
                break block4;
            }
            for (int i = 0; i < length; i += 2) {
                if ((int)this.receiveSSRCs[i] != receiveSSRC) continue;
                long[] newReceiveSSRCs = new long[length - 2];
                if (i != 0) {
                    System.arraycopy(this.receiveSSRCs, 0, newReceiveSSRCs, 0, i);
                }
                if (i != newReceiveSSRCs.length) {
                    System.arraycopy(this.receiveSSRCs, i + 2, newReceiveSSRCs, i, newReceiveSSRCs.length - i);
                }
                removed = true;
                break;
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInWrapupConnectivityEstablishmentCommand(WrapupConnectivityEstablishmentCommand wrapupConnectivityEstablishmentCommand) {
        TransportManager transportManager = wrapupConnectivityEstablishmentCommand.transportManager;
        Object object = this.transportManagerSyncRoot;
        synchronized (object) {
            if (transportManager != this.transportManager) {
                return;
            }
            if (wrapupConnectivityEstablishmentCommand != this.wrapupConnectivityEstablishmentCommand) {
                return;
            }
            if (this.isExpired()) {
                return;
            }
        }
        try {
            transportManager.wrapupConnectivityEstablishment();
        }
        catch (OperationFailedException ofe) {
            Content content = this.getContent();
            logger.error((Object)("Failed to wrapup the connectivity establishment of the TransportManager/transportManager of channel " + this.getID() + " of content " + content.getName() + " of conference " + content.getConference().getID() + "!"), (Throwable)ofe);
            return;
        }
        object = this.transportManagerSyncRoot;
        synchronized (object) {
            if (transportManager != this.transportManager) {
                return;
            }
            if (wrapupConnectivityEstablishmentCommand != this.wrapupConnectivityEstablishmentCommand) {
                return;
            }
            if (this.isExpired()) {
                return;
            }
            try {
                this.maybeStartStream();
            }
            catch (IOException ioe) {
                Content content = this.getContent();
                logger.error((Object)("Failed to start the MediaStream/stream of channel " + this.getID() + " of content " + content.getName() + " of conference " + content.getConference().getID() + "!"), (Throwable)ioe);
            }
        }
    }

    public void setDirection(MediaDirection direction) {
        if (this.streamTarget.getDataAddress() != null) {
            this.stream.setDirection(direction);
        }
        this.touch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setEndpoint(String endpoint) {
        block9: {
            block8: {
                try {
                    Endpoint newValue;
                    Endpoint oldValue = this.endpoint;
                    if (oldValue == null) {
                        if (endpoint == null) {
                            Object var5_3 = null;
                            this.touch();
                            return;
                        }
                    } else if (oldValue.getID().equals(endpoint)) {
                        break block8;
                    }
                    if (oldValue == (newValue = this.getContent().getConference().getOrCreateEndpoint(endpoint))) break block9;
                    if (oldValue != null) {
                        oldValue.removeChannel(this);
                    }
                    this.endpoint = newValue;
                    if (newValue != null) {
                        newValue.addChannel(this);
                    }
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    this.touch();
                    throw throwable;
                }
            }
            Object var5_4 = null;
            this.touch();
            return;
        }
        Object var5_5 = null;
        this.touch();
    }

    public void setExpire(int expire) {
        if (expire < 0) {
            throw new IllegalArgumentException("expire");
        }
        this.expire = expire;
        if (this.expire == 0) {
            this.expire();
        } else {
            this.touch();
        }
    }

    public void setInitiator(boolean initiator) {
        boolean oldValue = this.initiator;
        boolean newValue = this.initiator = initiator;
        this.touch();
        if (oldValue != newValue) {
            SrtpControl srtpControl = this.stream.getSrtpControl();
            if (srtpControl instanceof DtlsControl) {
                DtlsControl dtlsControl = (DtlsControl)srtpControl;
                dtlsControl.setSetup(this.isInitiator() ? DtlsControl.Setup.PASSIVE : DtlsControl.Setup.ACTIVE);
            }
            this.firePropertyChange(INITIATOR_PROPERTY, oldValue, newValue);
        }
    }

    public void setLastN(Integer lastN) {
        this.lastN = lastN;
        this.touch();
    }

    public void setPayloadTypes(List<PayloadTypePacketExtension> payloadTypes) {
        MediaService mediaService;
        if (payloadTypes != null && payloadTypes.size() > 0 && (mediaService = this.getMediaService()) != null) {
            boolean googleChrome = false;
            for (PayloadTypePacketExtension payloadType : payloadTypes) {
                MediaFormat mediaFormat = JingleUtils.payloadTypeToMediaFormat((PayloadTypePacketExtension)payloadType, (MediaService)mediaService, null);
                if (mediaFormat == null) {
                    if (googleChrome || !"iSAC".equalsIgnoreCase(payloadType.getName())) continue;
                    googleChrome = true;
                    continue;
                }
                this.stream.addDynamicRTPPayloadType((byte)payloadType.getID(), mediaFormat);
            }
            if (googleChrome && this.stream instanceof AudioMediaStream) {
                URI uri;
                try {
                    uri = new URI("urn:ietf:params:rtp-hdrext:ssrc-audio-level");
                }
                catch (URISyntaxException e) {
                    uri = null;
                }
                if (uri != null) {
                    this.stream.addRTPExtension((byte)1, new RTPExtension(uri));
                }
            }
        }
        this.touch();
    }

    public void setTransport(IceUdpTransportPacketExtension transport) throws IOException {
        if (transport != null) {
            TransportManager transportManager;
            List dfpes;
            this.setTransportManager(transport.getNamespace());
            SrtpControl srtpControl = this.stream.getSrtpControl();
            if (srtpControl instanceof DtlsControl && !(dfpes = transport.getChildExtensionsOfType(DtlsFingerprintPacketExtension.class)).isEmpty()) {
                LinkedHashMap<String, String> remoteFingerprints = new LinkedHashMap<String, String>();
                for (DtlsFingerprintPacketExtension dfpe : dfpes) {
                    remoteFingerprints.put(dfpe.getHash(), dfpe.getFingerprint());
                }
                DtlsControl dtlsControl = (DtlsControl)srtpControl;
                dtlsControl.setRemoteFingerprints(remoteFingerprints);
            }
            if ((transportManager = this.getTransportManager()) != null) {
                if (transportManager.startConnectivityEstablishment(transport)) {
                    this.wrapupConnectivityEstablishment(transportManager);
                } else {
                    this.maybeStartStream();
                }
            }
        }
        this.touch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTransportManager(String xmlNamespace) throws IOException {
        Object object = this.transportManagerSyncRoot;
        synchronized (object) {
            if (this.transportManager != null && !this.transportManager.getXmlNamespace().equals(xmlNamespace)) {
                this.wrapupConnectivityEstablishmentCommand = null;
                this.transportManager.close();
                this.transportManager = null;
            }
            if (this.transportManager == null) {
                this.wrapupConnectivityEstablishmentCommand = null;
                this.transportManager = this.createTransportManager(xmlNamespace);
                Content content = this.getContent();
                Channel.logd("Set " + this.transportManager.getClass().getSimpleName() + " #" + Integer.toHexString(this.transportManager.hashCode()) + " on channel " + this.getID() + " of content " + content.getName() + " of conference " + content.getConference().getID() + ".");
            }
        }
        this.touch();
    }

    private long ssrcFactoryGenerateSSRC(String cause, int i) {
        if (this.initialLocalSSRC != -1L) {
            if (i == 0) {
                return (int)this.initialLocalSSRC;
            }
            if (cause.equals(GenerateSSRCCause.REMOVE_SEND_STREAM.name())) {
                return Long.MAX_VALUE;
            }
        }
        return this.ssrcFactory.doGenerateSSRC();
    }

    private void streamAudioLevelChanged(int level) {
    }

    private void streamPropertyChange(PropertyChangeEvent ev) {
        String rtpConnectorPropertyName;
        Object datagramPacketFilter;
        Object newValue;
        String prefix;
        String propertyName = ev.getPropertyName();
        if (propertyName.startsWith(prefix = MediaStreamImpl.class.getName() + ".rtpConnector.") && (newValue = ev.getNewValue()) instanceof RTPConnectorInputStream && (datagramPacketFilter = (rtpConnectorPropertyName = propertyName.substring(prefix.length())).equals("controlInputStream") ? new DatagramPacketFilter(){

            public boolean accept(DatagramPacket p) {
                return Channel.this.acceptControlInputStreamDatagramPacket(p);
            }
        } : (rtpConnectorPropertyName.equals("dataInputStream") ? new DatagramPacketFilter(){

            public boolean accept(DatagramPacket p) {
                return Channel.this.acceptDataInputStreamDatagramPacket(p);
            }
        } : null)) != null) {
            ((RTPConnectorInputStream)newValue).addDatagramPacketFilter(datagramPacketFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touch() {
        long now = System.currentTimeMillis();
        Channel channel = this;
        synchronized (channel) {
            if (this.getLastActivityTime() < now) {
                this.lastActivityTime = now;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wrapupConnectivityEstablishment(TransportManager transportManager) {
        Object object = this.transportManagerSyncRoot;
        synchronized (object) {
            if (transportManager != this.transportManager) {
                return;
            }
            if (this.wrapupConnectivityEstablishmentCommand != null && this.wrapupConnectivityEstablishmentCommand.transportManager != transportManager) {
                this.wrapupConnectivityEstablishmentCommand = null;
            }
            if (this.wrapupConnectivityEstablishmentCommand == null) {
                this.wrapupConnectivityEstablishmentCommand = new WrapupConnectivityEstablishmentCommand(transportManager);
                boolean execute = false;
                try {
                    executorService.execute(this.wrapupConnectivityEstablishmentCommand);
                    execute = true;
                    Object var5_4 = null;
                    if (!execute) {
                        this.wrapupConnectivityEstablishmentCommand = null;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (!execute) {
                        this.wrapupConnectivityEstablishmentCommand = null;
                    }
                    throw throwable;
                }
            }
        }
    }

    private class WrapupConnectivityEstablishmentCommand
    implements Runnable {
        public final TransportManager transportManager;

        public WrapupConnectivityEstablishmentCommand(TransportManager transportManager) {
            this.transportManager = transportManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Channel.this.runInWrapupConnectivityEstablishmentCommand(this);
            }
            finally {
                Object object = Channel.this.transportManagerSyncRoot;
                synchronized (object) {
                    if (Channel.this.wrapupConnectivityEstablishmentCommand == this) {
                        Channel.this.wrapupConnectivityEstablishmentCommand = null;
                    }
                }
            }
        }
    }

    private class SSRCFactoryImpl
    implements SSRCFactory {
        private int i = 0;
        private final Random random = new Random();

        private SSRCFactoryImpl() {
        }

        public int doGenerateSSRC() {
            return this.random.nextInt();
        }

        public long generateSSRC(String cause) {
            return Channel.this.ssrcFactoryGenerateSSRC(cause, this.i++);
        }
    }
}

