/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import net.java.sip.communicator.service.protocol.ChatRoomConfigurationFormField;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.FormField;

public class ChatRoomConfigurationFormFieldJabberImpl
implements ChatRoomConfigurationFormField {
    private final FormField smackFormField;
    private final FormField smackSubmitFormField;

    public ChatRoomConfigurationFormFieldJabberImpl(FormField formField, Form submitForm) {
        this.smackFormField = formField;
        this.smackSubmitFormField = !formField.getType().equals("fixed") ? submitForm.getField(formField.getVariable()) : null;
    }

    public String getName() {
        return this.smackFormField.getVariable();
    }

    public String getDescription() {
        return this.smackFormField.getDescription();
    }

    public String getLabel() {
        return this.smackFormField.getLabel();
    }

    public Iterator<String> getOptions() {
        ArrayList<String> options = new ArrayList<String>();
        Iterator smackOptions = this.smackFormField.getOptions();
        while (smackOptions.hasNext()) {
            FormField.Option smackOption = (FormField.Option)smackOptions.next();
            options.add(smackOption.getValue());
        }
        return Collections.unmodifiableList(options).iterator();
    }

    public boolean isRequired() {
        return this.smackFormField.isRequired();
    }

    public String getType() {
        String smackType = this.smackFormField.getType();
        if (smackType.equals("boolean")) {
            return "Boolean";
        }
        if (smackType.equals("fixed")) {
            return "FixedText";
        }
        if (smackType.equals("text-private")) {
            return "PrivateText";
        }
        if (smackType.equals("text-single")) {
            return "SingleLineText";
        }
        if (smackType.equals("text-multi")) {
            return "MultipleLinesText";
        }
        if (smackType.equals("list-single")) {
            return "ListSingleChoice";
        }
        if (smackType.equals("list-multi")) {
            return "ListMultiChoice";
        }
        if (smackType.equals("jid-single")) {
            return "SingleIDChoice";
        }
        if (smackType.equals("jid-multi")) {
            return "MultiIDChoice";
        }
        return "Undefined";
    }

    public Iterator<?> getValues() {
        Iterator valuesIter;
        Iterator smackValues = this.smackFormField.getValues();
        if (this.smackFormField.getType().equals("boolean")) {
            ArrayList<Boolean> values = new ArrayList<Boolean>();
            while (smackValues.hasNext()) {
                String smackValue = (String)smackValues.next();
                values.add(smackValue.equals("1") || smackValue.equals("true") ? Boolean.TRUE : Boolean.FALSE);
            }
            valuesIter = values.iterator();
        } else {
            valuesIter = smackValues;
        }
        return valuesIter;
    }

    public void addValue(Object value) {
        if (value instanceof Boolean) {
            value = (Boolean)value != false ? "1" : "0";
        }
        this.smackSubmitFormField.addValue(value.toString());
    }

    public void setValues(Object[] newValues) {
        ArrayList<String> list = new ArrayList<String>();
        Object[] objectArray = newValues;
        int n = newValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            String stringValue = value instanceof Boolean ? ((Boolean)value != false ? "1" : "0") : (value == null ? null : value.toString());
            list.add(stringValue);
            ++n2;
        }
        this.smackSubmitFormField.addValues(list);
    }
}

