/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.sitemesh.html;

import com.opensymphony.module.sitemesh.html.HTMLProcessorContext;
import com.opensymphony.module.sitemesh.html.State;
import com.opensymphony.module.sitemesh.html.Tag;
import com.opensymphony.module.sitemesh.html.TagRule;
import com.opensymphony.module.sitemesh.html.Text;
import com.opensymphony.module.sitemesh.html.tokenizer.TagTokenizer;
import com.opensymphony.module.sitemesh.html.tokenizer.TokenHandler;
import com.opensymphony.module.sitemesh.html.util.CharArray;
import java.util.LinkedList;

public class HTMLProcessor {
    private final char[] input;
    private final CharArray body;
    private final State defaultState;
    private State currentState;

    public HTMLProcessor(char[] input, CharArray body) {
        this.currentState = this.defaultState = new State();
        this.input = input;
        this.body = body;
    }

    public State defaultState() {
        return this.defaultState;
    }

    public void process() {
        TagTokenizer tokenizer = new TagTokenizer(this.input);
        final HTMLProcessorContext context = new HTMLProcessorContext(){
            private LinkedList bufferStack = new LinkedList();

            public State currentState() {
                return HTMLProcessor.this.currentState;
            }

            public void changeState(State newState) {
                HTMLProcessor.this.currentState = newState;
            }

            public void pushBuffer(CharArray buffer) {
                this.bufferStack.add(buffer);
            }

            public CharArray currentBuffer() {
                return (CharArray)this.bufferStack.getLast();
            }

            public CharArray popBuffer() {
                return (CharArray)this.bufferStack.removeLast();
            }

            public void mergeBuffer() {
                CharArray top = (CharArray)this.bufferStack.getLast();
                CharArray nextDown = (CharArray)this.bufferStack.get(this.bufferStack.size() - 2);
                nextDown.append(top);
            }
        };
        context.pushBuffer(this.body);
        tokenizer.start(new TokenHandler(){

            public boolean shouldProcessTag(String name) {
                return HTMLProcessor.this.currentState.shouldProcessTag(name);
            }

            public void tag(Tag tag) {
                TagRule tagRule = HTMLProcessor.this.currentState.getRule(tag.getName());
                tagRule.setContext(context);
                tagRule.process(tag);
            }

            public void text(Text text) {
                text.writeTo(context.currentBuffer());
            }

            public void warning(String message, int line, int column) {
            }
        });
        this.defaultState.endOfState();
    }
}

