/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser;

import java.util.Vector;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;

public class MultiFieldQueryParser
extends QueryParser {
    private String[] fields;

    public MultiFieldQueryParser(String[] fields, Analyzer analyzer) {
        super(null, analyzer);
        this.fields = fields;
    }

    protected Query getFieldQuery(String field, String queryText, int slop) throws ParseException {
        if (field == null) {
            Vector<BooleanClause> clauses = new Vector<BooleanClause>();
            for (int i = 0; i < this.fields.length; ++i) {
                Query q = super.getFieldQuery(this.fields[i], queryText);
                if (q == null) continue;
                if (q instanceof PhraseQuery) {
                    ((PhraseQuery)q).setSlop(slop);
                }
                if (q instanceof MultiPhraseQuery) {
                    ((MultiPhraseQuery)q).setSlop(slop);
                }
                clauses.add(new BooleanClause(q, BooleanClause.Occur.SHOULD));
            }
            if (clauses.size() == 0) {
                return null;
            }
            return this.getBooleanQuery(clauses, true);
        }
        return super.getFieldQuery(field, queryText);
    }

    protected Query getFieldQuery(String field, String queryText) throws ParseException {
        return this.getFieldQuery(field, queryText, 0);
    }

    protected Query getFuzzyQuery(String field, String termStr, float minSimilarity) throws ParseException {
        if (field == null) {
            Vector<BooleanClause> clauses = new Vector<BooleanClause>();
            for (int i = 0; i < this.fields.length; ++i) {
                clauses.add(new BooleanClause(super.getFuzzyQuery(this.fields[i], termStr, minSimilarity), BooleanClause.Occur.SHOULD));
            }
            return this.getBooleanQuery(clauses, true);
        }
        return super.getFuzzyQuery(field, termStr, minSimilarity);
    }

    protected Query getPrefixQuery(String field, String termStr) throws ParseException {
        if (field == null) {
            Vector<BooleanClause> clauses = new Vector<BooleanClause>();
            for (int i = 0; i < this.fields.length; ++i) {
                clauses.add(new BooleanClause(super.getPrefixQuery(this.fields[i], termStr), BooleanClause.Occur.SHOULD));
            }
            return this.getBooleanQuery(clauses, true);
        }
        return super.getPrefixQuery(field, termStr);
    }

    protected Query getWildcardQuery(String field, String termStr) throws ParseException {
        if (field == null) {
            Vector<BooleanClause> clauses = new Vector<BooleanClause>();
            for (int i = 0; i < this.fields.length; ++i) {
                clauses.add(new BooleanClause(super.getWildcardQuery(this.fields[i], termStr), BooleanClause.Occur.SHOULD));
            }
            return this.getBooleanQuery(clauses, true);
        }
        return super.getWildcardQuery(field, termStr);
    }

    protected Query getRangeQuery(String field, String part1, String part2, boolean inclusive) throws ParseException {
        if (field == null) {
            Vector<BooleanClause> clauses = new Vector<BooleanClause>();
            for (int i = 0; i < this.fields.length; ++i) {
                clauses.add(new BooleanClause(super.getRangeQuery(this.fields[i], part1, part2, inclusive), BooleanClause.Occur.SHOULD));
            }
            return this.getBooleanQuery(clauses, true);
        }
        return super.getRangeQuery(field, part1, part2, inclusive);
    }

    public static Query parse(String[] queries, String[] fields, Analyzer analyzer) throws ParseException {
        if (queries.length != fields.length) {
            throw new IllegalArgumentException("queries.length != fields.length");
        }
        BooleanQuery bQuery = new BooleanQuery();
        for (int i = 0; i < fields.length; ++i) {
            QueryParser qp = new QueryParser(fields[i], analyzer);
            Query q = qp.parse(queries[i]);
            bQuery.add(q, BooleanClause.Occur.SHOULD);
        }
        return bQuery;
    }

    public static Query parse(String query, String[] fields, BooleanClause.Occur[] flags, Analyzer analyzer) throws ParseException {
        if (fields.length != flags.length) {
            throw new IllegalArgumentException("fields.length != flags.length");
        }
        BooleanQuery bQuery = new BooleanQuery();
        for (int i = 0; i < fields.length; ++i) {
            QueryParser qp = new QueryParser(fields[i], analyzer);
            Query q = qp.parse(query);
            bQuery.add(q, flags[i]);
        }
        return bQuery;
    }

    public static Query parse(String[] queries, String[] fields, BooleanClause.Occur[] flags, Analyzer analyzer) throws ParseException {
        if (queries.length != fields.length || queries.length != flags.length) {
            throw new IllegalArgumentException("queries, fields, and flags array have have different length");
        }
        BooleanQuery bQuery = new BooleanQuery();
        for (int i = 0; i < fields.length; ++i) {
            QueryParser qp = new QueryParser(fields[i], analyzer);
            Query q = qp.parse(queries[i]);
            bQuery.add(q, flags[i]);
        }
        return bQuery;
    }
}

