/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts;

import com.sun.speech.freetts.Dumpable;
import com.sun.speech.freetts.FeatureSet;
import com.sun.speech.freetts.util.Utilities;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class FeatureSetImpl
implements FeatureSet {
    private final Map featureMap = new LinkedHashMap();
    static DecimalFormat formatter;

    @Override
    public boolean isPresent(String name) {
        return this.featureMap.containsKey(name);
    }

    @Override
    public void remove(String name) {
        this.featureMap.remove(name);
    }

    @Override
    public String getString(String name) {
        return (String)this.getObject(name);
    }

    @Override
    public int getInt(String name) {
        return (Integer)this.getObject(name);
    }

    @Override
    public float getFloat(String name) {
        return ((Float)this.getObject(name)).floatValue();
    }

    @Override
    public Object getObject(String name) {
        return this.featureMap.get(name);
    }

    @Override
    public void setInt(String name, int value) {
        this.setObject(name, new Integer(value));
    }

    @Override
    public void setFloat(String name, float value) {
        this.setObject(name, new Float(value));
    }

    @Override
    public void setString(String name, String value) {
        this.setObject(name, value);
    }

    @Override
    public void setObject(String name, Object value) {
        this.featureMap.put(name, value);
    }

    @Override
    public void dump(PrintWriter output, int pad, String title) {
        this.dump(output, pad, title, false);
    }

    public void dump(PrintWriter output, int pad, String title, boolean showName) {
        ArrayList keys = new ArrayList(this.featureMap.keySet());
        if (formatter == null) {
            formatter = new DecimalFormat("########0.000000");
        }
        Collections.reverse(keys);
        Utilities.dump(output, pad, title);
        for (String key : keys) {
            if (!showName && key.equals("name")) continue;
            Object value = this.getObject(key);
            if (value instanceof Dumpable) {
                Dumpable d = (Dumpable)value;
                d.dump(output, pad + 4, key);
                continue;
            }
            if (value instanceof Float) {
                Float fval = (Float)value;
                Utilities.dump(output, pad + 4, key + "=" + formatter.format(fval.floatValue()));
                continue;
            }
            Utilities.dump(output, pad + 4, key + "=" + value);
        }
    }
}

